#include "StdAfx.h"
#include "RecConfig.h"

static void RSNET_CALL ParamDataCallback(void* data, void* userParam)
{
	RecConfig* pThis = (RecConfig*)userParam;
	RSNet_RecordSet_t* RecordSet = (RSNet_RecordSet_t*)data;
	pThis->m_RecordSet = *RecordSet;
}

static void RSNET_CALL SoleParamDataCallback(void* data, void* userParam)
{
	RecConfig* pThis = (RecConfig*)userParam;
	RSNet_SoleRecordSet_t* SoleRecordSet = (RSNet_SoleRecordSet_t*)data;
	pThis->m_vec.push_back(*SoleRecordSet);
}

std::string RecConfig::QueryAll(bool bDefault)
{
	//
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param, '\0', sizeof(param));

	memset(&m_RecordSet,'\0', sizeof(RSNet_RecordSet_t));
	m_vec.clear();

	ChannelParamReq req;
	TransformChannelParamReq_All(&req);

	param.ParamType = MsgParamRecord;
	param.Req = &req;

	param.ParamSize = sizeof(RSNet_RecordSet_t);
	param.ParamCallback = ParamDataCallback;

	param.ListParamSize = sizeof(RSNet_SoleRecordSet_t);
	param.ListParamCallback = SoleParamDataCallback;

	param.UserParam = this;

	if(bDefault)
	{
		if(!RSNetQueryDefaultParam(m_pDevice->GetConnection(), &param, MsgDefaultParam))
			return strRet;
	}
	else
	{
		if(!RSNetQueryParam(m_pDevice->GetConnection(), &param))
			return strRet;
	}

	//
	Json::Value root(Json::arrayValue);
	for(int i=0; i<m_vec.size(); i++)
	{
		StructToJson(i);
		root.append(m_obj);
	}

	Json::FastWriter writer;
	strRet = writer.write(root);
	return strRet;
}

void RecConfig::StructToJson(int n)
{
	m_obj.clear();
	m_obj["ch"] = n;

	m_obj["RecordMode"] = m_RecordSet.RecordMode;
	m_obj["PackTime"] = m_RecordSet.PackTime;
	m_obj["PreRecordTime"] = m_RecordSet.PreRecordTime;
	m_obj["RedundanceRec"] = m_RecordSet.RedundanceRec;

	m_obj["ChnCloseOrOpen"] = m_vec[n].ChnCloseOrOpen;
	m_obj["RecordStreamMode"] = m_vec[n].RecordStreamMode;
	m_obj["PreRecSwitch"] = m_vec[n].PreRecSwitch;
	m_obj["RecordAudioEnable"] = m_vec[n].RecordAudioEnable;
}

int RecConfig::SaveAll(std::string strData)
{	
	if(strData == "null"){
		return false;
	}

	Json::Reader reader;
	Json::Value obj;
	if(!reader.parse(strData, obj)){
		return false;
	}

	for(int i=0; i<obj.size(); i++)
	{
		m_vec[i].ChnCloseOrOpen = obj[i]["ChnCloseOrOpen"].asInt();
		m_vec[i].RecordStreamMode = obj[i]["RecordStreamMode"].asInt();
		m_vec[i].PreRecSwitch = obj[i]["PreRecSwitch"].asInt();
		m_vec[i].RecordAudioEnable = obj[i]["RecordAudioEnable"].asInt();
		m_vec[i].StructSize = sizeof(RSNet_SoleRecordSet_t);
	}

	int i = 0;
	int curCh = obj[i]["curCh"].asUInt();
	//ͨ޹ݣֻǰͨ
	m_RecordSet.PackTime = obj[curCh]["PackTime"].asInt();
	m_RecordSet.PreRecordTime = obj[curCh]["PreRecordTime"].asInt();
	m_RecordSet.RecordMode = obj[curCh]["RecordMode"].asInt();
	m_RecordSet.RedundanceRec = obj[curCh]["RedundanceRec"].asInt();
	m_RecordSet.StructSize = sizeof(RSNet_RecordSet_t);

	RSNetSetParamParam param;
	memset(&param, '\0', sizeof(param));
	param.ParamType = MsgParamRecord;
	param.Param = &m_RecordSet;
	param.ListParams = &m_vec[0];
	param.ListParamNum = m_vec.size();
	if (RSNetSetParam(m_pDevice->GetConnection(), &param))
	{
		return  true;
	}
	return false;
}