#include "StdAfx.h"
#include "ShowIntell.h"

static void RSNET_CALL OneDataCallback(void* data, void* userParam)
{
	ShowIntell* pThis = (ShowIntell*)userParam;
	memcpy(&pThis->m_Struct,data,sizeof(RSNet_SoleIntManage_t));
}

std::string ShowIntell::QueryAll(bool bDefault)
{
	//
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param, '\0', sizeof(param));

	memset(&m_Struct, '\0', sizeof(RSNet_SoleIntManage_t));

	ChannelParamReq req;
	TransformChannelParamReq_All(&req);

	param.ParamType = MsgParamIntManage;
	param.Req = &req;

	param.ListParamSize = sizeof(RSNet_SoleIntManage_t);
	param.ListParamCallback = OneDataCallback;
	param.UserParam = this;

	if(!RSNetQueryParam(m_pDevice->GetConnection(), &param))
		return strRet;

	//
	m_obj.clear();
	m_obj["FunSwitchDisplay"] = m_Struct.FunSwitchDisplay;
	m_obj["AlramDisplay"] = m_Struct.AlramDisplay;
	m_obj["RecordDisplay"] = m_Struct.RecordDisplay;
	m_obj["EmailDisplay"] = m_Struct.EmailDisplay;
	m_obj["AlarmOutDisplay"] = m_Struct.AlarmOutDisplay;
	m_obj["SceneDisplay"] = m_Struct.SceneDisplay;
	m_obj["InCountDisplay"] = m_Struct.InCountDisplay;
	m_obj["OutCountDisplay"] = m_Struct.OutCountDisplay;

	//
	Json::FastWriter writer;
	strRet = writer.write(m_obj);
	return strRet;
}