#pragma once
#include "StdAfx.h"
#include "SysInfBase.h"

std::string CSysInfBase::QueryAll(bool isDefault)
{
	//
	std::string strRet = "err";
	
	RSNetQueryParamParamEx param;
	memset(&param,'\0',  sizeof(param));

	memset(&m_BaseInfo,'\0', sizeof(RSNet_SystemBaseInfo_t));
	m_BaseInfo.StructSize = sizeof(RSNet_SystemBaseInfo_t);
	param.Param = &m_BaseInfo;

	param.ParamSize = sizeof(RSNet_SystemBaseInfo_t);
	param.ParamType = MsgParamSystemBase;

	if(isDefault)
	{
		if (!RSNetQueryDefaultParamEx(m_pDevice->GetConnection(), &param,MsgDefaultParam))
			return strRet;
	}
	else
	{
		if (!RSNetQueryParamEx(m_pDevice->GetConnection(), &param))
			return strRet;
	}

	//
		//P2pUID ֻĸ֡л
		bool bToWeb = true;
		for(int i=0; i<40; i++)
		{
			char temp = m_BaseInfo.P2pUID[i];
			if(temp == '\0')
			{
				break;
			}
			else
			{
				if( !((temp>='0' && temp<='9') || (temp>='a' && temp<='z') || (temp>='A' && temp<='Z') || (temp=='-')) )
				{
					bToWeb = false;
					break;
				}
			}
		}
		if(bToWeb==false)
		{
			memset(m_BaseInfo.P2pUID, 0, sizeof(m_BaseInfo.P2pUID));
		}

	m_obj.clear();
	m_obj["StructSize"] = m_BaseInfo.StructSize;
	m_obj["DeviceName"] = (char*)m_BaseInfo.DeviceName;
	m_obj["DeviceID"] = m_BaseInfo.DeviceID;
	m_obj["Port"] = m_BaseInfo.Port;
	m_obj["WebPort"] = m_BaseInfo.WebPort;
	m_obj["DdnsHostStatus"] = (char*)m_BaseInfo.DdnsHostStatus;
	m_obj["HddStatus"] = (char*)m_BaseInfo.HddStatus;
	m_obj["TvSystem"] = m_BaseInfo.TvSystem;
	m_obj["DeviceType"] = (char*)m_BaseInfo.DeviceType;
	m_obj["MacAddr"] = (char*)m_BaseInfo.MacAddr;
	m_obj["SoftwareVer"] = (char*)m_BaseInfo.SoftwareVer;
	m_obj["HardwareVer"] = (char*)m_BaseInfo.HardwareVer;
	m_obj["IEVer"] = (char*)m_BaseInfo.IEVer;
	m_obj["MobilePort"] = m_BaseInfo.MobilePort;
	m_obj["IpAddr"] = (char*)m_BaseInfo.IpAddr;
	m_obj["P2pKeyID"] = (char*)m_BaseInfo.P2pKeyID;
	m_obj["P2pUID"] = (char*)m_BaseInfo.P2pUID;
	m_obj["AgentVer"] = (char*)m_BaseInfo.AgentVer;
	m_obj["DongleVer"] = (char*)m_BaseInfo.DongleVer;
	m_obj["DomainName"] = (char*)m_BaseInfo.DomainName;
	m_obj["AgentType"] = (char*)m_BaseInfo.AgentType;

	//
	Json::FastWriter writer;
	strRet = writer.write(m_obj);
	return strRet;
}

int CSysInfBase::SaveAll(std::string strData)
{
	RSNetSetParamParam param;
	ZeroMemory(&param, sizeof(param));
	param.ParamType = MsgParamSystemBase;
	param.Param = &m_BaseInfo;
	if (RSNetSetParam(m_pDevice->GetConnection(), &param))
	{
		return true;
	}

	return false;
}