#include "StdAfx.h"
#include "SysParamPTZ.h"

static void RSNET_CALL AllDataCallback(void* data, void* userParam)
{
	SysParamPTZ* pThis = (SysParamPTZ*)userParam;
	RSNet_SolePTZSet_t* channelPTZ = (RSNet_SolePTZSet_t*)data;
	pThis->m_vec.push_back(*channelPTZ);
}

std::string SysParamPTZ::QueryAll(bool bDefault)
{
	//
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param, '\0', sizeof(param));

	m_vec.clear();

	ChannelParamReq req;
	TransformChannelParamReq_All(&req);

	param.ParamType = MsgParamPtz;
	param.Req = &req;

	param.ListParamSize = sizeof(RSNet_SolePTZSet_t);
	param.ListParamCallback = AllDataCallback;
	param.UserParam = this;

	if(bDefault)
	{
		if(!RSNetQueryDefaultParam(m_pDevice->GetConnection(), &param, MsgDefaultParam))
			return strRet;
	}
	else
	{
		if(!RSNetQueryParam(m_pDevice->GetConnection(), &param))
			return strRet;
	}

	//
	Json::Value root(Json::arrayValue);
	for(int i=0; i<m_vec.size(); i++)
	{
		StructToJson(i);
		root.append(m_obj);
	}

	Json::FastWriter writer;
	strRet = writer.write(root);
	return strRet;
}

void SysParamPTZ::StructToJson(int n)
{
	m_obj.clear();
	m_obj["ch"] = n;

	m_obj["Baudrate"] = m_vec[n].Baudrate;
	m_obj["Check"] = m_vec[n].Check;
	m_obj["DataBit"] = m_vec[n].DataBit;
	m_obj["Number"] = m_vec[n].Number;
	m_obj["Protocol"] = m_vec[n].Protocol;
	m_obj["StopBit"] = m_vec[n].StopBit;
	m_obj["EnablePtzCruise"] = m_vec[n].EnablePtzCruise;
	m_obj["StructSize"] = m_vec[n].StructSize;
	m_obj["SignalType"] = m_vec[n].SignalType;

}

int SysParamPTZ::SaveAll(std::string strData)
{
	int ret = false;
	int count = 0;
	//int index = 0;
	int Array[256] = {0};
	int nNum = m_pDevice->GetLoginRsp()->AnalogChNum;
	if(strData == "null"){
		return false;
	}

	Json::Reader reader;
	Json::Value obj;
	if(!reader.parse(strData, obj)){
		return false;
	}

	for(int i=0; i<obj.size(); i++)
	{
		m_vec[i].Baudrate = obj[i]["Baudrate"].asInt();
		m_vec[i].Check = obj[i]["Check"].asInt();
		m_vec[i].DataBit = obj[i]["DataBit"].asInt();
		m_vec[i].Number = obj[i]["Number"].asInt();
		m_vec[i].Protocol = obj[i]["Protocol"].asInt();
		m_vec[i].StopBit = obj[i]["StopBit"].asInt();
		m_vec[i].EnablePtzCruise = obj[i]["EnablePtzCruise"].asInt();
		m_vec[i].SignalType = obj[i]["SignalType"].asInt();
	}

	for (int i=0; i<nNum;++i)
	{
		if(m_vec[i].EnablePtzCruise == 1 )//Cruiseʱ
		{
			Array[i] = m_vec[i].Number;//洢ַ
		}
	}

	for (int i=0; i<nNum-1;++i)
	{
		BOOL bInit = FALSE;
		for (int j=i+1;j<nNum;++j)
		{
			if (Array[i]!= 0 && Array[i] == Array[j])
			{
				bInit = TRUE;
				//index |= 1<<j;
				Array[j] = 0;
				count++;
			}
		}

		if(bInit) { 
			//index |= 1<<i;
			Array[i] = 0;count++;
		}
	}
	if (count > 1)
	{
		//return 5|(index<<32);
		return 5;
	}

	RSNetSetParamParam param;
	memset(&param, '\0', sizeof(param));
	param.ParamType = MsgParamPtz;
	param.Param = NULL;
	param.ListParams = &m_vec[0];
	param.ListParamNum = m_vec.size();
	if (RSNetSetParam(m_pDevice->GetConnection(), &param))
	{
		return true;
	}

	return ret;
}