#include "StdAfx.h"
#include "VideoCover.h"


static void RSNET_CALL ParamDataCallback(void* data, void* userParam)
{
	VideoCover* pThis = (VideoCover*)userParam;
	RSNet_SoleVideoCover_t *pData = (RSNet_SoleVideoCover_t*)data;
	pThis->m_vec.push_back(*pData);
}

static void RSNET_CALL OneDataCallback(void* data, void* userParam)
{
	VideoCover* pThis = (VideoCover*)userParam;
	RSNet_SoleVideoCover_t *pData = (RSNet_SoleVideoCover_t*)data;
	for(int i=0; i<pThis->m_vec.size(); i++)
	{
		if((pData->ChannelMask >> i & 0x1) == 1)
			pThis->m_vec[i] = *pData;
	}
}

std::string VideoCover::QueryAll(bool bDefault)
{
	//
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param, '\0', sizeof(param));

	m_vec.clear();

	ChannelParamReq req;
	TransformChannelParamReq_All(&req);

	param.ParamType = MsgParamVideoCover;
	param.Req = &req;

	param.ListParamSize = sizeof(RSNet_SoleVideoCover_t);
	param.ListParamCallback = ParamDataCallback;
	param.UserParam = this;

	if(bDefault)
	{
		if(!RSNetQueryDefaultParam(m_pDevice->GetConnection(), &param, MsgDefaultParam))
			return strRet;
	}
	else
	{
		if(!RSNetQueryParam(m_pDevice->GetConnection(), &param))
			return strRet;
	}

	//
	Json::Value root(Json::arrayValue);
	for(int i=0; i<m_vec.size(); i++)
	{
		StructToJson(i);
		root.append(m_obj);
	}

	Json::FastWriter writer;
	strRet = writer.write(root);
	return strRet;
}

std::string VideoCover::QueryOne(int n)
{
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param, '\0', sizeof(param));

	ChannelParamReq req;
	TransformChannelParamReq_One(&req,n);

	param.ParamType = MsgParamVideoCover;
	param.Req = &req;

	param.ListParamSize = sizeof(RSNet_SoleVideoCover_t);
	param.ListParamCallback = OneDataCallback;
	param.UserParam = this;

	if(!RSNetQueryParam(m_pDevice->GetConnection(), &param))
		return strRet;

	StructToJson(n);

	Json::FastWriter writer;
	strRet = writer.write(m_obj);
	return strRet;
}

void VideoCover::StructToJson(int i)
{
	m_obj.clear();
	m_obj["ch"] = i;
	m_obj["VideoCoverSwitch"] = m_vec[i].VideoCoverSwitch;
	m_obj["ShelterMode"] = m_vec[i].ShelterMode;
	m_obj["VideoCoverNum"] = m_vec[i].VideoCoverNum;
	for(int j = 0;j < 4;++j)
	{
		Json::Value val(Json::objectValue);
		val["CoverSwitch"] = m_vec[i].VideoCoverArea[j].CoverSwitch;
		val["x"] = m_vec[i].VideoCoverArea[j].x;
		val["y"] = m_vec[i].VideoCoverArea[j].y;
		val["w"] = m_vec[i].VideoCoverArea[j].w;
		val["h"] = m_vec[i].VideoCoverArea[j].h;
		m_obj["VideoCoverArea"].append(val);
	}
}

int VideoCover::SaveAll(std::string strData)
{
	if(strData == "null"){
		return false;
	}

	Json::Reader reader;
	Json::Value obj;
	if(!reader.parse(strData, obj)){
		return false;
	}

	for(int i=0; i<obj.size(); i++)
	{
		m_vec[i].VideoCoverSwitch = obj[i]["VideoCoverSwitch"].asInt();
		for(int j = 0;j < obj[i]["VideoCoverArea"].size();++j)
		{
			Json::Value val = obj[i]["VideoCoverArea"][j];
			m_vec[i].VideoCoverArea[j].CoverSwitch = val["CoverSwitch"].asBool();
			m_vec[i].VideoCoverArea[j].x = val["x"].asUInt();
			m_vec[i].VideoCoverArea[j].y = val["y"].asUInt();
			m_vec[i].VideoCoverArea[j].w = val["w"].asUInt();
			m_vec[i].VideoCoverArea[j].h = val["h"].asUInt();
		}
		m_vec[i].StructSize = sizeof(RSNet_SoleVideoCover_t);
	}
	
	RSNetSetParamParam param;
	memset(&param, '\0', sizeof(param));
	param.ParamType = MsgParamVideoCover;
	param.Param = NULL;
	param.ListParams = &m_vec[0];
	param.ListParamNum = m_vec.size();
	if(RSNetSetParam(m_pDevice->GetConnection(), &param)){
		return true ;
	}
	return false;
}