#include "StdAfx.h"
#include "VideoRoi.h"

#define MAX_ROI_AREA 8

VideoRoi::VideoRoi(void)
{
	m_index = 0;
	m_StreamType = 1;
}

VideoRoi::~VideoRoi(void)
{
	m_vec.clear();
}

static void RSNET_CALL AllDataCallback(void* data, void* userParam)
{
	VideoRoi* pThis = (VideoRoi*)userParam;
	RSNet_SoleRoiParam_t* pData = (RSNet_SoleRoiParam_t*)data;
	pThis->m_vec.push_back(*pData);
}

std::string VideoRoi::QueryAll(std::string strData)
{
	//
	std::string strRst = "err";

	Json::Reader reader;
	Json::Value obj(Json::objectValue);
	if(!reader.parse(strData,obj)){
		return strRst;
	}

	//1
		if(obj["RoiIndex"].isNull())
		{
			return strRst;
		}
		m_index = obj["RoiIndex"].asInt();
		if(m_index < 0)
		{
			m_index = 0;
		}

	//2
		if(obj["getType"].isNull())
		{
			return strRst;
		}
		int iGetType = obj["getType"].asInt();

	//3
		if(obj["StreamType"].isNull())
		{
			return strRst;
		}
		m_StreamType = obj["StreamType"].asInt();

	if(iGetType == 0)//ȡȫ
	{
		m_vec.clear();

		RSNetQueryParamParam param;
		memset(&param,'\0', sizeof(param));

			ChannelParamReq req = {0};
			req.StructSize = sizeof(req);
			req.ChannelMask[0] = 7;//111

		param.ParamType = MsgParamIPCROI;
		param.Req = &req;

		param.ListParamSize = sizeof(RSNet_SoleRoiParam_t);
		param.ListParamCallback = AllDataCallback;
		param.UserParam = this;

		if(RSNetQueryParam(m_pDevice->GetConnection(), &param))
		{
			int iCount = m_vec.size();
			if(iCount <= 0)
			{
				return strRst;
			}
		}
	}

	int i = 0;
	RSNet_SoleRoiParam_t* pData = NULL;
	while(i < m_vec.size())
	{
		pData = &m_vec[i];
		if(pData->StreamType == m_StreamType)
		{
			break;
		}
		else
		{
			pData = NULL;
		}
		i++;
	}

	if(pData != NULL)
	{
		m_obj.clear();		
		m_obj["RoiIndex"] = pData->roi[m_index].RoiIndex;
		m_obj["RoiSwitch"] = pData->roi[m_index].RoiSwitch;
		m_obj["IsAbsQp"] = pData->roi[m_index].IsAbsQp;
		m_obj["ROILevel"] = pData->roi[m_index].ROILevel;
		m_obj["ROIBgFrameRate"] = pData->roi[m_index].ROIBgFrameRate;
		m_obj["StreamType"] = pData->StreamType;
		m_obj["Maxfps"] = pData->Maxfps;
		m_obj["roi"]["Rect_x"] = pData->roi[m_index].Rect_x;
		m_obj["roi"]["Rect_y"] = pData->roi[m_index].Rect_y;
		m_obj["roi"]["Rect_w"] = pData->roi[m_index].Rect_w;
		m_obj["roi"]["Rect_h"] = pData->roi[m_index].Rect_h;

		Json::FastWriter writer;
		strRst = writer.write(m_obj);
	}

	return strRst;
}

int VideoRoi::SaveAll(std::string strData)
{	
	if(strData == "null"){
		return false;
	}

	Json::Reader reader;
	Json::Value obj(Json::objectValue);
	if(!reader.parse(strData, obj)){
		return false;
	}

	int i = 0;
	int iSaveType = 0;
	RSNet_SoleRoiParam_t* pData = NULL;
	m_index = obj["RoiIndex"].asInt();
	m_StreamType = obj["StreamType"].asInt();
	iSaveType = obj["SaveType"].asInt();

	while(i < m_vec.size())
	{
		pData = &m_vec[i];
		if(pData->StreamType == m_StreamType)
		{
			break;
		}
		else
		{
			pData = NULL;
		}
		i++;
	}

	if(pData != NULL)
	{
		pData->roi[m_index].RoiIndex = m_index;
		pData->roi[m_index].IsAbsQp = obj["IsAbsQp"].asInt();
		pData->roi[m_index].ROIBgFrameRate = obj["ROIBgFrameRate"].asInt();
		pData->roi[m_index].ROILevel = obj["ROILevel"].asInt();
		pData->roi[m_index].RoiSwitch = obj["RoiSwitch"].asInt();
		pData->StreamType = obj["StreamType"].asInt();
		pData->Maxfps = obj["Maxfps"].asInt();
		pData->roi[m_index].Rect_x = obj["roi"]["Rect_x"].asUInt();
		pData->roi[m_index].Rect_y = obj["roi"]["Rect_y"].asUInt();
		pData->roi[m_index].Rect_w = obj["roi"]["Rect_w"].asUInt();
		pData->roi[m_index].Rect_h = obj["roi"]["Rect_h"].asUInt();
		pData->StructSize = sizeof(RSNet_SoleRoiParam_t);

		if(iSaveType == 1){//浽
			return true ;
		}

		if(iSaveType == 0){//浽
			RSNetSetParamParam param;
			memset(&param,'\0', sizeof(param));
			param.ParamType = MsgParamIPCROI;
			param.Param = NULL;
			param.ListParams = &m_vec[0];
			param.ListParamNum = m_vec.size();
			if(RSNetSetParam(m_pDevice->GetConnection(), &param))
			{
				return true;
			}
		}
	}

	return false;
}

RSNet_Roi_t* VideoRoi::GetParamData()
{
	int iCount = m_vec.size();
	if(iCount <= 0 )
	{
		return NULL;
	}

	if(m_index < 0 || (m_index >= MAX_ROI_AREA))
	{
		m_index = 0;
	}

	int i = 0;
	RSNet_SoleRoiParam_t* pData = NULL;
	while(i < iCount)
	{
		pData = &m_vec[i];
		if(pData->StreamType == m_StreamType)
		{
			return &(pData->roi[m_index]);
		}
		i++;
	}

	return NULL;
}