#include "StdAfx.h"
#include "VideoSet.h"

static void RSNET_CALL OneDataCallback(void* data, void* userParam)
{
	VideoSet* pThis = (VideoSet*)userParam;
	memcpy(&pThis->m_Struct,data,sizeof(RSNet_SoleColorSet_t));
}

std::string VideoSet::QueryOne(int n)
{
	//
	std::string strRet = "err";

	RSNetQueryParamParam param;
	memset(&param, '\0', sizeof(param));

	memset(&m_Struct, '\0', sizeof(RSNet_SoleColorSet_t));
	m_Struct.StructSize = sizeof(RSNet_SoleColorSet_t);
	ChannelParamReq req;
	TransformChannelParamReq_One(&req,n);

	param.ParamType = MsgParamColor;
	param.Req = &req;

	param.ParamSize = 0;
	param.ParamCallback = NULL;

	param.ListParamSize = sizeof(RSNet_SoleColorSet_t);
	param.ListParamCallback = OneDataCallback;
	param.UserParam = this;

	if(!RSNetQueryParam(m_pDevice->GetConnection(), &param))
		return strRet;

	//
	m_obj.clear();
	m_obj["Chroma"] = m_Struct.Chroma;
	m_obj["Brightness"] = m_Struct.Brightness;
	m_obj["contrast"] = m_Struct.contrast;
	m_obj["saturation"] = m_Struct.saturation;
	m_obj["sound"] = RSPlayGetPlayVolume();
	m_obj["DisplayRule"] = m_Struct.DisplayRule;
	m_obj["ShowDefault"] = m_Struct.ShowDefault;
	m_obj["Sharpness"] = m_Struct.Sharpness;

	//
	Json::FastWriter writer;
	strRet = writer.write(m_obj);
	return strRet;
}

int VideoSet::SaveOne(int n, std::string strData)
{
	if(strData == "null"){
		return false;
	}

	Json::Reader reader;
	Json::Value obj;
	if(!reader.parse(strData, obj)){
		return false;
	}

	//
		int key = obj["key"].asInt();
		m_Struct.StructSize = sizeof(RSNet_SoleColorSet_t);
		m_Struct.DefaultColor = 0;

		if(key == 1){//
			m_Struct.Brightness = obj["Brightness"].asInt() ;
		}else if (key == 2){//Աȶ
			m_Struct.contrast = obj["contrast"].asInt();
		}else if (key == 3){
			m_Struct.saturation = obj["saturation"].asInt() ;
		}else if (key == 4){
			m_Struct.Chroma = obj["Chroma"].asInt();
		}else if(key == 7){
			m_Struct.Sharpness = obj["Sharpness"].asInt();
		}else if(key ==8){
			m_Struct.LoadBalancing = obj["LoadBalancing"].asInt();
		}else if (key == 5){
			RSPlaySetPlayVolume(obj["Chroma"].asInt());
		}else if (key == 6){
			m_Struct.DefaultColor = 1;
		}
	
	//
		RSNetSetParamParam param;
		memset(&param, '\0', sizeof(param));
		m_Struct.ChannelMask =  (0x1<<n);
		param.ParamType = MsgParamColor;
		param.Param = NULL;
		param.ListParams = &m_Struct;
		param.ListParamNum = 1;

		if(RSNetSetParam(m_pDevice->GetConnection(), &param))
		{
			return true;
		}
		return false;
}