
//

#include "stdafx.h"
#include "RSLibDemo.h"
#include "RSLibDemoDlg.h"
#include "SearchDevDlg.h"
#include "MyMenu.h"
#include "ConfigDlg.h"
#include "LocalPlayer.h"

#define SHOW_PREVIEW  0
#define SHOW_PLAYBACK 1
#define SHOW_SIMPLE_CMD 2
#ifdef _DEBUG
#define new DEBUG_NEW
#endif

#define RSWEB_STATION       "raysharp.gotoip3.com"
#define URMETWEB_STATION    "www.urmetddns.com"

void  RSNET_CALL AlarmRptCallback(WORD type, void* data, UINT size, void* userParam);

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX); 

protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
END_MESSAGE_MAP()

CRSLibDemoDlg::CRSLibDemoDlg(CWnd* pParent)
	: CDialog(CRSLibDemoDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
	m_bEncrypt = FALSE;
	//memset(m_nWinID, 0, sizeof(int)*32);
}

void CRSLibDemoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TREE_DEV, m_devTree);
	DDX_Control(pDX, IDC_STATIC_VIDEOWND, m_videoWndPool);
	DDX_Control(pDX, IDC_OUT_INFO, m_msgListCtrl);
	DDX_Control(pDX, IDC_BTN_PLAYBACK, m_btPlayback);
	DDX_Control(pDX, IDC_BTN_PREVIEEW, m_btPView);
	DDX_Control(pDX, IDC_BTN_CONFIG, m_btConfig);
	DDX_Control(pDX, IDC_BTN_PLAYER, m_btPlayer);
}

BEGIN_MESSAGE_MAP(CRSLibDemoDlg, CDialog)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(IDC_BTN_SEARECH, &CRSLibDemoDlg::OnBnClickedBtnSearech)
	ON_NOTIFY(NM_RCLICK, IDC_TREE_DEV, &CRSLibDemoDlg::OnNMRClickTreeDev)
	ON_COMMAND(ID_MENU_SERVER_LOGIN, OnMenuLogin)
	ON_COMMAND(ID_MENU_SERVER_LOGOUT, OnMenuLogout)
	ON_MESSAGE(WM_CONNECTION_MESSAGE, OnConnectionMsg)
	ON_NOTIFY(NM_DBLCLK, IDC_TREE_DEV, &CRSLibDemoDlg::OnNMDblclkTreeDev)
	ON_BN_CLICKED(IDC_BTN_HELP, &CRSLibDemoDlg::OnBnClickedBtnHelp)
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREE_DEV, &CRSLibDemoDlg::OnTvnSelchangedTreeDev)
	ON_BN_CLICKED(IDC_BTN_CONFIG, &CRSLibDemoDlg::OnBnClickedBtnConfig)
	ON_BN_CLICKED(IDC_BTN_PLAYBACK, &CRSLibDemoDlg::OnBnClickedBtnPlayback)
	ON_BN_CLICKED(IDC_BTN_PLAYER, &CRSLibDemoDlg::OnBnClickedBtnPlayer)
	ON_BN_CLICKED(IDC_BTN_PREVIEEW, &CRSLibDemoDlg::OnBnClickedBtnPreview)
	ON_BN_CLICKED(IDC_BTN_SIMPLE_CMD, &CRSLibDemoDlg::OnBnClickedBtnSimpleCmd)
	ON_MESSAGE(WM_INSERT_LIST, InsertMsgToList)
	ON_BN_CLICKED(IDC_BUTTON_ENCRYPT, &CRSLibDemoDlg::OnBnClickedButtonEncrypt)
    ON_BN_CLICKED(IDC_BTN_CAPTURE, &CRSLibDemoDlg::OnBnClickedBtnCapture)
END_MESSAGE_MAP()

BOOL CRSLibDemoDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}
	SetIcon(m_hIcon, TRUE);	
	SetIcon(m_hIcon, FALSE);

	theApp.pMainFrame = this;
	InitDevTree();
	InitPViewWnds();
	InitPlaybackWnds();
	InitOutputMsgList();
	SetCurPlayWnd(0);
	GetDlgItem(IDC_BTN_CONFIG)->EnableWindow(FALSE);
	ShowVideoWnd(SHOW_PREVIEW);
	return TRUE;  
}

void CRSLibDemoDlg::InitOutputMsgList()
{
	(void)m_msgListCtrl.SetExtendedStyle( LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES|LVS_EX_SUBITEMIMAGES );
	m_msgListCtrl.InsertColumn(0,_T("No"),LVCFMT_CENTER,50);
	m_msgListCtrl.InsertColumn(1,_T("Device name"),LVCFMT_CENTER,80);
	m_msgListCtrl.InsertColumn(2,_T("IP"),LVCFMT_CENTER,80);
	m_msgListCtrl.InsertColumn(3,_T("Region"),LVCFMT_CENTER,100);
	m_msgListCtrl.InsertColumn(4,_T("Alarm time"),LVCFMT_CENTER,140);
	m_msgListCtrl.InsertColumn(5,_T("Alarm type"),LVCFMT_CENTER,180);
	m_msgListCtrl.InsertColumn(6,_T("Alarm information"),LVCFMT_CENTER,300);
	m_msgListCtrl.SetTextColor(RGB(20,20,255));
}

LRESULT CRSLibDemoDlg::InsertMsgToList(WPARAM wParam, LPARAM lParam)
{
	alarm_info_t* pAlarm = (alarm_info_t*)wParam;
    WORD type = (WORD)lParam;
    DateTime AlarmTime;
    CString strID, strTime, strType, strInfo; 
    strInfo = _T("");
    int count = m_msgListCtrl.GetItemCount();
    strID.Format("%10d",count+1);
    switch (type)
    {
    case MsgMotionAlarm:
        {
            MotionAlarmRpt* pMotionAlarmRpt = (MotionAlarmRpt*)pAlarm->data;
            AlarmTime = pMotionAlarmRpt->AlarmTime;
            strTime.Format("%04d-%02d-%02d %02d:%02d:%02d",AlarmTime.Year,AlarmTime.Month,AlarmTime.Day,
                AlarmTime.Hour,AlarmTime.Minute,AlarmTime.Second);
            strType = _T("MsgMotionAlarm");
            UINT nStatus = pMotionAlarmRpt->Status;
            UINT nChannel = pMotionAlarmRpt->Channel;
            if (nStatus == 1){
                strInfo.Format("CH%02d Begin", nChannel+1);
            }else{
                strInfo.Format("CH%02d End", nChannel+1);
            }
			pViewDlg[0].ShowVideoString(MsgMotionAlarm, nStatus, RGB(0, 255, 0));
        }
        break;
	case MsgRecordStatusReport:
		{
			RecordStatusRpt* pRecordAlarmRpt = (RecordStatusRpt*)pAlarm->data;
			UINT nStatus = pRecordAlarmRpt->RecordStatus;
			pViewDlg[0].ShowVideoString(MsgRecordStatusReport, nStatus, RGB(255, 0, 0));
		}
		break;
    case MsgIOAlarm:
        {
            IOAlarmRpt *pIOAlarmRpt = (IOAlarmRpt*)pAlarm->data;
            AlarmTime = pIOAlarmRpt->AlarmTime;
            strTime.Format("%04d-%02d-%02d %02d:%02d:%02d",AlarmTime.Year,AlarmTime.Month,AlarmTime.Day,
                AlarmTime.Hour,AlarmTime.Minute,AlarmTime.Second);
            strType = _T("MsgIOAlarm");
            UINT nStatus = pIOAlarmRpt->Status;
            UINT nChannel = pIOAlarmRpt->Channel;
            if (nStatus == 1){
                strInfo.Format("CH%02d Begin", nChannel+1);
            }else{
                strInfo.Format("CH%02d End", nChannel+1);
            }
        }
        break;
    case MsgVLossAlarm:
        {
            VLossAlarmRpt *pAlarmRpt = (VLossAlarmRpt*)pAlarm->data;
            AlarmTime = pAlarmRpt->AlarmTime;
            strTime.Format("%04d-%02d-%02d %02d:%02d:%02d",AlarmTime.Year,AlarmTime.Month,AlarmTime.Day,
                AlarmTime.Hour,AlarmTime.Minute,AlarmTime.Second);
            strType = _T("MsgVLossAlarm");
            UINT nStatus = pAlarmRpt->Status;
            UINT nChannel = pAlarmRpt->Channel;
            if (nStatus == 1){
                strInfo.Format("CH%02d Begin", nChannel+1);
            }else{
                strInfo.Format("CH%02d End", nChannel+1);
            }
        }
        break;
    case MsgDevAllStatusReq:
		{
			//Ƴȫ־
			pViewDlg[0].ShowVideoString(MsgMotionAlarm, FALSE, RGB(0, 0, 0));
			pViewDlg[0].ShowVideoString(MsgIOAlarm, FALSE, RGB(0, 0, 0));
			pViewDlg[0].ShowVideoString(MsgRecordStatusReport, FALSE, RGB(0, 0, 0));
			pViewDlg[0].ShowVideoString(MsgHddStatusReport, FALSE, RGB(0, 0, 0));
			pViewDlg[0].ShowVideoString(MsgVideoHideAlarm, FALSE, RGB(0, 0, 0));
			pViewDlg[0].ShowVideoString(MsgIntelIpcPeaAlarm, FALSE, RGB(0, 0, 0));
			pViewDlg[0].ShowVideoString(MsgIpcOSCAlarm, FALSE, RGB(0, 0, 0));

			DevAllStatusRpt * pDevStat = (DevAllStatusRpt *)(pAlarm->data);

			int nRecordAllStatus = pDevStat->RecordAllStatus[0];
			if (nRecordAllStatus == 3 || nRecordAllStatus == 5){// M	
				pViewDlg[0].ShowVideoString(MsgMotionAlarm, TRUE, RGB(255,0,0));
			}else {
				if(pDevStat->MotionStatus & 1){// M	
					pViewDlg[0].ShowVideoString(MsgMotionAlarm,TRUE, RGB(0, 255, 0)); 
				}
			}


			if (pDevStat->RecordAllStatus[0] == 1){// R
				pViewDlg[0].ShowVideoString(MsgRecordStatusReport,TRUE, RGB(255,0,0));
			}else{
				pViewDlg[0].ShowVideoString(MsgRecordStatusReport,FALSE, RGB(255,0,0));
			}
		}
		break;
    case MsgRemoteCHStatusReport:
        {
            if (msimpleCmdDlg.GetSafeHwnd() != NULL)
            {
                msimpleCmdDlg.AddListInfo(pAlarm);
                if (!msimpleCmdDlg.IsWindowVisible())
                {
                    msimpleCmdDlg.CenterWindow();
                    msimpleCmdDlg.ShowWindow(SW_SHOW);
                }
            }
        }
    	break;
    case MsgGpsInfoReport:
        {
            GpsInfoPacketRpt *pGpsInfo = (GpsInfoPacketRpt*)pAlarm->data;
            AlarmTime = pGpsInfo->AlarmTime;
            strTime.Format("%04d-%02d-%02d %02d:%02d:%02d",AlarmTime.Year,AlarmTime.Month,AlarmTime.Day,
                AlarmTime.Hour,AlarmTime.Minute,AlarmTime.Second);

            strType = _T("MsgGpsInfoReport");
            CTime time(pGpsInfo->stHeadRpt.Time);
            strInfo.Format("%04d-%02d-%02d %02d:%02d:%02d", time.GetYear(), time.GetMonth(),time.GetDay(),\
                time.GetHour(), time.GetMinute(), time.GetSecond());
            
            m_msgListCtrl.InsertItem(0,strID);	
            m_msgListCtrl.SetItemText(0,1,pAlarm->pServerInfo->szName);
            m_msgListCtrl.SetItemText(0,2,pAlarm->pServerInfo->szIp);
            m_msgListCtrl.SetItemText(0,3,pAlarm->pServerInfo->AreaID);
            m_msgListCtrl.SetItemText(0,4,strTime);
            m_msgListCtrl.SetItemText(0,5,strType);
            m_msgListCtrl.SetItemText(0,6,strInfo);

            count++;
            strID.Format("%10d",count+1);
            strInfo.Format("Speed:%.2f, Angle:%.2f, Signal3G:%d, Mile:%d, NS:%c, EW:%c, Status:%c, Longitude:%f, Latitude:%f",\
                pGpsInfo->stBodyRpt.SensorSpeed, pGpsInfo->stBodyRpt.Azimuth, pGpsInfo->stBodyRpt.Signal3G,pGpsInfo->stBodyRpt.TotalMileage,\
                pGpsInfo->stBodyRpt.LatitudeDir, pGpsInfo->stBodyRpt.LongitudeDir, pGpsInfo->stBodyRpt.Longitude, pGpsInfo->stBodyRpt.Latitude,\
                pGpsInfo->stBodyRpt.Status);
            m_msgListCtrl.InsertItem(0,strID);	
            m_msgListCtrl.SetItemText(0,1,pAlarm->pServerInfo->szName);
            m_msgListCtrl.SetItemText(0,2,pAlarm->pServerInfo->szIp);
            m_msgListCtrl.SetItemText(0,3,pAlarm->pServerInfo->AreaID);
            m_msgListCtrl.SetItemText(0,4,strTime);
            m_msgListCtrl.SetItemText(0,5,strType);
            m_msgListCtrl.SetItemText(0,6,strInfo);

            strInfo = _T("");
        }
        break;
    case MsgIntelIpcPeaAlarm:
    case MsgIpcOSCAlarm:
    case MsgIntelIpcPeaAreaAlarm:
        {
            DevStatRpt *pAlarmRpt = (DevStatRpt*)pAlarm->data;
            AlarmTime = pAlarmRpt->AlarmTime;
            strTime.Format("%04d-%02d-%02d %02d:%02d:%02d",AlarmTime.Year,AlarmTime.Month,AlarmTime.Day,
                AlarmTime.Hour,AlarmTime.Minute,AlarmTime.Second);
            if (type == MsgIntelIpcPeaAlarm)
                strType = _T("PEA");
            else if (type == MsgIpcOSCAlarm)
                strType = _T("OSC");
            else if (type == MsgIntelIpcPeaAreaAlarm)
                strType = _T("PEA_Area");
            UINT nStatus = pAlarmRpt->Status;
            UINT nChannel = pAlarmRpt->Channel;
            if (nStatus == 1){
                strInfo.Format("CH%02d Begin", nChannel+1);
            }else{
                strInfo.Format("CH%02d End", nChannel+1);
            }
        }
        break;
    default:
        break;
    }
    if (!strInfo.IsEmpty() &&\
        type != MsgDevAllStatusReq &&\
        type != MsgRemoteCHStatusReport)
    {
        m_msgListCtrl.InsertItem(0,strID);	
        m_msgListCtrl.SetItemText(0,1,pAlarm->pServerInfo->szName);
        m_msgListCtrl.SetItemText(0,2,pAlarm->pServerInfo->szIp);
        m_msgListCtrl.SetItemText(0,3,pAlarm->pServerInfo->AreaID);
        m_msgListCtrl.SetItemText(0,4,strTime);
        m_msgListCtrl.SetItemText(0,5,strType);
        m_msgListCtrl.SetItemText(0,6,strInfo);
    }
    SAFE_DELETE(pAlarm->data);
    SAFE_DELETE(pAlarm);
	return 0;
}
void CRSLibDemoDlg::InitPlaybackWnds()
{
	CRect rcClient;
	m_videoWndPool.GetClientRect(&rcClient);
	mPlaybkDlg.Create(mPlaybkDlg.IDD,&m_videoWndPool);
	mPlaybkDlg.MoveWindow(rcClient,TRUE);
	mPlaybkDlg.ShowWindow(SW_HIDE);
}

void CRSLibDemoDlg::InitPViewWnds()
{
	CRect rcClient;
	m_videoWndPool.GetClientRect(&rcClient);
	CRect rcTemp = rcClient;
	rcTemp.right = rcClient.right / 2 - 5;
	rcTemp.bottom = rcClient.bottom /2 - 5;
	
	pViewDlg[0].Create((UINT)pViewDlg[0].IDD,&m_videoWndPool);
	pViewDlg[0].MoveWindow(rcTemp,TRUE);
	pViewDlg[0].ShowWindow(SW_HIDE);
	pViewDlg[0].m_nIndex = 0;

	rcTemp.top = rcClient.top;
	rcTemp.left = rcClient.right / 2 - 5;
	rcTemp.right = rcClient.right;
	rcTemp.bottom = rcClient.bottom / 2 - 5;
	pViewDlg[1].Create((UINT)pViewDlg[1].IDD,&m_videoWndPool);
	pViewDlg[1].MoveWindow(rcTemp,TRUE);
	pViewDlg[1].ShowWindow(SW_HIDE);
	pViewDlg[1].m_nIndex = 1;

	rcTemp.top = rcClient.bottom / 2 - 5;
	rcTemp.left = rcClient.left;
	rcTemp.right = rcClient.right / 2 - 5;
	rcTemp.bottom = rcClient.bottom;
	pViewDlg[2].Create((UINT)pViewDlg[2].IDD,&m_videoWndPool);
	pViewDlg[2].MoveWindow(rcTemp,TRUE);
	pViewDlg[2].ShowWindow(SW_HIDE);
	pViewDlg[2].m_nIndex = 2;

	rcTemp.top = rcClient.bottom / 2 - 5;
	rcTemp.left = rcClient.right / 2 - 5;
	rcTemp.right = rcClient.right;
	rcTemp.bottom = rcClient.bottom;
	pViewDlg[3].Create((UINT)pViewDlg[3].IDD,&m_videoWndPool);
	pViewDlg[3].MoveWindow(rcTemp,TRUE);
	pViewDlg[3].ShowWindow(SW_HIDE);
	pViewDlg[3].m_nIndex = 3;
}

void CRSLibDemoDlg::ShowVideoWnd(int type)
{
	if(type == SHOW_PREVIEW)
	{
		mPlaybkDlg.ShowWindow(SW_HIDE);
		for(int i = 0; i< 4; i++)
		{
			pViewDlg[i].ShowWindow(SW_SHOW);
		}

		m_btPlayback.EnableWindow(TRUE);
		m_btPView.EnableWindow(FALSE);
	}
	else if(type == SHOW_PLAYBACK)
	{
		for(int i = 0; i< 4; i++)
		{
			pViewDlg[i].ShowWindow(SW_HIDE);
		}
		mPlaybkDlg.ShowWindow(SW_SHOW);

		m_btPlayback.EnableWindow(FALSE);
		m_btPView.EnableWindow(TRUE);
	}
}

void CRSLibDemoDlg::InitDevTree()
{
	CString strFile = _T("");
	m_CTreeImage.Create(18,18,ILC_MASK |ILC_COLOR32,2,2);
	CBitmap bmp;	
	strFile = theApp.m_strSkinPath + "ImageList.bmp";

	HBITMAP hBitmap = (HBITMAP)LoadImage(NULL, strFile,
		IMAGE_BITMAP, 0, 0,
		LR_DEFAULTCOLOR|LR_LOADFROMFILE |LR_CREATEDIBSECTION);

	if( NULL != hBitmap)
	{
		bmp.Attach(hBitmap);
		//BITMAP  bitmap;
		//bmp.GetBitmap(&bitmap);
	}
	m_CTreeImage.Add(&bmp, RGB(205,205,207));
	m_devTree.SetImageList(&m_CTreeImage,TVSIL_NORMAL);
	DWORD dwStyles=GetWindowLong(m_devTree.m_hWnd,GWL_STYLE);
	dwStyles|=TVS_HASBUTTONS|TVS_HASLINES|TVS_LINESATROOT;
	SetWindowLong(m_devTree.m_hWnd,GWL_STYLE,dwStyles);

	m_devTree.DeleteAllItems();
	m_hCurSelItem = NULL;
	InitArea("00000",TVI_ROOT);
	HTREEITEM hRoot = m_devTree.GetRootItem();
	
}

void CRSLibDemoDlg::InitArea(CString m_strParentID,HTREEITEM hItem)
{
	/*CString strAreaID;
	CString strAreaName = _T("RootArea");
	AREA_INFO *pInfo = new AREA_INFO;
	TV_INSERTSTRUCT TCItem;
	TCItem.hParent = hItem;
	TCItem.hInsertAfter = TVI_LAST;
	TCItem.item.mask = TVIF_TEXT|TVIF_PARAM|TVIF_IMAGE|TVIF_SELECTEDIMAGE;
	TCItem.item.pszText = (LPSTR)(LPCTSTR)strAreaName;
	TCItem.item.lParam = (LPARAM)pInfo;
	TCItem.item.iImage = ICO_AREA_NORMAL;
	TCItem.item.iSelectedImage = ICO_AREA_SELECT;
	this->m_hRootItem = m_devTree.InsertItem(&TCItem);*/
    AREA_INFO *pInfo = new AREA_INFO;
    this->m_hRootItem = m_devTree.InsertItem(TVIF_TEXT|TVIF_PARAM|TVIF_IMAGE|TVIF_SELECTEDIMAGE, \
        _T("RootArea"), ICO_AREA_NORMAL, ICO_AREA_SELECT, 0, 0, (LPARAM)pInfo, hItem, TVI_LAST);
}

void CRSLibDemoDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

void CRSLibDemoDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this);

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

HCURSOR CRSLibDemoDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

void CRSLibDemoDlg::OnBnClickedBtnSearech()
{
	CSearchDevDlg m_searchDevDlg;
	m_searchDevDlg.DoModal();
}

void CRSLibDemoDlg::InitChannel(SERVER_INFO *pInfo)
{

}

BYTE CRSLibDemoDlg::GetSelItemType(HTREEITEM hItem)
{
	BYTE ItemType = 0;
	void* pInfo = NULL;
	if (hItem != NULL)
	{
		pInfo = (void*)m_devTree.GetItemData(hItem);
		memcpy_s(&ItemType, sizeof(ItemType), pInfo,sizeof(BYTE));  
	}
	return ItemType;
}

void CRSLibDemoDlg::OnNMRClickTreeDev(NMHDR *pNMHDR, LRESULT *pResult)
{
	CPoint myPoint;
	UINT uFlag;
	GetCursorPos(&myPoint);
	m_devTree.ScreenToClient(&myPoint);
	m_hCurSelItem = m_devTree.HitTest(myPoint, &uFlag);
	m_devTree.SelectItem(m_hCurSelItem);
	if(m_hCurSelItem != NULL)
	{
		int nImage,nSelectedImage;
		m_devTree.GetItemImage(m_hCurSelItem,nImage,nSelectedImage);
		BYTE ItemType = GetSelItemType(m_hCurSelItem);
		
		if (ItemType != DevTreeType_Dev)
			return;

		int i = -1;
		CMyMenu menu(140, 20);
		if(!menu.CreatePopupMenu())
			return;
		MenuItemData menuItem[15];	

		menuItem[++i].ItemTitle = _T("Login");
		menuItem[i].nType = 1;
		menu.AppendMenu(MF_BYCOMMAND|MF_OWNERDRAW, ID_MENU_SERVER_LOGIN, (LPCSTR)&menuItem[i]);	
		if((nImage == ICO_DEV_LOGIN)||(nImage == ICO_DEV_AIL))
		{
			menu.EnableMenuItem(ID_MENU_SERVER_LOGIN,MF_GRAYED);
		}

		menuItem[++i].ItemTitle = _T("Logout");
		menuItem[i].nType = 1;
		menu.AppendMenu(MF_BYCOMMAND|MF_OWNERDRAW, ID_MENU_SERVER_LOGOUT, (LPCSTR)&menuItem[i]);	
		if(nImage == ICO_DEV_LOGOUT)
		{
			menu.EnableMenuItem(ID_MENU_SERVER_LOGOUT,MF_GRAYED);
		}
		CPoint point;
		GetCursorPos(&point);
		menu.TrackPopupMenu(TPM_LEFTALIGN|TPM_RIGHTBUTTON, point.x, point.y, this, 0);		
	}
	
	*pResult = 0;
}

void CRSLibDemoDlg::OnMenuLogin()
{
	OnChangeDevState(m_hCurSelItem,TYPE_LOGIN,0,-1,this);
}

void CRSLibDemoDlg::OnMenuLogout()
{
	OnChangeDevState(m_hCurSelItem,TYPE_LOGOUT,0,-1,this);
}

void RSNET_CALL DualtalkDataCallback(void* data, UINT size, void* userParam)
{
	SERVER_INFO* pServerInfo= (SERVER_INFO*)userParam;
	RSPlayInputNetFrame(pServerInfo->lDualtalkID, data, size);
}

int CALLBACK dual_speak_callback(int size, const char* data, void* dwUser)
{
	SERVER_INFO* pServerInfo = (SERVER_INFO*)dwUser;
	RSNetSendDualtalkData(pServerInfo->pNetDualtalk, (void*)data, size);
	return 0;
}

void  CALLBACK OnChangeDevState(HTREEITEM nItem,int type,int subtype,int nWndIndex,void* userParam)
{
	CRSLibDemoDlg* pDlgDev = (CRSLibDemoDlg*)userParam;
	SERVER_INFO* pServerInfo = NULL;
	pServerInfo = (SERVER_INFO*)pDlgDev->m_devTree.GetItemData(nItem);	
	switch(type)
	{
	case TYPE_DESIRED:
		
		break;
	case TYPE_LOGIN:
		{
			if (!pServerInfo->bUseFlag)
			{
				RSNetConnectionParamEx param = {0};
				param.IP = pServerInfo->szIp;
				param.UserName = pServerInfo->szUser;
				param.Password = pServerInfo->szPasswd;
				param.Port = pServerInfo->iPort;
				param.AutoReconnect = TRUE;
				param.Wnd = pDlgDev->GetSafeHwnd();
				param.Message = WM_CONNECTION_MESSAGE;
				param.UserParam = pServerInfo;
				//param.AutoReconnect = TRUE;
				param.AlarmRptCallback = AlarmRptCallback;
				param.ConnCallback = NULL;
				param.AlarmRptDesired = TRUE;//pServerInfo->bAlarmRptDesired;

                CString& strTempIp = pServerInfo->szIp;
                CString strLeft2 = strTempIp.Left(2);
                CString strLeft3 = strTempIp.Left(3);
                if (strTempIp.Find('.') != -1){//IP
                    param.nLoginType = LOGIN_TYPE_IP;//value from LOGIN_TYPE
                    param.IDServerName = NULL;
                }else{//P2P ID
                    if (!strLeft2.CompareNoCase("sn")) {
                        param.nLoginType = LOGIN_TYPE_ID;//raysharp ID or urmet ID
                        param.Port = 0;
                        param.IDServerName = RSWEB_STATION;//or URMETWEB_STATION
                    }else if (!strLeft3.CompareNoCase("RSV")) {
                        param.nLoginType = LOGIN_TYPE_RSVV_ID;//weiwei
                        param.IDServerName = NULL;
                    }else if (!strLeft3.CompareNoCase("CHA")) {
                        param.nLoginType = LOGIN_TYPE_VVSEE_ID;//weiwei
                        param.IDServerName = NULL;
                    }else{
                        param.nLoginType = LOGIN_TYPE_TUTK_ID;//tutk
                        param.IDServerName = NULL;
                    }
                }

				pServerInfo->pNetConnection = RSNetConnectionStartEx(&param);
				pServerInfo->bUseFlag = TRUE;
				pDlgDev->m_devTree.SetItemImage(nItem,ICO_DEV_AIL,ICO_DEV_AIL);
			}
		}
		break;	
	case TYPE_LOGOUT:
		{
			if (pServerInfo->bUseFlag)
			{
				if (pServerInfo->bDualTalk)
				{
					OnChangeDevState(pServerInfo->hItem,TYPE_TALK,SUBTYPE_CLOSE,-1,userParam);
				}
				ChangeChState(nItem,TYPE_LOGOUT,0,-1,OnChangeChState,userParam);
				RSNetConnectionStop(&pServerInfo->pNetConnection);
				pDlgDev->GetDlgItem(IDC_BTN_CONFIG)->EnableWindow(FALSE);
				pDlgDev->m_devTree.SetItemImage(nItem,ICO_DEV_LOGOUT,ICO_DEV_LOGOUT);
				pServerInfo->bUseFlag = FALSE;
				pServerInfo->bLinkState = FALSE;
			}
		}
		break;	
	case TYPE_TALK:
		{
			if (subtype == SUBTYPE_OPEN)
			{
				pServerInfo->lDualtalkID = RSPlayCreatePlayInstance(PLAY_DUALTALK_TYPE);		
				RSNetDualtalkParam param;
				param.Message = NULL;
				param.UserParam = pServerInfo;
				param.Wnd = NULL;
				param.DataCallback = DualtalkDataCallback;
				pServerInfo->pNetDualtalk = RSNetStartDualtalk(pServerInfo->pNetConnection, &param);
				if (pServerInfo->pNetDualtalk != NULL)
				{
					AudioTalkConfig_t talk;
					talk.iAmr_format = 0;
					talk.iAmr_mode = 0;
					talk.iFormat = 3;
					talk.iRate = 8000;
					talk.iWidth = 16;
					RSPlayStartDualTalk(pServerInfo->lDualtalkID, &talk);
					RSPlayRegisterSetDualCallback(pServerInfo->lDualtalkID, dual_speak_callback, pServerInfo);
					pServerInfo->bDualTalk = TRUE;
				}
				else
				{
					RSPlayStopDualTalk(pServerInfo->lDualtalkID);
					RSPlayDestroyPlayInstance(pServerInfo->lDualtalkID);
					pServerInfo->lDualtalkID = 0;
					pServerInfo->bDualTalk = FALSE;
				}
			}
			else
			{
				RSNetStopDualtalk(&pServerInfo->pNetDualtalk);
				RSPlayStopDualTalk(pServerInfo->lDualtalkID);
				RSPlayDestroyPlayInstance(pServerInfo->lDualtalkID);
				pServerInfo->lDualtalkID = 0;
				pServerInfo->pNetDualtalk = NULL;
				pServerInfo->bDualTalk = FALSE;
			}
		}
		break;

	default:
		break;
	}
}

void ChangeChState(HTREEITEM hItem,int type,int subtype,int nWndIndex,CHANGE_CALLBACK callback,void* userParam)
{
	if(!hItem)
		return ;
	CRSLibDemoDlg* pDlgDev = (CRSLibDemoDlg*)userParam;
	HTREEITEM  hTemp;	
	if(pDlgDev->m_devTree.ItemHasChildren(hItem))
	{
		hTemp = pDlgDev->m_devTree.GetChildItem(hItem);
		do
		{
			ChangeChState(hTemp,type,subtype,nWndIndex,callback,userParam);
		}while( (hTemp = pDlgDev->m_devTree.GetNextSiblingItem(hTemp)) != NULL );
	}
	else
	{
		BYTE ItemType = pDlgDev->GetSelItemType(hItem);
		if (ItemType == DevTreeType_Ch)
		{
			callback(hItem,type,subtype,nWndIndex,userParam);
		}
	}
}

void ChangeDevState(HTREEITEM hItem,int type,int subtype,int nWndIndex,CHANGE_CALLBACK callback,void* userParam)
{
	if(!hItem)
		return ;
	CRSLibDemoDlg* pDlgDev = (CRSLibDemoDlg*)userParam;
	HTREEITEM  hTemp;	

	BYTE ItemType = pDlgDev->GetSelItemType(hItem);
	if((pDlgDev->m_devTree.ItemHasChildren(hItem))&&(ItemType == DevTreeType_Area))
	{
		hTemp = pDlgDev->m_devTree.GetChildItem(hItem);
		do
		{
			ChangeDevState(hTemp,type,subtype,nWndIndex,callback,userParam);
		}while( (hTemp = pDlgDev->m_devTree.GetNextSiblingItem(hTemp)) != NULL );
	}
	else if(!(pDlgDev->m_devTree.ItemHasChildren(hItem))&&(ItemType == DevTreeType_Area))
	{
		return;
	}
	else
	{
		callback(hItem,type,subtype,nWndIndex,userParam);
	}

}

void  CALLBACK OnChangeChState(HTREEITEM nItem,int type,int subtype,int nWndIndex, void* userParam)
{
	CRSLibDemoDlg* pDlgDev = (CRSLibDemoDlg*)userParam;
	CPViewDlg* pVideoPViewDlg = NULL;
	CHANNEL_INFO* pChannelInfo = NULL;
	pChannelInfo = (CHANNEL_INFO*)pDlgDev->m_devTree.GetItemData(nItem);
	SERVER_INFO* pServerInfo = NULL;
	pServerInfo = (SERVER_INFO*)pDlgDev->m_devTree.GetItemData(pDlgDev->m_devTree.GetParentItem(nItem));	
	switch(type)
	{
	case TYPE_USERCHANGE:
	
		break;
	case TYPE_FLICKER:

		break;
	case TYPE_CODESTREAM:
		
		break;
	case TYPE_DEFENCE:
		
		break;
	case TYPE_PREVIEW:
		{

		}
		break;
	case TYPE_LOGOUT:
		{
			if (pChannelInfo->bPreview)
			{
				pVideoPViewDlg = &pDlgDev->pViewDlg[pChannelInfo->iWndIndex];
				pVideoPViewDlg->PreviewStop();
			}
			pDlgDev->m_devTree.SetItemImage(nItem,ICO_CH_DISABLE,ICO_CH_DISABLE);
		
			pChannelInfo->bFlicker = FALSE;
		}
		break;
	default:
		break;
	}
}

/*************************************************************************/
/* function: AlarmRptCallback                                            */
/* params:  type: the alarm type code which defined in RSNetProtocol.h   */
/*          data: point to an struct object which stored the alarm info  */
/*          size: the size of the struct object which the params data    */
/*                pointed                                                */
/*          userParam: We usually use it to get the device info          */
/* return:                                                               */     
/* remark:  Handling the alarm msg which retuned by the device            */
/*************************************************************************/
void  RSNET_CALL AlarmRptCallback(WORD type, void* data, UINT size, void* userParam)
{
	CRSLibDemoDlg * pMainDlg =(CRSLibDemoDlg*)theApp.pMainFrame;
    SERVER_INFO* pServerInfo = (SERVER_INFO *)userParam;
    if (pMainDlg && pServerInfo) {
        if (pServerInfo->DevLoginRsp.GetAlarmChns && (type == MsgMotionAlarm || type == MsgIOAlarm || type == MsgVLossAlarm)) {
            for(int i = 0; i < pServerInfo->DevLoginRsp.ChannelNum; i++) {
                int channel = 0;
                int status = 0;
                if (i < 32) {
                    if((((RsNetAlarmRpt*)data)->Channel >> i) & 0x1)
                        channel = i;//mark i+1;
                    else
                        continue;
                    status = ((((RsNetAlarmRpt*)data)->Status >> i) & 0x1);
                }else{
                    if((((RsNetAlarmRpt*)data)->Channel_EX[i/32-1] >> (i%32)) & 0x1)
                        channel = i;
                    else
                        continue;
                    status = ((((RsNetAlarmRpt*)data)->Status_EX[i/32-1] >> (i%32)) & 0x1);
                }
                pMainDlg->DoSingleAlarm(type, data, size, userParam, FALSE, channel, status);
            }
        } else {
            pMainDlg->DoSingleAlarm(type, data, size, userParam);
        }
    }
}

void CRSLibDemoDlg::DoSingleAlarm(WORD type, void* data, UINT size, void* userParam, BOOL useDefault, int channel, int status_) {
	alarm_info_t* pInfo = new alarm_info_t;
	memset(pInfo, 0, sizeof(alarm_info_t));
	pInfo->pServerInfo = (SERVER_INFO *)userParam;
	pInfo->alarm_type = type;
	UINT status = AlarmOff;
	SYSTEMTIME tm;
	GetLocalTime(&tm);
	BOOL bSimpleCmd = FALSE;
    void* pData = data;

	switch (type)
	{
	case MsgMotionAlarm:
		{
			MotionAlarmRpt *pMotionAlarmRpt = new MotionAlarmRpt;
			memcpy(pMotionAlarmRpt, pData, sizeof(MotionAlarmRpt) <= size ? sizeof(MotionAlarmRpt):size);
			pMotionAlarmRpt->AlarmTime.Day = (BYTE)tm.wDay;
			pMotionAlarmRpt->AlarmTime.Hour = (BYTE)tm.wHour;
			pMotionAlarmRpt->AlarmTime.Minute = (BYTE)tm.wMinute;
			pMotionAlarmRpt->AlarmTime.Month = (BYTE)tm.wMonth;
			pMotionAlarmRpt->AlarmTime.Second = (BYTE)tm.wSecond;
			pMotionAlarmRpt->AlarmTime.Year = tm.wYear;
			pInfo->data = pMotionAlarmRpt;
			pInfo->startTime = GetTickCount();
			pInfo->chNum = pMotionAlarmRpt->Channel;
			status = pMotionAlarmRpt->Status;
            if (!useDefault) {
                pInfo->chNum = channel;
                status = status_;
                pMotionAlarmRpt->Channel = channel;
                pMotionAlarmRpt->Status = status;
            }
		}
		break;
	case MsgRecordStatusReport://212  R
		{
			RecordStatusRpt* pDevRecord = new RecordStatusRpt;
			int nSize = sizeof(RecordStatusRpt);
			memset(pDevRecord, 0, nSize);
			memcpy(pDevRecord, pData, nSize <= size ? nSize:size);
			pInfo->data = pDevRecord;
			pInfo->startTime = GetTickCount();
			pInfo->chNum = pDevRecord->ChannelNum;
			status = pDevRecord->RecordStatus;
            if (!useDefault) {
                pInfo->chNum = channel;
                status = status_;
            }
		}
		break;
	case MsgIOAlarm:
		{
			IOAlarmRpt *pIOAlarmRpt = new IOAlarmRpt;
			memcpy(pIOAlarmRpt, pData, sizeof(IOAlarmRpt) <= size ? sizeof(IOAlarmRpt):size);
			pIOAlarmRpt->AlarmTime.Day = (BYTE)tm.wDay;
			pIOAlarmRpt->AlarmTime.Hour = (BYTE)tm.wHour;
			pIOAlarmRpt->AlarmTime.Minute = (BYTE)tm.wMinute;
			pIOAlarmRpt->AlarmTime.Month = (BYTE)tm.wMonth;
			pIOAlarmRpt->AlarmTime.Second = (BYTE)tm.wSecond;
			pIOAlarmRpt->AlarmTime.Year = tm.wYear;
			pInfo->data = pIOAlarmRpt;
			pInfo->startTime = GetTickCount();
			pInfo->chNum = pIOAlarmRpt->Channel;
			status = pIOAlarmRpt->Status;
            if (!useDefault) {
                pInfo->chNum = channel;
                status = status_;
                pIOAlarmRpt->Channel = channel;
                pIOAlarmRpt->Status = status;
            }
		}
		break;
	case MsgIntelligentAlarm:
		{
			AIAlarmRpt *pAIAlarmRpt = new AIAlarmRpt;
			memcpy(pAIAlarmRpt, pData, sizeof(AIAlarmRpt) <= size ? sizeof(AIAlarmRpt):size);
			pAIAlarmRpt->AlarmTime.Day = (BYTE)tm.wDay;
			pAIAlarmRpt->AlarmTime.Hour = (BYTE)tm.wHour;
			pAIAlarmRpt->AlarmTime.Minute = (BYTE)tm.wMinute;
			pAIAlarmRpt->AlarmTime.Month = (BYTE)tm.wMonth;
			pAIAlarmRpt->AlarmTime.Second = (BYTE)tm.wSecond;
			pAIAlarmRpt->AlarmTime.Year = tm.wYear;
			pInfo->data = pAIAlarmRpt;
			pInfo->chNum = pAIAlarmRpt->Channel;
			pInfo->startTime = GetTickCount();
			status = pAIAlarmRpt->Status;
            if (!useDefault) {
                pInfo->chNum = channel;
                status = status_;
                pAIAlarmRpt->Channel = channel;
                pAIAlarmRpt->Status = status;
            }
		}
		break;
	case  MsgDevAllStatusReq:
		{
			DevAllStatusRpt * pDevStat = new DevAllStatusRpt;
			ZeroMemory(pDevStat,sizeof(DevAllStatusRpt));
			memcpy(pDevStat,pData,sizeof(DevAllStatusRpt) <= size ? sizeof(DevAllStatusRpt):size);
			pDevStat->AlarmTime.Day = tm.wDay;
			pDevStat->AlarmTime.Hour = tm.wHour;
			pDevStat->AlarmTime.Minute = tm.wMinute;
			pDevStat->AlarmTime.Month = tm.wMonth;
			pDevStat->AlarmTime.Second = tm.wSecond;
			pDevStat->AlarmTime.Year = tm.wYear;
			pInfo->data = pDevStat;
			pInfo->startTime = GetTickCount();
			bSimpleCmd = TRUE;
		}
		break;
	case  MsgRemoteCHStatusReport:
		{
			RemoteChnStatusRpt *pRemoteStatus = new RemoteChnStatusRpt;
			memcpy(pRemoteStatus, pData, sizeof(RemoteChnStatusRpt) <= size ? sizeof(RemoteChnStatusRpt):size);

			pInfo->data = pRemoteStatus;
			pInfo->chNum = pInfo->pServerInfo->chIndex++;
			pInfo->startTime = GetTickCount();
			bSimpleCmd = TRUE;
		}
		break;
    case MsgGpsInfoReport:
        {
            GpsInfoPacketRpt * pGpsRtp = new GpsInfoPacketRpt;
            ZeroMemory(pGpsRtp,sizeof(GpsInfoPacketRpt));
            memcpy(pGpsRtp,pData,sizeof(GpsInfoPacketRpt) <= size ? sizeof(GpsInfoPacketRpt):size);
            pGpsRtp->AlarmTime.Day = tm.wDay;
            pGpsRtp->AlarmTime.Hour = tm.wHour;
            pGpsRtp->AlarmTime.Minute = tm.wMinute;
            pGpsRtp->AlarmTime.Month = tm.wMonth;
            pGpsRtp->AlarmTime.Second = tm.wSecond;
            pGpsRtp->AlarmTime.Year = tm.wYear;
            pInfo->data = pGpsRtp;
            pInfo->startTime = GetTickCount();
        }
        break;
    case MsgDevStatReport:
        {
            CHANNEL_INFO* pChannelInfo = NULL;
            SERVER_INFO* pServerInfo = pInfo->pServerInfo;
            if ((pServerInfo->DevLoginRsp.DevType >> 40 & 0xf) != 3)
                return;

            bool bOldNvr = (pServerInfo->DevLoginRsp.NvrFlag == 0) ? true : false;
            DevStatRpt* pDevStatus = reinterpret_cast<DevStatRpt *>(pData);
            int nChannelIndex = pDevStatus->Channel;
            int nChannelStatus = pDevStatus->Status;
            if (pServerInfo->pDevChnInfo){
                DevChnInfo* pNVRChannelInfo = pServerInfo->pDevChnInfo;
                pNVRChannelInfo[nChannelIndex].CurChnState = nChannelStatus;
            }

            HTREEITEM hChildItem = m_devTree.GetChildItem(pServerInfo->hItem);
            while(hChildItem){
                hChildItem = m_devTree.GetNextSiblingItem(hChildItem);
                pChannelInfo = (CHANNEL_INFO*)m_devTree.GetItemData(hChildItem);
                if (pChannelInfo->iChannelNo == nChannelIndex){
                    bool bOnLine = false;
                    if (bOldNvr){
                        if (nChannelStatus){
                            bOnLine = true;
                        }
                    }else{
                        if (nChannelStatus == IPCS_ONLINE){
                            bOnLine = true;
                        }
                    }

                    if (bOnLine){
                        m_devTree.SetItemImage(hChildItem,ICO_CH_ENABLE,ICO_CH_ENABLE);
                    }else{
                        m_devTree.SetItemImage(hChildItem,ICO_CH_DISABLE,ICO_CH_DISABLE);
                    }

                    break;
                }
                hChildItem = m_devTree.GetNextSiblingItem(hChildItem);
            }
            return;
        }
        break;
    case MsgRemoteCHStatusReq:
        {
            SERVER_INFO* pServerInfo = pInfo->pServerInfo;
            bool bOldNvr = (pServerInfo->DevLoginRsp.NvrFlag == 0) ? true : false;
            RemoteChnStatusRpt* pRemoteChnstatus = reinterpret_cast<RemoteChnStatusRpt *>(pData);
            int nStructSize = pRemoteChnstatus->StructSize;
            int nNVRChannelInfoSize = nStructSize - sizeof(pRemoteChnstatus->StructSize) - sizeof(pRemoteChnstatus->channel);
            int nTotalSize = size;
            int nStructNum = nTotalSize / nStructSize;
            
            DevChnInfo* pNvrDevInfo = pServerInfo->pDevChnInfo;
            for (int i = 0; i < nStructNum; i++){
                memcpy(pNvrDevInfo, &pRemoteChnstatus->ChnInfo, nNVRChannelInfoSize);
                pRemoteChnstatus = (RemoteChnStatusRpt *)((BYTE*)pRemoteChnstatus + nStructSize);
                ++pNvrDevInfo;
            }

            pNvrDevInfo = pServerInfo->pDevChnInfo;
            HTREEITEM hChildItem = m_devTree.GetChildItem(pServerInfo->hItem);
            for (int i = 0; i < nStructNum; i++){
                if (hChildItem){
                    if (bOldNvr){
                        if (pNvrDevInfo->CurChnState){
                            m_devTree.SetItemImage(hChildItem,ICO_CH_ENABLE,ICO_CH_ENABLE);
                        }
                    }else{
                        if (pNvrDevInfo->CurChnState == IPCS_ONLINE){
                            m_devTree.SetItemImage(hChildItem,ICO_CH_ENABLE,ICO_CH_ENABLE);
                        }
                    }	
                    hChildItem = m_devTree.GetNextSiblingItem(hChildItem);
                }else{
                    break;
                }
                ++pNvrDevInfo;
            }
            return;
        }
        break;
	case MsgVLossAlarm:
		{
			RSNetCmdParam cmdParam;
			memset(&cmdParam, 0, sizeof(cmdParam));
			cmdParam.ParamMainType = MsgStatusRequest;
			cmdParam.ParamSubType = MsgDevAllStatusReq;
			RSNetSimpleCmd(pInfo->pServerInfo->pNetConnection,&cmdParam);

            VLossAlarmRpt *pAlarmRpt = new VLossAlarmRpt;
            memcpy(pAlarmRpt, pData, sizeof(VLossAlarmRpt) <= size ? sizeof(VLossAlarmRpt):size);
            pAlarmRpt->AlarmTime.Day = (BYTE)tm.wDay;
            pAlarmRpt->AlarmTime.Hour = (BYTE)tm.wHour;
            pAlarmRpt->AlarmTime.Minute = (BYTE)tm.wMinute;
            pAlarmRpt->AlarmTime.Month = (BYTE)tm.wMonth;
            pAlarmRpt->AlarmTime.Second = (BYTE)tm.wSecond;
            pAlarmRpt->AlarmTime.Year = tm.wYear;
            pInfo->data = pAlarmRpt;
            pInfo->startTime = GetTickCount();
            pInfo->chNum = pAlarmRpt->Channel;
            status = pAlarmRpt->Status;
            if (!useDefault) {
                pInfo->chNum = channel;
                status = status_;
                pAlarmRpt->Channel = channel;
                pAlarmRpt->Status = status;
            }
		}
    case MsgIntelIpcPeaAlarm:
    case MsgIpcOSCAlarm:
    case MsgIntelIpcPeaAreaAlarm:
        {
            DevStatRpt *pAlarmRpt = new DevStatRpt;
            memcpy(pAlarmRpt, pData, sizeof(DevStatRpt) <= size ? sizeof(DevStatRpt):size);
            pAlarmRpt->AlarmTime.Day = (BYTE)tm.wDay;
            pAlarmRpt->AlarmTime.Hour = (BYTE)tm.wHour;
            pAlarmRpt->AlarmTime.Minute = (BYTE)tm.wMinute;
            pAlarmRpt->AlarmTime.Month = (BYTE)tm.wMonth;
            pAlarmRpt->AlarmTime.Second = (BYTE)tm.wSecond;
            pAlarmRpt->AlarmTime.Year = tm.wYear;
            pInfo->data = pAlarmRpt;
            pInfo->startTime = GetTickCount();
            pInfo->chNum = pAlarmRpt->Channel;
            status = pAlarmRpt->Status;
            if (!useDefault) {
                pInfo->chNum = channel;
                status = status_;
                pAlarmRpt->Channel = channel;
                pAlarmRpt->Status = status;
            }
        }
        break;
	default:
		break;
	}
	::PostMessage(GetSafeHwnd(), WM_INSERT_LIST, (WPARAM)pInfo, (LPARAM)type);
}

/************************************************************************/
/* function: OnConnectionMsg                                             */
/* params:wparam,lparam                                                  */
/* return:  if success return S_OK else S_FALSE                          */     
/* remark: Get and handling some msg which returned by the RSNet.dll on  */
/*         login the device                                              */
           
/************************************************************************/
LRESULT CRSLibDemoDlg::OnConnectionMsg(WPARAM wparam, LPARAM lparam)
{	
	CRSLibDemoDlg* pMainFrame= (CRSLibDemoDlg *)theApp.GetMainWnd();
	CString strIP,strTime,strType,strInfo,strCh,strName;
	UINT code = (UINT)wparam;
	SERVER_INFO* pServerInfo = NULL;
	CHANNEL_INFO* pChannelInfo = NULL;
	HTREEITEM hChildItem;

	switch(code)
	{
	case RSNetMsgConnectStart:
		pServerInfo = (SERVER_INFO*)lparam;
		strInfo = _T("connect start");
		break;
	case RSNetMsgConnectSuccess:
		pServerInfo = (SERVER_INFO*)lparam;
		strInfo = _T("connect success");
		break;
	case RSNetMsgConnectFail:
		pServerInfo = (SERVER_INFO*)lparam;
		strInfo = _T("connect fail");
		pServerInfo->bLinkState = FALSE;
		break;
	case RSNetMsgConnectClosed:
		pServerInfo = (SERVER_INFO*)lparam;
		m_devTree.SetItemImage(pServerInfo->hItem,ICO_DEV_AIL,ICO_DEV_AIL);
		m_devTree.Expand(pServerInfo->hItem, TVE_EXPAND);
		hChildItem = m_devTree.GetChildItem(pServerInfo->hItem);		
		while (hChildItem)
		{	
			m_devTree.SetItemImage(hChildItem,ICO_CH_DISABLE,ICO_CH_DISABLE);	
			hChildItem = m_devTree.GetNextSiblingItem(hChildItem);
		}
		strInfo = _T("Connect is closed");
		pServerInfo->bLinkState = FALSE;
		break;
	case RSNetMsgLoginRequest:
		pServerInfo = (SERVER_INFO*)lparam;
		strInfo = _T("Login requesting");
		pServerInfo->bLinkState = FALSE;
		break;
	case RSNetMsgLoginSuccess:
		{
			pServerInfo = (SERVER_INFO*)lparam;
			RSNetGetDevInfo(pServerInfo->pNetConnection, &pServerInfo->DevLoginRsp,sizeof(LoginRsp));
			WORD size = pServerInfo->DevLoginRsp.ChnInfoSize;
			m_devTree.SetItemImage(pServerInfo->hItem,ICO_DEV_LOGIN,ICO_DEV_LOGIN);
			m_devTree.Expand(pServerInfo->hItem, TVE_EXPAND);
			strInfo = _T("Login successed");
			pMainFrame->GetDlgItem(IDC_BTN_CONFIG)->EnableWindow(TRUE);
			pServerInfo->bLinkState = TRUE;

            int nDeviceType = pServerInfo->DevLoginRsp.DevType >> 40 & 0xf;
            if (nDeviceType != 3){//not NVR
                hChildItem=m_devTree.GetChildItem(pServerInfo->hItem);
                while (hChildItem)
                {	
                    pChannelInfo = (CHANNEL_INFO*)m_devTree.GetItemData(hChildItem);
                    if (pChannelInfo->iChannelNo >= pServerInfo->DevLoginRsp.ChannelNum)
                    {
                        break;
                    }
                    m_devTree.SetItemImage(hChildItem,ICO_CH_ENABLE,ICO_CH_ENABLE);	
                    hChildItem = m_devTree.GetNextSiblingItem(hChildItem);
                }
            }else{//if is NVR,please send MsgRemoteCHStatusReq to the NVR in order to get channel's status.
                int nSize = pServerInfo->DevLoginRsp.ChannelNum * sizeof(DevChnInfo);
                if (pServerInfo->pDevChnInfo == NULL){
                    pServerInfo->pDevChnInfo = new DevChnInfo[(int)(pServerInfo->DevLoginRsp.ChannelNum)];
                }
                memset(pServerInfo->pDevChnInfo, 0, nSize);
                
                RSNetCmdParam param = {0};
                param.ParamMainType = MsgStatusRequest;
                param.ParamSubType = MsgRemoteCHStatusReq;
                RSNetSimpleCmd(pServerInfo->pNetConnection,&param);
            }
			pChannelInfo = NULL;
		}
		break;
	case RSNetMsgLoginUserLogined:
		pServerInfo = (SERVER_INFO*)lparam;
		strInfo = _T("User has logined");
		pServerInfo->bLinkState = FALSE;
		break;
	case RSNetMsgLoginNoUserName:
		pServerInfo = (SERVER_INFO*)lparam;
		strInfo = _T("User name is not exist");
		pServerInfo->bLinkState = FALSE;
		break;
	case RSNetMsgLoginPasswordError:
		pServerInfo = (SERVER_INFO*)lparam;
		strInfo = _T("Password error");
		pServerInfo->bLinkState = FALSE;
		break;
	case RSNetMsgLoginFail:
		{
			pServerInfo = (SERVER_INFO*)lparam;
			strInfo = _T("Login failed");
			pServerInfo->bLinkState = FALSE;
			break;
		}

	case RSNetMsgPreviewWaitLogin:
		pChannelInfo = (CHANNEL_INFO*)lparam;
		pServerInfo = (SERVER_INFO*)m_devTree.GetItemData(m_devTree.GetParentItem(pChannelInfo->hItem));
		strInfo = _T("Wait login");
		break;
	case RSNetMsgPreviewOpenStream:
		pChannelInfo = (CHANNEL_INFO*)lparam;
		pServerInfo = (SERVER_INFO*)m_devTree.GetItemData(m_devTree.GetParentItem(pChannelInfo->hItem));
		strInfo = _T("Opening preview stream");
		break;
	case RSNetMsgPreviewOpenStreamSuccess:
		pChannelInfo = (CHANNEL_INFO*)lparam;
		pServerInfo = (SERVER_INFO*)m_devTree.GetItemData(m_devTree.GetParentItem(pChannelInfo->hItem));
		m_devTree.SetItemImage(pChannelInfo->hItem,ICO_CH_PREVIEW,ICO_CH_PREVIEW);	
		strInfo = _T("Open preview stream success");
		break;
	case RSNetMsgPreviewOpenStreamFail:
		pChannelInfo = (CHANNEL_INFO*)lparam;
		pServerInfo = (SERVER_INFO*)m_devTree.GetItemData(m_devTree.GetParentItem(pChannelInfo->hItem));
		strInfo = _T("Open preview stream failed");
		break;
	case RSNetMsgPreviewStreamClosed:
		pChannelInfo = (CHANNEL_INFO*)lparam;
		pServerInfo = (SERVER_INFO*)m_devTree.GetItemData(m_devTree.GetParentItem(pChannelInfo->hItem));
		strInfo = _T("preview stream closed");
		break;
	default:
		break;
	}
	if (pServerInfo == NULL)
	{
		return S_FALSE;
	}
	strName.Format("%s",pServerInfo->szName);
	strIP.Format("%s",pServerInfo->szIp);
	if (pChannelInfo != NULL)
	{
		strCh.Format(" %s",pChannelInfo->ChName);
	}
	HTREEITEM hItem = m_devTree.GetParentItem(pServerInfo->hItem);

	AREA_INFO* pInfo = NULL;
	pInfo = (AREA_INFO*)m_devTree.GetItemData(hItem);

	SYSTEMTIME AlarmTime;
	GetLocalTime(&AlarmTime);
	strTime.Format("%04d-%02d-%02d %02d:%02d:%02d",AlarmTime.wYear,AlarmTime.wMonth,AlarmTime.wDay,
		AlarmTime.wHour,AlarmTime.wMinute,AlarmTime.wSecond);

	return S_OK;
}

/************************************************************************/
/* function: GetPlayWnd                                                 */
/* params:                                                              */
/* return:                                                              */
/* remark: return an dlg pointer to preview the video                   */
/************************************************************************/
CPViewDlg* CRSLibDemoDlg::GetPlayWnd(int nCh)
{
	for(int i = 0; i < 4; i++)
	{
		if(!pViewDlg[i].m_bPlay)
		{
			return &pViewDlg[i];
		}
	}
	return NULL;
}

/************************************************************************/
/* function: OnNMDblclkTreeDev                                          */
/* params:                                                              */
/* return:                                                              */
/* remark: Close/Open the video preview on double clicked the tree item */
/************************************************************************/
void CRSLibDemoDlg::OnNMDblclkTreeDev(NMHDR *pNMHDR, LRESULT *pResult)
{
	//Open the video preview stream here
	m_hCurSelItem = m_devTree.GetSelectedItem();
	BYTE ItemType = GetSelItemType(m_hCurSelItem);
	if(ItemType == DevTreeType_Area || ItemType == DevTreeType_Dev)
	{
		return;
	}

	HTREEITEM hDevItem = m_devTree.GetParentItem(m_hCurSelItem);
	if(hDevItem == NULL)
	{
		return;
	}
	SERVER_INFO* pServerInfo = NULL;
	pServerInfo = (SERVER_INFO*)m_devTree.GetItemData(hDevItem);
	CHANNEL_INFO* pChannelInfo = NULL;
	pChannelInfo = (CHANNEL_INFO*)m_devTree.GetItemData(m_hCurSelItem);
	
	if (pChannelInfo->bPreview)
	{
		pViewDlg[pChannelInfo->iWndIndex].PreviewStop();
		return;
	}
	else
	{
		CPViewDlg* pVideoPViewDlg = NULL;
		pVideoPViewDlg = GetPlayWnd(pChannelInfo->iChannelNo);
		if(pVideoPViewDlg == NULL)
		{
			return;
		}
		pVideoPViewDlg->PreviewStop();
		pVideoPViewDlg->SetServerInfo(pServerInfo, pChannelInfo);
		pVideoPViewDlg->PreviewPlay();
	}
	
	*pResult = 0;
}

void CRSLibDemoDlg::SetCurPlayWnd(int pWnd_index)
{
	for(int i = 0; i< 4; i++)
	{
		if(i == pWnd_index)
		{
			pViewDlg[i].m_bChecked = TRUE;
			m_curPViewDlg = &pViewDlg[i];
		}
		else
		{
			pViewDlg[i].m_bChecked = FALSE;
		}
		pViewDlg[i].RedrawWindow();
	}

}

/************************************************************************/
/* function: PreTranslateMessage                                        */
/* params: pMsg                                                         */
/* return: BOOL                                                         */
/* remark: PTZ operation                                                */
/************************************************************************/

BOOL CRSLibDemoDlg::PreTranslateMessage(MSG* pMsg) 
{
	if (pMsg->message == WM_LBUTTONDOWN || pMsg->message == WM_LBUTTONUP)
	{
		
		PTZControlReq req;

		CHANNEL_INFO* pChannelInfo = m_curPViewDlg->m_pChannelInfo;
		if (pChannelInfo == NULL || m_curPViewDlg->m_bPlay == FALSE)
		{
			return CDialog::PreTranslateMessage(pMsg);
		}
		RSNetConnection gConn = m_curPViewDlg->m_pServerInfo->pNetConnection;

		req.Channel = pChannelInfo->iChannelNo;
		req.Normal.Flag = (pMsg->message == WM_LBUTTONDOWN ? PTZControlStart : PTZControlStop);
		req.Normal.Speed = 5;//m_speedCtrl.GetPos();

		int type = MsgNoSubType;
		HWND hwnd = pMsg->hwnd;
		if (hwnd == GetDlgItem(IDC_BTN_PTZUP)->GetSafeHwnd())
			type = MsgPTZUp;
		else if (hwnd == GetDlgItem(IDC_BTN_PTZDOWN)->GetSafeHwnd())
			type = MsgPTZDown;
		else if (hwnd == GetDlgItem(IDC_BTN_PTZLEFT)->GetSafeHwnd())
			type = MsgPTZLeft;
		else if (hwnd == GetDlgItem(IDC_BTN_PTZRIGHT)->GetSafeHwnd())
			type = MsgPTZRight;
		else if (hwnd == GetDlgItem(IDC_BTN_PTZLEFTT)->GetSafeHwnd())
			type = MsgPTZUpLeft;
		else if (hwnd == GetDlgItem(IDC_BTN_PTZRIGHTT)->GetSafeHwnd())
			type = MsgPTZUpRight;
		else if (hwnd == GetDlgItem(IDC_BTN_PTZLEFTB)->GetSafeHwnd())
			type = MsgPTZDownLeft;
		else if (hwnd == GetDlgItem(IDC_BTN_PTZRIGHTB)->GetSafeHwnd())
			type = MsgPTZDownRight;
		else if (hwnd == GetDlgItem(IDC_BZOOMIN)->GetSafeHwnd())
			type = MsgPTZZoomIn;
		else if (hwnd == GetDlgItem(IDC_BZOOMOUT)->GetSafeHwnd())
			type = MsgPTZZoomOut;
		else if (hwnd == GetDlgItem(IDC_BFOCUSNEAR)->GetSafeHwnd())
			type = MsgPTZFocusNear;
		else if (hwnd == GetDlgItem(IDC_BFOCUSFAR)->GetSafeHwnd())
			type = MsgPTZFocusFar;
		else if (hwnd == GetDlgItem(IDC_BIRISFAR)->GetSafeHwnd())
			type = MsgPTZIRISOpen;
		else if (hwnd == GetDlgItem(IDC_BIRISNEAR)->GetSafeHwnd())
			type = MsgPTZIRISClose;

		if (type != MsgNoSubType)
			RSNetPTZControl(gConn, type, &req);
	}

	if(pMsg->message == WM_KEYDOWN && ((pMsg->wParam == VK_ESCAPE)||(pMsg->wParam == VK_RETURN)))
		return TRUE;	

	return CDialog::PreTranslateMessage(pMsg);
}


void CRSLibDemoDlg::OnBnClickedBtnHelp()
{

}

void CRSLibDemoDlg::OnTvnSelchangedTreeDev(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);
	m_hCurSelItem = pNMTreeView->itemNew.hItem;
	*pResult = 0;
}

void CRSLibDemoDlg::OnBnClickedBtnConfig()
{
	CConfigDlg configDlg;
	configDlg.DoModal();
}


void CRSLibDemoDlg::OnBnClickedBtnPlayback()
{
	ShowVideoWnd(SHOW_PLAYBACK);
	if(mPlaybkDlg.m_pServerInfo == NULL)
	{
		if(g_ServerInfoList.GetSize() > 0)
		{
			mPlaybkDlg.SetServer(g_ServerInfoList.GetHead());
		}
	}
}

void CRSLibDemoDlg::OnBnClickedBtnPlayer()
{
	CLocalPlayer playerDlg;
	playerDlg.DoModal();
}

void CRSLibDemoDlg::OnBnClickedBtnPreview()
{
	ShowVideoWnd(SHOW_PREVIEW);
}

void CRSLibDemoDlg::OnBnClickedBtnSimpleCmd()
{
	// TODO: ڴӿؼ֪ͨ
	if (msimpleCmdDlg.GetSafeHwnd() == NULL)
	{
		msimpleCmdDlg.Create(msimpleCmdDlg.IDD, this);
	}
	SERVER_INFO* pServerInfo = NULL;
	HTREEITEM hDevItem = NULL;
	BYTE ItemType = GetSelItemType(m_hCurSelItem);
	if(ItemType == DevTreeType_Area)
	{
		return;
	}
	else if (ItemType == DevTreeType_Dev)
	{
		hDevItem = m_hCurSelItem;
	}
	else if (ItemType == DevTreeType_Ch)
	{
		hDevItem = m_devTree.GetParentItem(m_hCurSelItem);
	}
	if(hDevItem == NULL)
	{
		return;
	}
	pServerInfo = (SERVER_INFO*)m_devTree.GetItemData(hDevItem);
	msimpleCmdDlg.m_pServerInfo = pServerInfo;
    msimpleCmdDlg.m_bClose = FALSE;
	msimpleCmdDlg.m_listInfo.DeleteAllItems();
	msimpleCmdDlg.CenterWindow();
	msimpleCmdDlg.ShowWindow(SW_SHOW);
}

void CRSLibDemoDlg::OnBnClickedButtonEncrypt()
{
	// TODO: ڴӿؼ֪ͨ
	m_bEncrypt = !m_bEncrypt;
	RSNetSetEncription(m_bEncrypt);
	if (m_bEncrypt)
	{
		GetDlgItem(IDC_BUTTON_ENCRYPT)->SetWindowText("No Encrypt");
	}
	else
	{
		GetDlgItem(IDC_BUTTON_ENCRYPT)->SetWindowText("Encrypt");
	}
}

void CRSLibDemoDlg::OnBnClickedBtnCapture()
{
    // TODO: ڴӿؼ֪ͨ
    SERVER_INFO* pServerInfo = NULL;
    HTREEITEM hDevItem = NULL;
    BYTE ItemType = GetSelItemType(m_hCurSelItem);
    if(ItemType == DevTreeType_Area)
        return;
    else if (ItemType == DevTreeType_Dev)
        hDevItem = m_hCurSelItem;
    else if (ItemType == DevTreeType_Ch)
        hDevItem = m_devTree.GetParentItem(m_hCurSelItem);

    if(hDevItem == NULL)
        return;
    pServerInfo = (SERVER_INFO*)m_devTree.GetItemData(hDevItem);

    if (pServerInfo && pServerInfo->bUseFlag)
    {
        RSNetDevCaptureParam param = {0};
        param.jpgParam.StructSize = sizeof(param.jpgParam);
        param.jpgParam.wPicSize = SIZE_VGA;
        param.jpgParam.wPicQuality = 0;

        SYSTEMTIME tm;
        GetLocalTime(&tm);
        int nCh = 0;
        CString strPicName = _T("");
        strPicName.Format("%s%4d%02d%02d%02d%02d%02d_%d.jpg", \
            theApp.m_strAppPath, tm.wYear, tm.wMonth, tm.wDay, tm.wHour, tm.wMinute, tm.wSecond, nCh);
        memcpy(param.FileName, strPicName.GetBuffer(0), MAX_PATH - 1);
        param.Channel = nCh;

        BOOL bResult = RSNetCapture(pServerInfo->pNetConnection, &param);
        if (bResult)
            TRACE("Capture Success\n");
        else
            TRACE("Capture Fail\n");
    }
}
