#ifndef __RSMedia_h__
#define __RSMedia_h__

//////////////////////////////////////////////////////////////////////////
//RSFrame

//RSVFrameHead.System
#define RSSystemPAL		'P'
#define RSSystemNTSC	'N'

typedef struct
{
	WORD Width;
	WORD Height;
	BYTE FrameRate;
	BYTE System;
    BYTE WaterMark : 1;//2013-03-04 10:37:18  
    BYTE bRefFrame : 1;
    BYTE Reserved : 6;
    BYTE Reserved1;
}RSVideoHead;

typedef struct
{
	UINT SampleRate;
	BYTE Channels;
	BYTE BitsPerSample;
	WORD PackLen;
}RSAudioHead;

//RSFrameHead.FrameTag
#define RSFrameTag	*(UINT*)"RSFm"

//RSFrameHead.FrameType
#define RSIFrame	'I'
#define RSPFrame	'P'
#define RSAFrame	'A'

//RSFrameHead.EncodeType
/* Video */
#define RSVideoEncodeH264	             0x01
#define RSVideoH264FFMPEG	             0x02
#define RSVideoEncodeMPEG4	             0x03
#define RSVideoEncodeMJPEG	             0x04
#define RSVideoEncodeJPEG	             0x05
#define RSVideoEncodeMP4	             0x06
#define RSVideoEncodeH265	             0x07
#define RSVideoH265FFMPEG	             0x08

/* Audio */
#define RSAudioEncodeG711A	             0x01
#define RSAudioEncodeG711U               0x02
#define RSAudioEncodeADPCM_DVI4			 0x03
#define RSAudioEncodeG726_16KBPS	     0x04
#define RSAudioEncodeG726_24KBPS		 0x05
#define RSAudioEncodeG726_32KBPS		 0x06
#define RSAudioEncodeG726_40KBPS		 0x07
#define RSAudioEncodeAMR                 0x08
#define RSAudioEncodeAMRDTX              0x09
#define RSAudioEncodeAAC                 0x0a
#define RSAudioEncodeAT_10116            0x19  /* 8kbps 10116 rfc1890*/
#define RSAudioEncodeAT_G721             0x1a  /* 8kbps G721  rfc1890 */
#define RSAudioEncodeAT_GSM              0x1b  /* 8kbps Gsm   rfc1890 */
#define RSAudioEncodeAT_LPC              0x1c  /* 8kbps lpc   rfc1890 */
#define RSAudioEncodeAT_G722             0x1e  /* 8kbps G722  rfc1890 */
#define RSAudioEncodeAT_G728             0x1f  /* 8kbps G728  rfc1890 */
#define RSAudioEncodeADPCM_IMA           0x23

typedef struct
{
	UINT FrameTag;

	BYTE FrameType;
	BYTE EncodeType;
	BYTE Channel : 7;
	BYTE Encrypted : 1;
	BYTE Reserved;

	UINT FrameNo;
	UINT FrameSize;
	ULONGLONG Time; //(microseconds) Time/1000,000 = the number of seconds after January 1, 1970 UTC
	ULONGLONG Pts;

	union
	{
		RSVideoHead VideoHead;
		RSAudioHead AudioHead;
	};
}RSFrameHead;

//////////////////////////////////////////////////////////////////////////
//RSFile

//File content outline
/*
	RSFileHead
	RSFileHeadInfo(extensible)

	Frame ... Frame

	//TailInfo

	RSFileListHead
	(optional list head info)
	RSFileFrameIndex(extensible) ... RSFileFrameIndex(extensible)

	(extensible)
*/

#define RSFileDataAlign	8 //File data alignment

#ifndef C_ASSERT
#define C_ASSERT(e) typedef char __C_ASSERT__[(e)?1:-1]
#endif

#define CheckFileDataAlign(type) C_ASSERT(sizeof(type) % RSFileDataAlign == 0)

//RSFileHead.Tag
#define RSFileTag	*(ULONGLONG*)"ALRSFile" //Identify ALRS media file

//RSFileHead.Status
#define RSFileFull			*(UINT*)"Full"
#define RSFileWritingData	*(UINT*)"Data"

const int E_WAITER = 2;

#ifndef _WIN32
typedef struct _GUID {
	unsigned long  Data1;
	unsigned short Data2;
	unsigned short Data3;
	unsigned char  Data4[ 8 ];
} GUID;
#endif

typedef struct
{
	ULONGLONG Tag; //RSFileTag
	UINT HeadInfoSize; //sizeof(RSFileHeadInfo)
	UINT Status; //RSFileFull ...
	ULONGLONG TailInfoOffset; //Tail info offset from the beginning of the file
	GUID Guid; //Unique identifier for this file
}RSFileHead;
CheckFileDataAlign(RSFileHead);

typedef struct
{
	ULONGLONG BeginTime; //Equal to RSFrameHead.Time
	ULONGLONG EndTime; //Equal to RSFrameHead.Time
}RSFileHeadInfo;
CheckFileDataAlign(RSFileHeadInfo);

#define RSFileListTagPrefix			"List"
#define RSFileListTagPrefixValue	*(UINT*)RSFileListTagPrefix
#define RSFileIndexListTag		*(ULONGLONG*)RSFileListTagPrefix##"Idx"

typedef struct
{
	ULONGLONG Tag; //RSFileIndexListTag ...
	WORD ListHeadInfoSize; //Extra list head info size, 0 for RSFileIndexListTag
	WORD ItemSize; //One subsequent item size, sizeof(RSFileFrameIndex) for RSFileIndexListTag
	UINT ListSize; //Extra list head info size plus all subsequent item size
}RSFileListHead;
CheckFileDataAlign(RSFileListHead);

typedef struct
{
	ULONGLONG Time; //Equal to RSFrameHead.Time
	ULONGLONG Offset; //Frame offset from the beginning of the file
}RSFileFrameIndex;
CheckFileDataAlign(RSFileFrameIndex);

typedef enum FileType
{
    FILE_NORMAL = 0,
    FILE_RS,
    FILE_AVI,
    FILE_D9
}RSFILE_TYPE;

typedef enum DeviceType
{
    RS_DEV_RSNEW = 0,
    RS_DEV_HIK,
    RS_DEV_RSOLD,
}DEVICE_TYPE;

typedef struct __RS_DEC_FRAME_S__
{
    unsigned char*  pY;                   //Y plane base address of the picture
    unsigned char*  pU;                   //U plane base address of the picture
    unsigned char*  pV;                   //V plane base address of the picture
    unsigned char*  pReserved;            //Not used
    unsigned long   uWidth;               //The width of output picture in pixel
    unsigned long   uHeight;              //The height of output picture in pixel
    unsigned long   uYStride;             //Luma plane stride in pixel
    unsigned long   uUVStride;            //Chroma plane stride in pixel
} RS_DEC_FRAME_S;

#define MAX_FRAME_SIZE 1024*1024*2
typedef struct __RS_FRAME_S__
{
    RSFrameHead    frame_head;
    unsigned char  frame_data[MAX_FRAME_SIZE];
}RS_FRAME_S;

typedef struct __RS_PICTURE_S__
{
    RSFrameHead    frame_head;
    RS_DEC_FRAME_S dec_frame_head;
    unsigned char  picture_data[8];
}RS_PICTURE_S;

#endif
