
#include "stdafx.h"
#include "RSLibDemo.h"
#include "RecDownDlg.h"
#include "ConfigDlg.h"
IMPLEMENT_DYNAMIC(CRecDownDlg, CDialog)
#define MONTH_REC_SEARCH 0
#define DAY_REC_SEARCH   1
#define	  ID_TIMER_FILE_DOWN		600
#define   WM_DOWNFILE_CLOSE		    WM_USER + 400
#define   WM_DOWNFILE_PRECENT		WM_USER + 401
/////////////////////////////////////////////////////////////////////////////
// CRecFileDownDlg message handlers
void  RSNET_CALL FileDownStatusCallback(UINT code, UINT param, void* userParam);

/********************************code value define*****************************/
/* RSNetMsgDownloadRecordClosed		290 //ؽʱparam =0
/* RSNetMsgDownloadRecordOK			291 //һļʱparam =0
/* RSNetMsgDownloadRecordNoFile		292 //һļڣʱparam =0
/* RSNetMsgDownloadRecordFail		293 //ļʧܣʱparam =0
/* RSNetMsgDownloadRecordStoreFail	294 //ļ洢ʧܣʱparam =0
/* RSNetMsgDownloadRecordPercent	295 //أʱparam = ǰذٷֱȣ磺param==50,ʾǰ50%
/*****************************************************************************/
void  RSNET_CALL FileDownStatusCallback(UINT code, UINT param, void* userParam)
{
	TRACE("FileDownStatusCallback	%d %d\n",code,param);
	CRecDownDlg* pThis = (CRecDownDlg*)userParam;
	pThis->PostMessage(code+WM_USER,param,NULL);
}

/////////////////////////////////////////////////////////////////////////////
//RSNetQueryRecordParam.DayOutlineCallback
void  RSNET_CALL QueryRecordDayOutlineCallback(const RecordDayOutlineRsp* rsp, void* userParam);
void  RSNET_CALL QueryRecordDayOutlineCallback(const RecordDayOutlineRsp* rsp, void* userParam)
{
	TRACE("RecordDayOutlineRsp	%d %d %d %d\n",rsp->Year,rsp->Month,rsp->Day,rsp->StructSize);
	CRecDownDlg* pThis = (CRecDownDlg*)userParam;
	if (pThis != NULL && rsp)
	{
		((CButton*)(pThis->GetDlgItem(IDC_CHECK1 + rsp->Day -1)))->SetCheck(TRUE);
	}
}

//RSNetQueryRecordParam.DetailCallback
void RSNET_CALL QueryRecordDetailCallback(const RecordDetailRsp* rsp, void* userParam);
void RSNET_CALL QueryRecordDetailCallback(const RecordDetailRsp* rsp, void* userParam)
{
	CRecDownDlg* pThis = (CRecDownDlg*)userParam;
	if (pThis != NULL && rsp)
	{
		
		recfile_info_t* recFile = new recfile_info_t;
		recFile->rsp = *rsp;
		recFile->state = FileDowm_Not;
		recFile->DownloadRecord = NULL;
		pThis->recFileArray.Add(recFile);
		pThis->AppendToList(recFile);
	}
}

/////////////////////////////////////////////////////////////////////////////

CRecDownDlg::CRecDownDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRecDownDlg::IDD, pParent)
	,m_ChNum(0)
	,m_iCurSelItem(0)
	,m_pServerInfo(NULL)
	,m_bPlay(FALSE)
	,m_iPlayID(0)
	,m_bSysPlay(FALSE)
	,m_NetRecordPlay(NULL)
	,m_playMode(PLAY_MODE_NORMAL)
	,m_bRec(FALSE)
	,m_nSpeed(30)
	, m_strCurPlayTime(_T("12323"))
	, m_bOnlyIFrame(FALSE)
{
    m_bDowning = FALSE;
}

CRecDownDlg::~CRecDownDlg()
{
	if(m_NetRecordPlay != NULL)
	{
		RSNetStopRecordPlay(&m_NetRecordPlay);
		m_NetRecordPlay = NULL;
	}
	for(int i = 0; i< recFileArray.GetCount(); i++)
	{
		delete recFileArray[i];
	}
	recFileArray.RemoveAll();
}

void CRecDownDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_CBO_MONTH, m_cboMonth);
	DDX_Control(pDX, IDC_CTRL_DATE, m_DateCtrl);
	DDX_Control(pDX, IDC_COMBO_CH, m_comboCh);
	DDX_Control(pDX, IDC_LIST_FILE, m_ListFile);
	DDX_Control(pDX, IDC_PB_WND, m_PBVideoWnd);
	DDX_Text(pDX, IDC_STATIC_CURPLAYTIME, m_strCurPlayTime);
	DDX_Control(pDX, IDC_DATE_YEAR, m_fileDate);
	DDX_Control(pDX, IDC_DATE_HOUR, m_fileTime);
}


BEGIN_MESSAGE_MAP(CRecDownDlg, CDialog)
	ON_BN_CLICKED(IDOK, &CRecDownDlg::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BTN_SEARCH_MOTH, &CRecDownDlg::OnBnClickedBtnSearchMoth)
	ON_BN_CLICKED(IDC_BTN_SEARCH_DAY, &CRecDownDlg::OnBnClickedBtnSearchDay)
	ON_BN_CLICKED(IDC_BUTTON_START, &CRecDownDlg::OnBnClickedButtonStart)
	ON_BN_CLICKED(IDC_BUTTON_STOP, &CRecDownDlg::OnBnClickedButtonStop)
	ON_BN_CLICKED(IDC_BT_PBSTART, &CRecDownDlg::OnBnClickedBtPbstart)
	ON_BN_CLICKED(IDC_BT_PBSTOP, &CRecDownDlg::OnBnClickedBtPbstop)
	ON_MESSAGE(WM_RECORD_PLAY_MSG, &CRecDownDlg::OnRecordPlayMsg)
	ON_BN_CLICKED(IDC_BT_PBPAUSE, &CRecDownDlg::OnBnClickedBtPbpause)
	ON_WM_TIMER()
	ON_BN_CLICKED(IDC_BT_CAPTRUE, &CRecDownDlg::OnBnClickedBtCaptrue)
	ON_BN_CLICKED(IDC_BT_TIMEPOS, &CRecDownDlg::OnBnClickedBtTimepos)
	ON_BN_CLICKED(IDC_BTN_ONLY_I, &CRecDownDlg::OnBnClickedBtnOnlyI)
END_MESSAGE_MAP()


void CRecDownDlg::OnBnClickedOk()
{
	OnOK();
}

BOOL CRecDownDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	CString strTemp;
	for(int i = 0; i < 12; i++)
	{
		strTemp.Format("%d",i+1);
		m_cboMonth.InsertString(i,strTemp);
	}
	m_cboMonth.SetCurSel(0);
	if(g_ServerInfoList.GetSize() > 0)
	{
		SetServer(g_ServerInfoList.GetHead());
	}

	COLORREF COLOR = RGB(0x00, 0x00, 0x00);
	m_ListFile.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES|LVS_EX_SUBITEMIMAGES|LVS_EX_CHECKBOXES);
	m_ListFile.SetTextColor(COLOR);
	m_ListFile.InsertColumn(0, "", LVCFMT_LEFT, 28);
	m_ListFile.InsertColumn(1, _T("Index"), LVCFMT_LEFT, 50);
	m_ListFile.InsertColumn(2, _T("Begin Time"), LVCFMT_LEFT, 130);
	m_ListFile.InsertColumn(3, _T("End Time"), LVCFMT_LEFT, 130);
	m_ListFile.InsertColumn(4, _T("State"), LVCFMT_LEFT, 100);
	m_ListFile.InsertColumn(5, _T("Size"), LVCFMT_LEFT, 90);
	m_ListFile.InsertColumn(6, "DownPath", LVCFMT_LEFT, 0);
	m_ListFile.Init();
	m_ListFile.SetAltRowColors(TRUE,RGB(180,180,180),RGB(160,160,160));

	SetTimer(ID_TIMER_FILE_DOWN,500,NULL);

	return TRUE;  
}

void CRecDownDlg::SetServer(SERVER_INFO *serInfo)
{
	m_pServerInfo = serInfo;
	m_ChNum = m_pServerInfo->DevLoginRsp.ChannelNum;

	for(int i=0;i<m_ChNum;i++)
	{
		CString strCh;
		strCh.Format("%s%d","CH",i+1);
		m_comboCh.InsertString(i,strCh);
	}
	m_comboCh.SetCurSel(0);
}

void CRecDownDlg::CheckAllDays(BOOL bCheck)
{
	for(int i = 0; i < 31; i++)
	{
		((CButton*)GetDlgItem(IDC_CHECK1 + i))->SetCheck(bCheck);
	}
}

BYTE CRecDownDlg::GetDaysInMonth (int iMonth, int iYear)
{
	static int nMonthLen [] = 
	{	
		31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 
	};

	int nRes = nMonthLen [iMonth - 1];
	if (iMonth == 2 && iYear % 4 == 0 && 
		(iYear % 100 != 0 || iYear % 400 == 0))
	{
		nRes = 29;
	}

	return nRes;
}


void CRecDownDlg::SearchRecFile(int type)
{
	RSNetConnection gConn = m_pServerInfo->pNetConnection;	
	RSNetQueryRecordParamEx param;
    memset(&param, 0, sizeof(param));
	param.userParam = this;
	param.Req.Channel = m_comboCh.GetCurSel();
	param.Req.Type = AllRecord;
    param.StreamType = 0;//0 main stream,1 sub stream

	COleDateTime m_Date;
	m_DateCtrl.GetTime(m_Date);
	param.Req.Begin.Year = m_Date.GetYear();
	param.Req.Begin.Month = m_Date.GetMonth();
	param.Req.Begin.Hour = 0;
	param.Req.Begin.Minute = 0;
	param.Req.Begin.Second = 0;

	param.Req.End.Year = m_Date.GetYear();
	param.Req.End.Month = m_Date.GetMonth();
	param.Req.End.Day = GetDaysInMonth(m_Date.GetMonth(),m_Date.GetYear());
	param.Req.End.Hour = 23;
	param.Req.End.Minute = 59;
	param.Req.End.Second = 59;

	if (type == MONTH_REC_SEARCH)//Month search
	{
		param.DayOutlineCallback = QueryRecordDayOutlineCallback;
		param.DetailCallback = NULL;
		param.Type = MsgRecordDayOutline;
		param.Req.Begin.Day = 1;
        param.Req.Channel = 0x1 << m_comboCh.GetCurSel();
		RSNetQueryRecordEx(gConn, &param);
	}
	else if (type == DAY_REC_SEARCH)//Day search
	{
		param.DayOutlineCallback = NULL;
		param.DetailCallback = QueryRecordDetailCallback;
		param.Type = MsgRecordDetail;
		param.Req.Begin.Day = m_Date.GetDay();
		param.Req.End.Day = m_Date.GetDay();
		BOOL ret = RSNetQueryRecordEx(gConn, &param);
	}
}

void CRecDownDlg::OnBnClickedBtnSearchMoth()
{
	CheckAllDays(FALSE);
	SearchRecFile(MONTH_REC_SEARCH);
}

void CRecDownDlg::OnBnClickedBtnSearchDay()
{
	m_ListFile.DeleteAllItems();
	for(int i = 0; i< recFileArray.GetCount(); i++)
	{
		delete recFileArray[i];
	}
	recFileArray.RemoveAll();
	SearchRecFile(DAY_REC_SEARCH);
}

void CRecDownDlg::OnStartFileDown(int item)
{
	recfile_info_t *recfile_info= recFileArray.GetAt(item);
	CString strFileName;
	strFileName = m_ListFile.GetItemText(item,6);
	if (theApp.m_nRecFileType == RSFileType)
	{
		strFileName += ".";
		strFileName += _T("avi");
	}
	else if (theApp.m_nRecFileType == RSAVIFileType)
	{
		strFileName += ".";
		strFileName +=  _T("264");
	}
	RSNetDownloadRecordLocalParam localParam;
	sprintf_s(localParam.FileName, "%s", strFileName);
	localParam.FileType = theApp.m_nRecFileType;
	CreateFoler(strFileName);
	RSNetDownloadRecordParam param;
	param.Channel =m_comboCh.GetCurSel();
	param.DevRecordFile = (const RecordDetailRsp*)&recfile_info->rsp;
	param.LocalParam = (const RSNetDownloadRecordLocalParam*)&localParam;
	param.StatusCallback = FileDownStatusCallback;
	param.UserParam = this;
	recfile_info->DownloadRecord  = RSNetStartDownloadRecord(m_pServerInfo->pNetConnection, &param);	
	if (recfile_info->DownloadRecord  == 0)
	{
		m_ListFile.SetItemData(item,FileDowm_Not);
		m_ListFile.SetItemText(item,4,"No Down");
		recfile_info->state = FileDowm_Not;
		m_bDowning = FALSE;
	}
	else
	{
		m_ListFile.SetItemData(item,FileDowm_Downing);
		m_ListFile.SetItemText(item,4,"DownLoading");
		recfile_info->state = FileDowm_Downing;
		m_bDowning = TRUE;
	}
	m_DownItem = item;
}

void CRecDownDlg::OnStopFileDown(int item,int state)
{
	recfile_info_t *recfile_info= recFileArray.GetAt(item);
	switch(state)
	{
	case FileDowm_Downing:
		{
			m_ListFile.SetItemText(item,4,"Not Download");
			RSNetStopDownloadRecord(&recfile_info->DownloadRecord);
			if (item == m_DownItem)
			{
				m_bDowning = FALSE;
			}	
			m_DownItem = -1;
		}
		break;
	case FileDowm_Waitting:
		{
			m_ListFile.SetItemText(item,4,"Not Download");
		}
		break;
	case FileDowm_Complete:
		{
			m_ListFile.SetItemText(item,4,"Completed");
			RSNetStopDownloadRecord(&recfile_info->DownloadRecord);
			m_bDowning = FALSE;
		}
		break;
	default:
		break;
	}
	m_ListFile.SetItemData(item,FileDowm_Not);
	recfile_info->state = FileDowm_Not;
	recfile_info->DownloadRecord = NULL;
	//m_RecTimeCtrl->m_pWndInfo[m_nIndex].pRecfile->SetAt(item,recfile_info);
}

void CRecDownDlg::AppendToList(const recfile_info_t* recFile)
{
		int itemCount = m_ListFile.GetItemCount();

		CString strBegin,strEnd,strState,strNo,strDown;

		int count = 1;
		for (int i=0;i<count;i++)
		{
			recfile_info_t *recfile_info= recFileArray.GetAt(itemCount);
			strNo.Format("%d",itemCount);
			DateTime start_time = recfile_info->rsp.Begin; 
			strBegin.Format("%04d-%02d-%02d %02d:%02d:%02d",start_time.Year,
				start_time.Month,
				start_time.Day,
				start_time.Hour,start_time.Minute,start_time.Second);

			DateTime end_time = recfile_info->rsp.End; 
			strEnd.Format("%04d-%02d-%02d %02d:%02d:%02d",end_time.Year,
				end_time.Month,
				end_time.Day,
				end_time.Hour,end_time.Minute,end_time.Second);

			strDown.Format("%s\\%s\\CH%d\\%04d%02d%02d\\%02d%02d%02d-%02d%02d%02d", 
				theApp.m_strAppPath,m_pServerInfo->szIp,m_comboCh.GetCurSel()+1,
				start_time.Year,start_time.Month,start_time.Day,start_time.Hour,start_time.Minute,start_time.Second,
				end_time.Hour,end_time.Minute,end_time.Second);

			int state = recfile_info->state;
			switch(state)
			{
			case FileDowm_Not:
				strState ="Not Download";
				break;
			case FileDowm_Waitting:
				strState = "Waiting";
				break;
			case FileDowm_Downing:
				strState = "Downloading";
				break;
			case FileDowm_Complete:
				strState = "Completed";
				break;
			default:
				break;
			}
			double iFileM = recfile_info->rsp.Size/(1024.0*1024.0);
			CString strSize;
			strSize.Format("%.2fM",iFileM);
			int iItem = m_ListFile.InsertItem(itemCount, "");
			m_ListFile.SetItemText(itemCount, 1, strNo);
			m_ListFile.SetItemText(itemCount, 2, strBegin);
			m_ListFile.SetItemText(itemCount, 3, strEnd);
			m_ListFile.SetItemText(itemCount, 4, strState);
			m_ListFile.SetItemText(itemCount, 5,strSize);
			m_ListFile.SetItemText(itemCount, 6,strDown);
			m_ListFile.SetItemData(iItem,state);
		}

}
void CRecDownDlg::OnBnClickedButtonStart()
{
	CString strState;
	int count = m_ListFile.GetItemCount();
	BOOL bFirst = TRUE;
	for(int i=0;i<count;i++)
	{
		BOOL bCheck = m_ListFile.GetCheck(i);
		if (bCheck)
		{
			int state = m_ListFile.GetItemData(i);
			if (state == FileDowm_Not)
			{
				recfile_info_t *recfile_info = recFileArray.GetAt(i);
				int state = m_ListFile.SetItemData(i,FileDowm_Waitting);
				if ((!m_bDowning)&&bFirst)
				{
					m_ListFile.SetItemText(i,4,"Downloading");
					bFirst = FALSE;
				}
				else
				{
					m_ListFile.SetItemText(i,4,"Waiting");
				}

				recfile_info->state = FileDowm_Waitting;
			}
		}
	}
}

void CRecDownDlg::OnBnClickedButtonStop()
{
	int count = m_ListFile.GetItemCount();
	for(int i=0;i<count;i++)
	{
		BOOL bCheck = m_ListFile.GetCheck(i);
		if (bCheck)
		{
			int state = m_ListFile.GetItemData(i);
			if ((state == FileDowm_Waitting)||(state == FileDowm_Downing))
			{
				OnStopFileDown(i,state);
			}
		}
	}	
}

LRESULT CRecDownDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam) 
{
	switch(message - WM_USER)
	{	
	case RSNetMsgDownloadRecordClosed:
		OnStopFileDown(m_DownItem,FileDowm_Complete);	
		break;
	case RSNetMsgDownloadRecordPercent:
		{
			CString str;
			str.Format("%d%%",wParam);
			m_ListFile.SetItemText(m_iCurSelItem,4,str);
		}
		break;
	default:
		break;
	}	
	return CDialog::WindowProc(message, wParam, lParam);
}

void CRecDownDlg::OnBnClickedBtPbstart()
{
	OnPlay(PlayType_Play,FALSE);
}

void CRecDownDlg::OnBnClickedBtPbstop()
{
	OnPlay(PlayType_Stop,FALSE);
}

void CRecDownDlg::OnBnClickedBtPbpause()
{
	if(m_bPlay)
	{
		OnPlay(PlayType_Pause,FALSE);
	}
}


BOOL RSNET_CALL RecordPlayDataCallback(void* data, UINT size, void* userParam)
{
	CRecDownDlg* pthis = (CRecDownDlg*)userParam;
	HRESULT hr;
	if (pthis !=NULL)
	{
		/*RSFrameHead *pHead = (RSFrameHead *)data;
		if(pHead->FrameType == RSAFrame)
		{
		TRACE("frame type : %d\n", pHead->FrameType);
		}*/

		hr= RSPlayInputNetFrame(pthis->m_iPlayID, data, size);		
	}
	if (hr == E_OUTOFMEMORY)
		return FALSE;
	return TRUE;
}

void CRecDownDlg::OnPlay(int iPlayType,BOOL bSysPlay)		//bSysPlayͬű־λ
{

	if (m_pServerInfo!=NULL)
	{
		//======================================================
		if (iPlayType == PlayType_Play)				
		{
			if (!m_bPlay)
			{	
				COleDateTime m_Date;
				
				int itemCount = m_ListFile.GetItemCount();
				if (itemCount == 0)
				{
					m_DateCtrl.GetTime(m_Date);
				}
                else
				{
					for(int i=0;i<itemCount;i++)
					{
						BOOL bCheck = m_ListFile.GetCheck(i);
						if (bCheck)
						{
                          recfile_info_t *recfile_info = recFileArray.GetAt(i);
						  if (recfile_info != NULL)
						  {
							  m_Date.SetDateTime(recfile_info->rsp.Begin.Year,
								                 recfile_info->rsp.Begin.Month,
								                 recfile_info->rsp.Begin.Day,
												 recfile_info->rsp.Begin.Hour,
										         recfile_info->rsp.Begin.Minute,
												 recfile_info->rsp.Begin.Second);
							  break;
						  }
						}
					}
				}

				m_fileDate.SetTime(m_Date);
				m_fileTime.SetTime(m_Date);

				m_iPlayID = RSPlayCreatePlayInstance(PLAY_NETFILE_TYPE);
				RSPlaySetPlayWnd(m_iPlayID, m_PBVideoWnd.GetSafeHwnd());
				RSPlaySetCallbackMessage(m_iPlayID, this->GetSafeHwnd(), WM_RECORD_PLAY_MSG, this);
				m_bSysPlay = bSysPlay;			
				RSNetRecordPlayParamEx param;
                memset(&param, 0, sizeof(param));
				param.Channel = m_comboCh.GetCurSel();
				param.Type = AllRecord;//m_iRecType;
				param.Wnd = NULL;
				param.Message = 0;
				param.UserParam = this;
				param.DataCallback = RecordPlayDataCallback;
                param.StatusCallback = NULL;
                param.StreamType = 0;//0 main stream,1 sub stream

				param.Begin.Year = m_Date.GetYear();
				param.Begin.Month = m_Date.GetMonth();
				param.Begin.Day = m_Date.GetDay();
				param.Begin.Hour = 0;
				param.Begin.Minute = 0;
				param.Begin.Second = 0;

				param.End.Year = m_Date.GetYear();
				param.End.Month = m_Date.GetMonth();
				param.End.Day = m_Date.GetDay();
				param.End.Hour = 23;
				param.End.Minute = 59;
				param.End.Second = 59;
				if (!bSysPlay)
				{
					RSPlayStartPlay(m_iPlayID);
				}
				m_NetRecordPlay = RSNetStartRecordPlayEx(m_pServerInfo->pNetConnection, &param);
				

				if (m_NetRecordPlay!=NULL)			//ɹ
				{			
					m_bPlay = TRUE;
				}

				if (m_NetRecordPlay == NULL)		//ʧ
				{
					RSPlayStopPlay(m_iPlayID);
					RSPlayDestroyPlayInstance(m_iPlayID);
					m_iPlayID = 0;
					m_bPlay = FALSE;
				}

				m_playMode = PLAY_MODE_NORMAL;	
				SetTimer(ID_TIMER_GET_PLAYTIME,1000,NULL);
			}
			else	//ͣ-ָ
			{
					RSPlaySetPlayMode(m_iPlayID, m_playMode,0);
			}
		}

		//===========================ֹͣť===========================
		else if (iPlayType == PlayType_Stop)			
		{
			if (!m_bPlay)
				return;

			if (m_bRec)
			{
				//OnFileRec(); //¼
			}
				
			RSNetStopRecordPlay(&m_NetRecordPlay);
			m_NetRecordPlay = NULL;
			if (!m_bSysPlay)
				RSPlayStopPlay(m_iPlayID);

			RSPlayDestroyPlayInstance(m_iPlayID);


			m_iPlayID = 0;
			m_nSpeed = 30;
			
			KillTimer(ID_TIMER_GET_PLAYTIME);
			//m_strTimeInfo = "0000-00-00 00:00:00";
			m_PBVideoWnd.Invalidate(TRUE);
			
			m_bPlay = FALSE;
			m_bSysPlay = FALSE;
		}

		//===========================һ֡֡Űť===========================
		else if (iPlayType == PlayType_SingleFrame)
		{
			RSPlaySetPlayMode(m_iPlayID, PLAY_MODE_SINGLE_FRAME,0);	
		}

		//===========================ͣť===========================
		else if (iPlayType == PlayType_Pause)
		{
			RSPlaySetPlayMode(m_iPlayID, PLAY_MODE_PAUSE,0);	
		}		
	}
}

LRESULT CRecDownDlg::OnRecordPlayMsg(WPARAM wparam, LPARAM lparam)
{

	CRecDownDlg* pthis = (CRecDownDlg*)lparam;
	if (pthis !=NULL)
	{
		if (pthis->m_pServerInfo->pNetConnection != NULL)
		{
			UINT code = (UINT)wparam;

			if (code == NET_FILE_DATA_NOT_ENOUGH)
			{
				if (pthis->m_NetRecordPlay != NULL)
					RSNetReqRecordData(pthis->m_NetRecordPlay);
			}
			else if ((code == FILE_PLAY_END)&&!m_bSysPlay)
			{
				OnPlay(PlayType_Stop,m_bSysPlay);
			}
		}
	}	
	return S_OK;
}

void CRecDownDlg::GetPlayedTime()
{
	ULONGLONG time = 0;
	time = RSPlayGetCurPlayedTime(m_iPlayID);
	if(m_bSysPlay)
	{
		time = RSPlayGetCurPlayedTime(m_iPlayID);
	}
	if (time != 0)
	{
		CTime date((time+500000)/1000000);
		tm st;
		date.GetGmtTm(&st);
		CString str;
		str.Format("%04d-%02d-%02d %02d:%02d:%02d",st.tm_year+1900,st.tm_mon+1,st.tm_mday,st.tm_hour,st.tm_min,st.tm_sec);
		m_strCurPlayTime = str;
		UpdateData(FALSE);
	}
}
void CRecDownDlg::OnTimer(UINT_PTR nIDEvent)
{
	 	switch(nIDEvent)
	 	{
	 		case ID_TIMER_GET_PLAYTIME:
	 			GetPlayedTime();
	 			break;
			case ID_TIMER_FILE_DOWN:
				{
					int count = m_ListFile.GetItemCount();
					for(int i=0;i<count;i++)
					{
						int state = m_ListFile.GetItemData(i);
						if ((state == FileDowm_Waitting)&&(m_bDowning == FALSE))
						{
							OnStartFileDown(i);
							m_iCurSelItem = i;
							break;
						}
					}
				}
	 		default:
	 			break;
	 	}	
	 	CDialog::OnTimer(nIDEvent);
}

void RSPLAY_CALL CRecDownDlg::CaptureDataCallback(BYTE* data, UINT size, int type, void* userParam)
{
	/*
	FILE* fp = 0;
	errno_t err = _wfopen_s(&fp, L"c:\\test.png", L"wb");
	fwrite(data, 1, size, fp);
	fclose(fp);
	CRecDownDlg* pThis = (CRecDownDlg*)userParam;
	*/
}

void CRecDownDlg::OnBnClickedBtCaptrue()
{
	CString capName;
	capName.Format("%s%d.bmp",_T("C:\\RSCapture\\"),GetTickCount());
	CreateFoler(capName);
	if(m_iPlayID != 0)
	{
		//RSPlayCapturePictureToBuf(m_iPlayID, CaptureDataCallback, this, 1);
		RSPlayCapturePicture(m_iPlayID, capName.GetBuffer());
	}
}



void CRecDownDlg::OnBnClickedBtTimepos()
{
	CTime date,time;
	m_fileDate.GetTime(date);
	m_fileTime.GetTime(time);
    
	ReposRecordDataReq  param;

	param.Begin.Year = date.GetYear();
	param.Begin.Month = date.GetMonth();
	param.Begin.Day = date.GetDay();
	param.Begin.Hour = time.GetHour();
	param.Begin.Minute = time.GetMinute();
	param.Begin.Second = time.GetSecond();

	param.End.Year = date.GetYear();
	param.End.Month = date.GetMonth();
	param.End.Day = date.GetDay();
	param.End.Hour = 23;
	param.End.Minute = 59;
	param.End.Second = 59;


	if (m_iPlayID!=0)
	{		
		RSNetReposRecordData(m_NetRecordPlay,&param);
		RSPlaySetPlayMode(m_iPlayID, PLAY_MODE_STOP,0);
		RSNetReplayRecordData(m_NetRecordPlay);
		TRACE("ChangePlayPos Time%d:%d:%d\n",time.GetHour(),time.GetMinute(),time.GetSecond());
	}

}

void CRecDownDlg::OnBnClickedBtnOnlyI()
{
	// TODO: ڴӿؼ֪ͨ
	if (m_pServerInfo == NULL)
	{ 
		return;
	}
	int nDevPlayBackCap = m_pServerInfo->DevLoginRsp.DevPlayBackCap;
	if (nDevPlayBackCap == 0){
		return;
	}

	if (!m_bOnlyIFrame)
	{
		GetDlgItem(IDC_BTN_ONLY_I)->SetWindowText("Close only I frame");
	} 
	else
	{
		GetDlgItem(IDC_BTN_ONLY_I)->SetWindowText("Only I frame");
	}

	BOOL bPreOnlyIFrame = m_bOnlyIFrame;
	m_bOnlyIFrame = !m_bOnlyIFrame;


	ULONGLONG ullTime = RSPlayGetCurPlayedTime(m_iPlayID);
	tm t = {0};
	time_t ltime = (ullTime+500000)/1000000;
	gmtime_s(&t, &ltime);

	RSPlayStopPlay(m_iPlayID);
	
	ChangePlayTime(t.tm_hour, t.tm_min, t.tm_sec);

	RSPlayStartPlay(m_iPlayID);


	IsOnlyIFrame(m_bOnlyIFrame);

	int nIFrameInterval = 0;
	if(m_bOnlyIFrame)
	{
		nIFrameInterval = 1000;
	}
	RSPlaySetPlayMode(m_iPlayID, PLAY_MODE_NORMAL,nIFrameInterval);
}

void CRecDownDlg::IsOnlyIFrame(BOOL bOnlyIFrame)
{
	int nDevPlayBackCap = m_pServerInfo->DevLoginRsp.DevPlayBackCap;

	BOOL bPrePlayOnlyIFrame = !m_bOnlyIFrame;
	PlaySpeedCtrl nSpeed;
	if (bOnlyIFrame)
	{
		nSpeed = PLAY_TYPE_I_CONTINUOUS;
	} 
	else
	{
		nSpeed = PLAY_TYPE_NORMAL;
	}

	if (m_NetRecordPlay){
		if (bPrePlayOnlyIFrame && !m_bOnlyIFrame){
			RSNetReqRecordPlayCtrol(m_NetRecordPlay, nSpeed);
			return;
		}

		if (nDevPlayBackCap == 1){
			if (!bPrePlayOnlyIFrame && m_bOnlyIFrame){
				RSNetReqRecordPlayCtrol(m_NetRecordPlay, nSpeed);
			}
		}else if (nDevPlayBackCap == 2){
			if (m_bOnlyIFrame){
				RSNetReqRecordPlayCtrol(m_NetRecordPlay, nSpeed);
			}
		}
	}
}

void CRecDownDlg::ChangePlayTime(int nHour, int nMin, int nSec)
{
	if (m_iPlayID!=0)
	{		
		CTime date;
		m_fileDate.GetTime(date);

		ReposRecordDataReq  param;
		param.Begin.Year = date.GetYear();
		param.Begin.Month = date.GetMonth();
		param.Begin.Day = date.GetDay();
		param.Begin.Hour = nHour;
		param.Begin.Minute = nMin;
		param.Begin.Second = nSec;
		param.End.Year = date.GetYear();
		param.End.Month = date.GetMonth();
		param.End.Day = date.GetDay();
		param.End.Hour = 23;
		param.End.Minute = 59;
		param.End.Second = 59;

		DateTime time;
		memcpy(&time,&(param.Begin),sizeof(DateTime));

		RSNetReposRecordData(m_NetRecordPlay,&param);
		RSPlaySetPlayMode(m_iPlayID, PLAY_MODE_STOP,0);
		RSNetReplayRecordData(m_NetRecordPlay);

// 		CPlayBackMngDlg* pMngDlg = (CPlayBackMngDlg*)GetParent();
// 		pMngDlg->m_dlg_PbRbToolDlg.m_RecTimeCtrl.SetPointerTime(m_nIndex,time,m_bSysPlay);	
// 		TRACE("ChangePlayPos WndIndex=%d Time%d:%d:%d\n",m_nIndex,nHour,nMin,nSec);
// 		pMngDlg->m_dlg_PbRbToolDlg.m_RecTimeCtrl.ShowPointer(m_nIndex,TRUE,m_bSysPlay);
	}
}
