// RecPlanDlg.cpp : ʵļ
//

#include "stdafx.h"
#include "RSLibDemo.h"
#include "RecPlanDlg.h"
#include "DeviceManager/RSDevice.h"

// CRecPlanDlg Ի

IMPLEMENT_DYNAMIC(CRecPlanDlg, CDialog)

CRecPlanDlg::CRecPlanDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CRecPlanDlg::IDD, pParent),
    m_ChNum(0),
    m_nPreChSel(-1),
    m_pServerInfo(NULL),
    m_nPartsInTwoHour(4)
{

}

CRecPlanDlg::~CRecPlanDlg()
{
}

void CRecPlanDlg::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_COMBO_CH, m_comboCh);
    DDX_Control(pDX, IDC_STATIC_ALARM, m_ctrlAlarm);
}


BEGIN_MESSAGE_MAP(CRecPlanDlg, CDialog)
    ON_CBN_SELCHANGE(IDC_COMBO_CH, &CRecPlanDlg::OnCbnSelchangeComboCh)
    ON_BN_CLICKED(ID_BTN_QUERY, &CRecPlanDlg::OnBnClickedBtnQuery)
    ON_BN_CLICKED(ID_BTN_SET, &CRecPlanDlg::OnBnClickedBtnSet)
    ON_BN_CLICKED(IDC_RADIO_NORMAL, &CRecPlanDlg::OnBnClickedRadioNormal)
    ON_BN_CLICKED(IDC_RADIO_MOTION, &CRecPlanDlg::OnBnClickedRadioMotion)
    ON_BN_CLICKED(IDC_RADIO_ALARM, &CRecPlanDlg::OnBnClickedRadioAlarm)
END_MESSAGE_MAP()

BOOL CRecPlanDlg::OnInitDialog()
{
    CDialog::OnInitDialog();

    CString strCh;
    m_ChNum = m_pServerInfo->DevLoginRsp.ChannelNum;
    for(int i=0;i<m_ChNum;i++){
        strCh.Format("%s%d","CH",i+1);
        m_comboCh.InsertString(i,strCh);
    }
    m_comboCh.SetCurSel(0);

    int nDevType = m_pServerInfo->DevLoginRsp.DevType >> 40 & 0xf;
    BYTE nUIType = m_pServerInfo->DevLoginRsp.UiType;
    if (nDevType != DEV_NVR && nUIType != RS_UI_3_0){
        m_nPartsInTwoHour = 2;
        m_ctrlAlarm.setPartsInTwoHour(m_nPartsInTwoHour);
    }

    CRect clientRect, rectTitle;
    GetClientRect(&clientRect);
    clientRect.top += 100;
    clientRect.bottom -= 50;
    m_ctrlAlarm.MoveWindow(clientRect);

    ((CButton*)(GetDlgItem(IDC_RADIO_NORMAL)))->SetCheck(TRUE);

    return TRUE;
}

void CRecPlanDlg::OnCbnSelchangeComboCh()
{
    UpdateData(TRUE);

    int ch = m_comboCh.GetCurSel();
    if (m_nPreChSel!= ch) {
        GetRecDataFromCtrls(m_nPreChSel);
        m_nPreChSel = ch;
    }
    SetRecDataToCtrls(m_nPreChSel);

    UpdateData(FALSE);
}

void CRecPlanDlg::OnBnClickedBtnQuery()
{
    RSNetQueryParamParamEx param;
    ZeroMemory(&param, sizeof(param));
    ZeroMemory(ScheduleArr, sizeof(ScheduleArr));
    param.ListParamSize = sizeof(RSNet_SoleScheduleSet_t);
    param.ListParamNum = m_ChNum;
    param.ListParam = ScheduleArr;
    param.ParamType = MsgParamSchedule;

    ChannelParamReq req;
    req.StructSize = sizeof(req);
    req.ChannelMask[0] = UINT_MAX;
    param.Req = &req;

    if (RSNetQueryParamEx(m_pServerInfo->pNetConnection, &param))
    {
        if (m_nPreChSel == -1) {
            m_nPreChSel = 0;
            m_comboCh.SetCurSel(0);      
        }
        OnCbnSelchangeComboCh();
        AfxMessageBox("Query record plan succeed!");
    }else{
        AfxMessageBox("Query record plan succeed!");
    }
}

void CRecPlanDlg::OnBnClickedBtnSet()
{
    int chSel = m_comboCh.GetCurSel();
    GetRecDataFromCtrls(chSel);

    RSNetSetParamParam param;
    ZeroMemory(&param, sizeof(param));
    param.ParamType = MsgParamSchedule;
    param.ListParams = ScheduleArr;
    param.ListParamNum = m_ChNum;

    if (RSNetSetParam(m_pServerInfo->pNetConnection,&param))
        AfxMessageBox("Set record plan succeed!");
    else
        AfxMessageBox("Set record plan succeed!");
}

void CRecPlanDlg::GetRecDataFromCtrls(int chNo)
{
    if (m_nPartsInTwoHour == 4){
        m_ctrlAlarm.getScheduleData(&ScheduleArr[chNo].HalfHour[0][0], sizeof(ScheduleArr[chNo].HalfHour));
    }else{
        memset(m_nTempUse, 0, sizeof(m_nTempUse));
        m_ctrlAlarm.getScheduleData(&m_nTempUse[0][0], sizeof(m_nTempUse));
        //
        BYTE nNormalData = 0x1 << NORMAL_TYPE;
        BYTE nMotionData = 0x1 << MOTION_TYPE;
        BYTE nAlarmData = 0x1 << ALARM_TYPE;

        for (int i = 0; i < 7; i++) {
            for (int j = 0; j < 24; j++) {
                if (m_nTempUse[i][j] & nNormalData){
                    ScheduleArr[chNo].NormalHour[i] |= 0x1 << j;
                }else{
                    ScheduleArr[chNo].NormalHour[i]  &= ~(0x1 << j);
                }

                if (m_nTempUse[i][j] & nMotionData){
                    ScheduleArr[chNo].MotionHour[i] |= 0x1 << j;
                }else{
                    ScheduleArr[chNo].MotionHour[i]  &= ~(0x1 << j);
                }

                if (m_nTempUse[i][j] & nAlarmData){
                    ScheduleArr[chNo].AlarmHour[i] |= 0x1 << j;
                }else{
                    ScheduleArr[chNo].AlarmHour[i]  &= ~(0x1 << j);
                }
            }
        }
    }
}

void CRecPlanDlg::SetRecDataToCtrls(int chNo)
{
    if (m_nPartsInTwoHour == 4) {
        m_ctrlAlarm.setScheduleData(&ScheduleArr[chNo].HalfHour[0][0], sizeof(ScheduleArr[chNo].HalfHour));
    }else{
        memset(m_nTempUse, 0, sizeof(m_nTempUse));
        
        BYTE nNormalData = 0x1 << NORMAL_TYPE;
        BYTE nMotionData = 0x1 << MOTION_TYPE;
        BYTE nAlarmData = 0x1 << ALARM_TYPE;

        for (int i = 0; i < 7; i++) {
            for (int j = 0; j < 24; j++) {
                if (ScheduleArr[chNo].NormalHour[i] & (0x1 << j)){
                    m_nTempUse[i][j] |= nNormalData;
                }else{
                    m_nTempUse[i][j] &= ~nNormalData;
                }
                
                if (ScheduleArr[chNo].MotionHour[i] & (0x1 << j)){
                    m_nTempUse[i][j] |= nMotionData;
                }else{
                    m_nTempUse[i][j] &= ~nMotionData;
                }

                if (ScheduleArr[chNo].AlarmHour[i] & (0x1 << j)){
                    m_nTempUse[i][j] |= nAlarmData;
                }else{
                    m_nTempUse[i][j] &= ~nAlarmData;
                }
            }
        }

        m_ctrlAlarm.setScheduleData(&m_nTempUse[0][0], sizeof(m_nTempUse));
    }
}

void CRecPlanDlg::OnBnClickedRadioNormal()
{
    m_ctrlAlarm.setCurrentType(NORMAL_TYPE);
}

void CRecPlanDlg::OnBnClickedRadioMotion()
{
    m_ctrlAlarm.setCurrentType(MOTION_TYPE);
}

void CRecPlanDlg::OnBnClickedRadioAlarm()
{
    m_ctrlAlarm.setCurrentType(ALARM_TYPE);
}
