// RecScheduleCtrl.cpp : ʵļ
//

#include "stdafx.h"
#include "RecScheduleCtrl.h"

// CRecScheduleCtrl

IMPLEMENT_DYNAMIC(CRecScheduleCtrl, CStatic)

CRecScheduleCtrl::CRecScheduleCtrl()
{
    //m_nBackGroundColor = RGB(240, 240, 240);//AS Test
    m_nBackGroundColor = RGB(255, 255, 255);
    m_nLineColor = RGB(85, 85, 89);
    m_PenLine.CreatePen(PS_SOLID, 1, m_nLineColor);
    m_nPartsInTwoHour = 4;
    m_nRecordType = (1<<NORMAL_TYPE) | (1<<MOTION_TYPE) | (1<<ALARM_TYPE);
    m_nRecordCount = 3;
    m_bSaved = FALSE;
    m_nCurrentType = NORMAL_TYPE;

    memset(m_nHalfHour, 0, sizeof(m_nHalfHour));
}

CRecScheduleCtrl::~CRecScheduleCtrl()
{
}


BEGIN_MESSAGE_MAP(CRecScheduleCtrl, CStatic)
    //{{AFX_MSG_MAP(CCheckGroupCtrl)
    ON_WM_PAINT()
    ON_WM_ERASEBKGND()
    ON_WM_SIZE()
    ON_WM_MOUSEMOVE()
    ON_WM_LBUTTONDOWN()
    ON_WM_LBUTTONUP()
    //}}AFX_MSG_MAP
END_MESSAGE_MAP()

void CRecScheduleCtrl::OnPaint() 
{
    CPaintDC dc(this);
    
    CRect rect;
    GetClientRect(&rect);

    CBitmap bmp;
    CBitmap* pOldBitmap = NULL;
    CDC memDC;
    memDC.CreateCompatibleDC(&dc);
    bmp.CreateCompatibleBitmap(&dc,rect.Width(),rect.Height());
    pOldBitmap = memDC.SelectObject(&bmp);

    if (m_bSaved){
        {
            CDC memDCTemp;
            memDCTemp.CreateCompatibleDC(&memDC);
            CBitmap *pOldBitmap = memDCTemp.SelectObject(&m_bitmapBackGround);
            memDC.BitBlt(0,0,rect.Width(),rect.Height(),&memDCTemp,0,0,SRCCOPY);
            memDCTemp.SelectObject(pOldBitmap);
        }
        if (m_bLButtonDown)
            drawMoveRect(memDC, rect);
    }else{
        memDC.FillSolidRect(rect, m_nBackGroundColor);
        drawData(memDC, rect);
        drawScale(memDC, rect);

        {
            CDC memDCTemp;
            memDCTemp.CreateCompatibleDC(&memDC);
            if (m_bitmapBackGround.GetSafeHandle())
                m_bitmapBackGround.DeleteObject();
            m_bitmapBackGround.CreateCompatibleBitmap(&memDC, rect.Width(), rect.Height());

            CBitmap *pOldBitmap = memDCTemp.SelectObject(&m_bitmapBackGround);
            memDCTemp.BitBlt(0,0,rect.Width(),rect.Height(),&memDC,0,0,SRCCOPY);
            memDCTemp.SelectObject(pOldBitmap);
        }
        m_bSaved = TRUE;
    }

    dc.BitBlt(0,0,rect.Width(),rect.Height(),&memDC,0,0,SRCCOPY);

    memDC.SelectObject(pOldBitmap); 
    memDC.DeleteDC();
}

BOOL CRecScheduleCtrl::OnEraseBkgnd(CDC* pDC) 
{
    return TRUE;
}

void CRecScheduleCtrl::OnSize(UINT nType, int cx, int cy) 
{
    CStatic::OnSize(nType, cx, cy);
    m_bSaved = FALSE;
    Invalidate();
}

void CRecScheduleCtrl::OnLButtonDown(UINT nFlags, CPoint point) 
{
    CStatic::OnLButtonDown(nFlags, point);
    SetCapture();
    m_bLButtonDown = TRUE;
    m_startPoint = point;
}

void CRecScheduleCtrl::OnMouseMove(UINT nFlags, CPoint point)
{
    CStatic::OnMouseMove(nFlags, point);
    m_endPoint = point;
    Invalidate();
}

void CRecScheduleCtrl::OnLButtonUp(UINT nFlags, CPoint point)
{
    CStatic::OnLButtonUp(nFlags, point);
    ReleaseCapture();
    m_endPoint = point;
    updateScheduleData();
    m_bLButtonDown = FALSE;
    m_bSaved = FALSE;
    Invalidate();
}

void CRecScheduleCtrl::drawScale(CDC& dc, const CRect& rect)
{
    CPen* pOldPen = dc.SelectObject(&m_PenLine);
    dc.SetTextColor(m_nLineColor);
    dc.SetBkMode(TRANSPARENT);

    int nVLineNum = 12*m_nPartsInTwoHour;
    int nHLineNum = 7*m_nRecordCount;
    int nVStart1 = rect.top+15;
    int nVStart2 = rect.top+20;
    int nVStart3 = rect.top+30;
    int nHStart1 = rect.left;
    int nHStart2 = rect.left+30;
    int nCellWidth = (int)(1.0*(rect.Width()-30)/nVLineNum);
    int nCellHeight = (int)(1.0*(rect.Height()-30)/nHLineNum);
    int nRight = rect.left + 30 + nCellWidth*nVLineNum;
    int nBottom = rect.top + 30 + nCellHeight*nHLineNum;
    CRect rectTitle;
    rectTitle.top = 0;
    rectTitle.bottom = nVStart1;

    CString strTemp;
    if (m_nPartsInTwoHour == 4){
        for (int i = 0; i < nVLineNum; i++){
            if (i%4){
                dc.MoveTo(nHStart2, nVStart2);
            }else{
                rectTitle.left = nHStart2-7;
                rectTitle.right = nHStart2+7;
                strTemp.Format("%d", i/4*2);
                dc.DrawText(strTemp, &rectTitle,DT_CENTER);
                dc.MoveTo(nHStart2, nVStart1);
            }
            dc.LineTo(nHStart2, nBottom);
            nHStart2 += nCellWidth;
        }
        rectTitle.left = nHStart2-7;
        rectTitle.right = nHStart2+7;
        strTemp.Format("%d", nVLineNum/4*2);
        dc.DrawText(strTemp, &rectTitle,DT_CENTER);
        dc.MoveTo(nHStart2, nVStart1);
        dc.LineTo(nHStart2, nBottom);
    }else if (m_nPartsInTwoHour == 2){
        for (int i = 0; i < nVLineNum; i++){
            if (i%2){
                dc.MoveTo(nHStart2, nVStart2);
            }else{
                rectTitle.left = nHStart2-7;
                rectTitle.right = nHStart2+7;
                strTemp.Format("%d", i);
                dc.DrawText(strTemp, &rectTitle,DT_CENTER);
                dc.MoveTo(nHStart2, nVStart1);
            }
            dc.LineTo(nHStart2, nBottom);
            nHStart2 += nCellWidth;
        }
        rectTitle.left = nHStart2-7;
        rectTitle.right = nHStart2+7;
        strTemp.Format("%d", nVLineNum);
        dc.DrawText(strTemp, &rectTitle,DT_CENTER);
        dc.MoveTo(nHStart2, nVStart1);
        dc.LineTo(nHStart2, nBottom);
    }
    nHStart2 = rect.left+30;

    CStringArray strArray;
    strArray.Add("Sun.");
    strArray.Add("Mon."); 
    strArray.Add("Tue."); 
    strArray.Add("Wed."); 
    strArray.Add("Thu."); 
    strArray.Add("Fri."); 
    strArray.Add("Sat."); 
    rectTitle.left = nHStart1;
    rectTitle.right = nHStart2;
    for (int i = 0; i < nHLineNum; i++){
        if (i%3){
            dc.MoveTo(nHStart2, nVStart3);
        }else{
            if (i){
                rectTitle.top = nVStart3-20;
                rectTitle.bottom = nVStart3;
                dc.DrawText(strArray.GetAt(i/3), &rectTitle,DT_CENTER);
            }
            dc.MoveTo(nHStart1, nVStart3);
        }
        dc.LineTo(nRight, nVStart3);
        nVStart3 += nCellHeight;
    }
    rectTitle.top = nVStart3-20;
    rectTitle.bottom = nVStart3;
    dc.DrawText(strArray.GetAt((nHLineNum-1)/3), &rectTitle,DT_CENTER);
    dc.MoveTo(nHStart1, nVStart3);
    dc.LineTo(nRight, nVStart3);

    dc.SelectObject(pOldPen);
}

void CRecScheduleCtrl::drawData(CDC& dc, const CRect& rect)
{
    int nVLineNum = 12*m_nPartsInTwoHour;
    int nHLineNum = 7*m_nRecordCount;
    int nCellWidth = (int)(1.0*(rect.Width()-30)/nVLineNum);
    int nCellHeight = (int)(1.0*(rect.Height()-30)/nHLineNum);
    int nHeight = 30;

    for (int i = 0; i < 7; i++) {
        for (int j = 0; j < nVLineNum; j++) {
            if (m_nHalfHour[i][j] & (0x1 << NORMAL_TYPE)){
                dc.FillSolidRect(30+j*nCellWidth, nHeight+i*nCellHeight, nCellWidth, nCellHeight, RGB(0, 150, 30));
            }
            
            if (m_nHalfHour[i][j] & (0x1 << MOTION_TYPE)){
                dc.FillSolidRect(30+j*nCellWidth, nHeight+(i+1)*nCellHeight, nCellWidth, nCellHeight, RGB(180, 150, 0));
            }

            if (m_nHalfHour[i][j] & (0x1 << ALARM_TYPE)){
                dc.FillSolidRect(30+j*nCellWidth, nHeight+(i+2)*nCellHeight, nCellWidth, nCellHeight, RGB(200, 0, 0));
            }
        }
        nHeight += nCellHeight*(m_nRecordCount-1);
    }
}

void CRecScheduleCtrl::drawMoveRect(CDC& dc, const CRect& rect)
{
    CRect rectTemp;
    rectTemp.left = min(m_startPoint.x, m_endPoint.x);
    rectTemp.top = min(m_startPoint.y, m_endPoint.y);
    rectTemp.right = max(m_startPoint.x, m_endPoint.x);
    rectTemp.bottom = max(m_startPoint.y, m_endPoint.y);

    BLENDFUNCTION bf;   
    bf.BlendOp = AC_SRC_OVER;   
    bf.BlendFlags = 0;   
    bf.SourceConstantAlpha = 100;
    bf.AlphaFormat = 0;  

    CDC memDC;
    memDC.CreateCompatibleDC(&dc);
    CBitmap bmp;
    bmp.CreateCompatibleBitmap(&dc,rectTemp.Width(),rectTemp.Height());
    CBitmap *pOldBitmap = memDC.SelectObject(&bmp);
    memDC.FillSolidRect(0, 0, rectTemp.Width(), rectTemp.Height(), RGB(0, 0, 255));

    AlphaBlend(dc.GetSafeHdc(), rectTemp.left, rectTemp.top, rectTemp.Width(), rectTemp.Height(), 
        memDC.GetSafeHdc(), 0, 0, rectTemp.Width(), rectTemp.Height(),bf);

    memDC.SelectObject(pOldBitmap);
}

void CRecScheduleCtrl::updateScheduleData()
{
    CRect rect;
    GetClientRect(&rect);

    int nVLineNum = 12*m_nPartsInTwoHour;
    int nHLineNum = 7;
    int nCellWidth = (int)(1.0*(rect.Width()-30)/nVLineNum);
    int nCellHeight = (int)(1.0*(rect.Height()-30)/nHLineNum);

    int nStartCol = (min(m_startPoint.x, m_endPoint.x)-30)/nCellWidth;
    int nStartRow = (min(m_startPoint.y, m_endPoint.y)-30)/nCellHeight;
    int nEndCol = (max(m_startPoint.x, m_endPoint.x)-30)/nCellWidth+1;
    int nEndRow = (max(m_startPoint.y, m_endPoint.y)-30)/nCellHeight+1;

    if (nStartRow < 0)
        nStartRow = 0;

    if (nEndRow > 7)
        nEndRow = 7;

    if (nStartCol < 0)
        nStartCol = 0;

    if (nEndCol > 48)
        nEndCol = 48;

    BYTE nData = 0x1 << m_nCurrentType;
    for (int i = nStartRow; i < nEndRow; i++){
        for (int j = nStartCol; j < nEndCol; j++){
            if (m_nHalfHour[i][j] & nData){
                m_nHalfHour[i][j] &= ~nData;
            }else{
                m_nHalfHour[i][j] |= nData;
            }
        }
    }
}

void CRecScheduleCtrl::setScheduleData(BYTE* pData, int nSize)
{
    ASSERT(nSize == 8*48);
    memcpy(m_nHalfHour, pData, nSize);
    m_bSaved = FALSE;
    Invalidate();
}

void CRecScheduleCtrl::getScheduleData(BYTE* pData, int nSize)
{
    ASSERT(nSize == 8*48);
    memcpy(pData, m_nHalfHour, nSize);
}

void CRecScheduleCtrl::setPartsInTwoHour(int n)
{
    m_nPartsInTwoHour = 2;
    m_bSaved = FALSE;
    Invalidate();
}
