// RecordParam.cpp : ʵļ
//

#include "stdafx.h"
#include "RSLibDemo.h"
#include "RecordParam.h"


// CRecordParam Ի

IMPLEMENT_DYNAMIC(CRecordParam, CDialog)

CRecordParam::CRecordParam(CWnd* pParent /*=NULL*/)
	: CDialog(CRecordParam::IDD, pParent),
    m_pServerInfo(NULL),
    m_ChNum(0),
    m_nPreSel(-1)
{

}

CRecordParam::~CRecordParam()
{
}

void CRecordParam::DoDataExchange(CDataExchange* pDX)
{
    CDialog::DoDataExchange(pDX);
    DDX_Control(pDX, IDC_COMBO_CH, m_comboCh);
    DDX_Control(pDX, IDC_COMBO_RECORD, m_comboRec);
    DDX_Control(pDX, IDC_COMBO_PRERECORD, m_comboPreRec);
}

BEGIN_MESSAGE_MAP(CRecordParam, CDialog)
    ON_BN_CLICKED(ID_BTN_QUERY, &CRecordParam::OnBnClickedBtnQuery)
    ON_BN_CLICKED(ID_BTN_SET, &CRecordParam::OnBnClickedBtnSet)
    ON_CBN_SELCHANGE(IDC_COMBO_CH, &CRecordParam::OnCbnSelchangeComboCh)
END_MESSAGE_MAP()

BOOL CRecordParam::OnInitDialog()
{
    CDialog::OnInitDialog();
    
    CString strCh;
    m_ChNum = m_pServerInfo->DevLoginRsp.ChannelNum;
    for(int i=0;i<m_ChNum;i++){
        strCh.Format("%s%d","CH",i+1);
        m_comboCh.InsertString(i,strCh);
    }
    m_comboCh.SetCurSel(0);

    m_comboRec.AddString("Disable");
    m_comboRec.AddString("Enable");
    m_comboRec.SetCurSel(0);

    m_comboPreRec.AddString("Disable");
    m_comboPreRec.AddString("Enable");
    m_comboPreRec.SetCurSel(0);

    return TRUE;
}

static void RSNET_CALL ListParamCallback(void* listParam, void* userParam)
{
    CRecordParam* pThis = (CRecordParam*)userParam;
    RSNet_SoleRecordSet_t* SoleRecordSet = (RSNet_SoleRecordSet_t*)listParam;
    pThis->listParam.Add(*SoleRecordSet);
}

static void RSNET_CALL ParamCallback(void* param, void* userParam)
{
    CRecordParam* pThis = (CRecordParam*)userParam;
    RSNet_RecordSet_t* pInfo = (RSNet_RecordSet_t*)param;
    pThis->m_RecordSet = *pInfo;
    pThis->m_comboPreRec.SetCurSel(pInfo->PreRecordTime);
}

void CRecordParam::OnBnClickedBtnQuery()
{
    RSNetQueryParamParam param;
    ZeroMemory(&param, sizeof(param));
    listParam.RemoveAll();
    memset(&m_RecordSet,0,sizeof(RSNet_RecordSet_t));
    m_RecordSet.StructSize = sizeof(RSNet_RecordSet_t);

    ChannelParamReq req;
    req.StructSize = sizeof(req);
    req.ChannelMask[0] = UINT_MAX;

    param.ParamType = MsgParamRecord;
    param.Req = &req;
    param.ParamSize = sizeof(RSNet_RecordSet_t);
    param.ParamCallback = ParamCallback;
    param.ListParamSize = sizeof(RSNet_SoleRecordSet_t);
    param.ListParamCallback = ListParamCallback;

    param.UserParam = this;

    if (RSNetQueryParam(m_pServerInfo->pNetConnection, &param)){
        if (m_nPreSel == -1) {
            m_nPreSel = 0;
            m_comboCh.SetCurSel(0);
        }
        OnCbnSelchangeComboCh();
        AfxMessageBox("Query record params succeed!");
        return;
    }else{
        AfxMessageBox("Query record params failed!");
    }
}

void CRecordParam::OnBnClickedBtnSet()
{
    UpdateData(TRUE);
    int nChannel = m_comboCh.GetCurSel();
    listParam[nChannel].ChnCloseOrOpen = m_comboRec.GetCurSel();
    m_RecordSet.PreRecordTime = m_comboPreRec.GetCurSel();
    UpdateData(FALSE);

    RSNetSetParamParam param;
    ZeroMemory(&param, sizeof(param));
    param.ParamType = MsgParamRecord;
    param.Param = &m_RecordSet;
    param.ListParams = listParam.GetData();
    param.ListParamNum = listParam.GetCount();
    if (RSNetSetParam(m_pServerInfo->pNetConnection, &param)) {
        AfxMessageBox("Set record params succeed!");
    }else{
        AfxMessageBox("Set record params failed!");
    }
}

void CRecordParam::OnCbnSelchangeComboCh()
{
    UpdateData(TRUE);
    int nChannel = m_comboCh.GetCurSel();
    int nCount = listParam.GetCount();
    if (nCount){
        if (m_nPreSel != nChannel){
            listParam[m_nPreSel].ChnCloseOrOpen = m_comboRec.GetCurSel();
        }

        TRACE("Record:%d\n", listParam[nChannel].ChnCloseOrOpen);
        m_comboRec.SetCurSel(listParam[nChannel].ChnCloseOrOpen);
    }
    m_nPreSel = nChannel;
    UpdateData(FALSE);
}
