

#include "stdafx.h"
#include "RSLibDemo.h"
#include "SearchDevDlg.h"
#include "DevInfo.h"

BOOL  RSNET_CALL RSSearchDevCallback(const SearchDevRsp* dev, void* param);

IMPLEMENT_DYNAMIC(CSearchDevDlg, CDialog)

CSearchDevDlg::CSearchDevDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSearchDevDlg::IDD, pParent)
	,m_iDevice_num(0),m_pInfo(NULL)
{
	
}

CSearchDevDlg::~CSearchDevDlg()
{
	if (m_pInfo)
	{
		delete m_pInfo;
		m_pInfo = NULL;
	}
}

void CSearchDevDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_DEV, m_listSearch);
	DDX_Control(pDX, IDC_IP_DEVIP, m_IP);
	DDX_Control(pDX, IDC_IP_GATEWAY, m_gateway);
	DDX_Control(pDX, IDC_IP_NETMASK, m_netmask);
}


BEGIN_MESSAGE_MAP(CSearchDevDlg, CDialog)
	ON_BN_CLICKED(IDC_BTN_SEARCH, &CSearchDevDlg::OnBnClickedBtnSearch)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_DEV, &CSearchDevDlg::OnNMDblclkListDev)
	ON_NOTIFY(NM_CLICK,IDC_LIST_DEV,&CSearchDevDlg::OnNMClkListDev)
	ON_BN_CLICKED(IDC_BTN_ADDDEV, &CSearchDevDlg::OnBnClickedBtnAdddev)
	ON_BN_CLICKED(IDC_BTN_MODIFY, &CSearchDevDlg::OnBnClickedBtnModify)
END_MESSAGE_MAP()


void CSearchDevDlg::OnBnClickedBtnSearch()
{
	m_listSearch.DeleteAllItems();

	//search devices
	RSNetSearchDevParam  SearchDevParam;
	SearchDevParam.Callback = RSSearchDevCallback;
	SearchDevParam.UserParam = this;
	RSNetSearchDev(&SearchDevParam);	

}

BOOL  RSNET_CALL RSSearchDevCallback(const SearchDevRsp* dev, void* param)
{
	CSearchDevDlg *pDlg = (CSearchDevDlg *)param;
	if (dev == NULL)
	{
		return FALSE;
	}
	char szID[12] ={0};
	CString strPort,strChNum,strWebPort,strMode;
	strPort.Format("%d",dev->Port);
	strWebPort.Format("%d",dev->IEPort);
	strChNum.Format("%d",dev->ChannelNum);
	sprintf_s(szID,"%d",pDlg->m_iDevice_num+1);
	if (dev->NetworkMode ==0)
	{
		strMode = "DHCP";
	}
	else if (dev->NetworkMode ==1)
	{
		strMode = "PPPOE";
	}
	else if (dev->NetworkMode ==2)
	{
		strMode = "MANUAL";
	}
	int count = pDlg->m_listSearch.GetItemCount();
	int Item = pDlg->m_listSearch.InsertItem(count,szID,1);
	pDlg->m_listSearch.SetItemText(Item,1,dev->IP);
	pDlg->m_listSearch.SetItemText(Item,2,strPort);
	pDlg->m_listSearch.SetItemText(Item,3,strChNum);
	pDlg->m_listSearch.SetItemText(Item,4,dev->DevType);
	pDlg->m_listSearch.SetItemText(Item,5,dev->DevVer);
	pDlg->m_listSearch.SetItemText(Item,6,dev->NetMask);
	pDlg->m_listSearch.SetItemText(Item,7,dev->GateWay);
	pDlg->m_listSearch.SetItemText(Item,8,dev->MacAddr);
	pDlg->m_listSearch.SetItemText(Item,9,dev->DNS1);
	pDlg->m_listSearch.SetItemText(Item,10,dev->DNS2);
	pDlg->m_listSearch.SetItemText(Item,11,strWebPort);
	pDlg->m_listSearch.SetItemText(Item,12,strMode);

	pDlg->m_iDevice_num++;

	return TRUE;
}

void CSearchDevDlg::InitDevTreeCtrl()
{
	
	(void)m_listSearch.SetExtendedStyle( LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES|LVS_EX_SUBITEMIMAGES );
	m_listSearch.InsertColumn(0,_T("Index"),LVCFMT_CENTER,50);
	m_listSearch.InsertColumn(1,_T("IP"),LVCFMT_CENTER,100);
	m_listSearch.InsertColumn(2,_T("Port"),LVCFMT_CENTER,80);
	m_listSearch.InsertColumn(3,_T("ChNum"),LVCFMT_CENTER,100);
	m_listSearch.InsertColumn(4,_T("DevType"),LVCFMT_CENTER,80);
	m_listSearch.InsertColumn(5,_T("SoftVer"),LVCFMT_CENTER,120);
	m_listSearch.InsertColumn(6,_T("NetMask"),LVCFMT_CENTER,100);
	m_listSearch.InsertColumn(7,_T("Gateway"),LVCFMT_CENTER,120);
	m_listSearch.InsertColumn(8,_T("MAC"),LVCFMT_CENTER,120);
	m_listSearch.InsertColumn(9,_T("DNS"),LVCFMT_CENTER,140);
	m_listSearch.InsertColumn(10,_T("SecondDNS"),LVCFMT_CENTER,140);
	m_listSearch.InsertColumn(11,_T("WebPort"),LVCFMT_CENTER,80);
	m_listSearch.InsertColumn(12,_T("NetMode"),LVCFMT_CENTER,120);
	m_listSearch.SetTextColor(RGB(20,20,255));
}
BOOL CSearchDevDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	InitDevTreeCtrl();
	m_pInfo = new NetMDevInfoReq;
	ZeroMemory(m_pInfo,sizeof(NetMDevInfoReq));

	HideCtrls(SW_HIDE);
	return TRUE;
}

void CSearchDevDlg::OnNMDblclkListDev(NMHDR *pNMHDR, LRESULT *pResult)
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	int m_iCurSelSearch = pNMListView->iItem ;
	HideCtrls(SW_HIDE);
	CDevInfoDlg devDlg;
	devDlg.m_strIP = m_listSearch.GetItemText(m_iCurSelSearch, 1);
	devDlg.m_strPort = m_listSearch.GetItemText(m_iCurSelSearch, 2);
	devDlg.m_strCh = m_listSearch.GetItemText(m_iCurSelSearch, 3);
	devDlg.m_strName = m_listSearch.GetItemText(m_iCurSelSearch, 1);
	devDlg.m_strUser = _T("admin");
	devDlg.m_strPsw = _T("000000");
	devDlg.m_strArea = _T("RootArea");
	devDlg.m_strAutoLogin = _T("0");
	devDlg.DoModal();

}


void CSearchDevDlg::OnNMClkListDev(NMHDR *pNMHDR, LRESULT *pResult)
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	int m_iCurSelSearch = pNMListView->iItem;
	CString strIP = m_listSearch.GetItemText(m_iCurSelSearch, 1);
    SetIP(m_pInfo->cip,strIP);
   
	strIP = m_listSearch.GetItemText(m_iCurSelSearch, 6);
	SetIP(m_pInfo->mask,strIP);

	strIP = m_listSearch.GetItemText(m_iCurSelSearch, 7);
	SetIP(m_pInfo->gw,strIP);

	strIP = m_listSearch.GetItemText(m_iCurSelSearch, 9);
	SetIP(m_pInfo->dns1,strIP);

	strIP = m_listSearch.GetItemText(m_iCurSelSearch, 10);
	SetIP(m_pInfo->dns2,strIP);

	strcpy((char *)m_pInfo->msgid,"RSIP_SET");
    
	int port = atoi(m_listSearch.GetItemText(m_iCurSelSearch, 2));
    m_pInfo->mport = port;

	port = atoi(m_listSearch.GetItemText(m_iCurSelSearch, 11));
	m_pInfo->wport = port;

	SetDlgItemInt(IDC_EDIT_MEDIA,m_pInfo->mport);
	SetDlgItemInt(IDC_EDIT_Web,m_pInfo->wport);
	GetDlgItem(IDC_EDIT_PWD)->SetWindowText("519070");
	GetDlgItem(IDC_EDIT_USER)->SetWindowText("admin");
	m_IP.SetAddress(m_pInfo->cip[0],m_pInfo->cip[1],m_pInfo->cip[2],m_pInfo->cip[3]);
	m_gateway.SetAddress(m_pInfo->gw[0],m_pInfo->gw[1],m_pInfo->gw[2],m_pInfo->gw[3]);
	m_netmask.SetAddress(m_pInfo->mask[0],m_pInfo->mask[1],m_pInfo->mask[2],m_pInfo->mask[3]);
    

	HideCtrls(SW_SHOW);

}

void CSearchDevDlg::OnBnClickedBtnAdddev()
{
	HideCtrls(SW_HIDE);
	CDevInfoDlg devDlg;
	devDlg.DoModal();

}

void CSearchDevDlg::OnBnClickedBtnModify()
{
	UpdateData();
	if (m_pInfo == NULL)
	{
		AfxMessageBox("Please select Dev int the list");
		return ;
	}
	m_pInfo->mport = GetDlgItemInt(IDC_EDIT_MEDIA);
	m_pInfo->wport = GetDlgItemInt(IDC_EDIT_Web);
    CString strUser ;
	GetDlgItem(IDC_EDIT_USER)->GetWindowText(strUser);
	memcpy(m_pInfo->user,strUser.GetBuffer(0),strUser.GetLength()+1);

	GetDlgItem(IDC_EDIT_PWD)->GetWindowText(strUser);
	memcpy(m_pInfo->pwd,strUser.GetBuffer(0),strUser.GetLength()+1);

	m_IP.GetAddress(m_pInfo->ip[0],m_pInfo->ip[1],m_pInfo->ip[2],m_pInfo->ip[3]);
	m_gateway.GetAddress(m_pInfo->gw[0],m_pInfo->gw[1],m_pInfo->gw[2],m_pInfo->gw[3]);
	m_netmask.GetAddress(m_pInfo->mask[0],m_pInfo->mask[1],m_pInfo->mask[2],m_pInfo->mask[3]);

	if (RSNetSetDevInfo(m_pInfo))
	{
		AfxMessageBox("SET IP SUCC \n");
	}
	else
	{
		AfxMessageBox("SET IP failed \n");
	}
}


void CSearchDevDlg::SetDevInfo(void *param)
{
	//SearchDevRsp *pInfo = (SearchDevRsp *)param;
	//if(pInfo != NULL)
	//{
	//	if (m_pSearchInfo == NULL)
	//	{
	//		m_pSearchInfo = new SearchDevRsp;
	//	}
	//	ZeroMemory(m_pSearchInfo,sizeof(SearchDevRsp));
	//	memcpy(m_pSearchInfo,pInfo,sizeof(SearchDevRsp));
	//}
}

void CSearchDevDlg::SetIP(BYTE dest[],CString &strIP)
{
	for (int i=0, j=0; i<3; i++)
	{
		j = strIP.Find('.', 0); 
		dest[i] = atoi(strIP.Left(j).GetBuffer(0));
		strIP = strIP.Right(strIP.GetLength() - (j+1));
	}
	dest[3] = atoi(strIP);
}

void  CSearchDevDlg::HideCtrls(BOOL bShow)
{
    GetDlgItem(IDC_STA_MODIFY)->ShowWindow(bShow);
	GetDlgItem(IDC_STA_IP)->ShowWindow(bShow);
	GetDlgItem(IDC_STA_GATE)->ShowWindow(bShow);
	GetDlgItem(IDC_STA_NETMASK)->ShowWindow(bShow);
	GetDlgItem(IDC_STA_MEDIA)->ShowWindow(bShow);
	GetDlgItem(IDC_STA_WEB)->ShowWindow(bShow);
	GetDlgItem(IDC_STA_USER)->ShowWindow(bShow);
	GetDlgItem(IDC_STA_PWD)->ShowWindow(bShow);

	GetDlgItem(IDC_IP_DEVIP)->ShowWindow(bShow);
	GetDlgItem(IDC_IP_GATEWAY)->ShowWindow(bShow);
	GetDlgItem(IDC_IP_NETMASK)->ShowWindow(bShow);
	GetDlgItem(IDC_EDIT_MEDIA)->ShowWindow(bShow);
	GetDlgItem(IDC_EDIT_Web)->ShowWindow(bShow);
	GetDlgItem(IDC_EDIT_PWD)->ShowWindow(bShow);
	GetDlgItem(IDC_EDIT_USER)->ShowWindow(bShow);
}

