// SimpleCmd.cpp : ʵļ
//

#include "stdafx.h"
#include "RSLibDemo.h"
#include "SimpleCmd.h"
#include "RSLibDemoDlg.h"

// CSimpleCmd Ի

IMPLEMENT_DYNAMIC(CSimpleCmd, CDialog)

CSimpleCmd::CSimpleCmd(CWnd* pParent /*=NULL*/)
	: CDialog(CSimpleCmd::IDD, pParent)
{
	m_pServerInfo = NULL;
    m_hCmd = NULL;
    m_bClose = FALSE;
}

CSimpleCmd::~CSimpleCmd()
{
}

void CSimpleCmd::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_LIST_INFO, m_listInfo);
}


BEGIN_MESSAGE_MAP(CSimpleCmd, CDialog)
	ON_BN_CLICKED(IDOK, &CSimpleCmd::OnBnClickedOk)
	ON_BN_CLICKED(IDC_BUTTON_CLEAR, &CSimpleCmd::OnBnClickedButtonClear)
    ON_WM_CLOSE()
END_MESSAGE_MAP()


// CSimpleCmd Ϣ

BOOL CSimpleCmd::OnInitDialog()
{
	CDialog::OnInitDialog();
    m_bClose = FALSE;
	// TODO:  ڴӶĳʼ
	(void)m_listInfo.SetExtendedStyle( LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES|LVS_EX_SUBITEMIMAGES );
	m_listInfo.InsertColumn(0,_T("No"),LVCFMT_CENTER,50);
	m_listInfo.InsertColumn(1,_T("¼ʹ"),LVCFMT_CENTER,200);
	m_listInfo.InsertColumn(2,_T("¼״̬"),LVCFMT_CENTER,200);
	m_listInfo.InsertColumn(3,_T("ƶʹ"),LVCFMT_CENTER,200);
	m_listInfo.InsertColumn(4,_T("ƶ״̬"),LVCFMT_CENTER,200);
	m_listInfo.InsertColumn(5,_T("IO澯ʹ"),LVCFMT_CENTER,200);
	m_listInfo.InsertColumn(6,_T("IO澯״̬"),LVCFMT_CENTER,200);
	m_listInfo.InsertColumn(7,_T("Ƶʧ״̬"),LVCFMT_CENTER,200);
	m_listInfo.SetTextColor(RGB(20,20,255));
	return TRUE;  // return TRUE unless you set the focus to a control
	// 쳣: OCX ҳӦ FALSE
}

void TestCmdThread(void* parameter);
void TestCmdThread(void* parameter)
{
    CSimpleCmd* pRSCmdDlg= (CSimpleCmd *)parameter;
    SERVER_INFO *pServerInfo = pRSCmdDlg->m_pServerInfo;
    RSNetCmdParam param = {0};
    param.ParamMainType = MsgStatusRequest;
    //ZeroMemory(&pServerInfo->sDevStatus,sizeof(DevAllStatusRpt));
    pServerInfo->chIndex = 0;
    if ((pServerInfo->DevLoginRsp.DevType >> 40 & 0xf) != 3) //DVR
    {
        param.ParamSubType = MsgDevAllStatusReq;
    }
    else
    {
        param.ParamSubType = MsgRemoteCHStatusReq;
    }
    while (!pRSCmdDlg->m_bClose)
    {
        if (pServerInfo->bAlarmRptDesired)//澯
        {
            RSNetSimpleCmd(pServerInfo->pNetConnection,&param);
        }
        Sleep(2000);
    }  
}

void CSimpleCmd::OnBnClickedOk()
{
	// TODO: ڴӿؼ֪ͨ
	CRSLibDemoDlg* pRSLibDemoDlg= (CRSLibDemoDlg *)theApp.GetMainWnd();
	ASSERT(m_pServerInfo != NULL);
	ASSERT(pRSLibDemoDlg != NULL);
    if (m_hCmd == NULL)
    {
        m_hCmd = CreateThread(NULL,NULL,(LPTHREAD_START_ROUTINE)TestCmdThread, this,NULL,NULL);    
    }
}

void CSimpleCmd::AddListInfo(alarm_info_t *pAlarm)
{
// 	DateTime AlarmTime;
// 
// 	UINT RecordEnable;	//¼ʹܣλʾ, λΪͨ0
// 	UINT RecordStatus;	//¼״̬λʾ, λΪͨ0
// 
// 	UINT MotionEnable;	//ƶʹܣλʾ, λΪͨ0
// 	UINT MotionStatus;	//ƶ״̬λʾ, λΪͨ0
// 
// 	UINT IOEnable;		//IO澯ʹܣλʾ, λΪͨ0
// 	UINT IOStatus;		//IO澯״̬λʾ, λΪͨ0
// 
// 	UINT VLossStatus;	//Ƶʧ״̬λʾ, λΪͨ0
// 
// 	BYTE HddStatus[8];	//¼״̬ȡRS_HDDSTATUS_Eֵ
// 	BYTE HddSN[8][32];	//̳к
// 	BYTE reserve[8];
	DevAllStatusRpt *pDevStatRpt = (DevAllStatusRpt *)pAlarm->data;
	ASSERT(pDevStatRpt != NULL);
	int count = m_listInfo.GetItemCount();
	CString strValue;
	strValue.Format("%d", count);
	m_listInfo.InsertItem(count, strValue);

	strValue = UINTtoBinary(pDevStatRpt->RecordEnable);
	m_listInfo.SetItemText(count, 1, strValue);
	strValue = UINTtoBinary(pDevStatRpt->RecordStatus);
	m_listInfo.SetItemText(count, 2, strValue);

	strValue = UINTtoBinary(pDevStatRpt->MotionEnable);
	m_listInfo.SetItemText(count, 3, strValue);
	strValue = UINTtoBinary(pDevStatRpt->MotionStatus);
	m_listInfo.SetItemText(count, 4, strValue);

	strValue = UINTtoBinary(pDevStatRpt->IOEnable);
	m_listInfo.SetItemText(count, 5, strValue);
	strValue = UINTtoBinary(pDevStatRpt->IOStatus);
	m_listInfo.SetItemText(count, 6, strValue);

	strValue = UINTtoBinary(pDevStatRpt->VLossStatus);
	m_listInfo.SetItemText(count, 7, strValue);
}

CString CSimpleCmd::UINTtoBinary(UINT nNumber)
{
	BOOL bFirst = FALSE;
	int nChNum = m_pServerInfo->DevLoginRsp.ChannelNum - 1;
	CString strValue;
	if (nNumber == 0)
	{
		strValue = '0';
		return strValue;
	}
	for (int i = nChNum; i >= 0; i--)
	{
// 		pChar = (char)(((nNumber >> i) & 1) + '0');
// 		if (pChar == '1')
// 		{
// 			bFirst = TRUE;
// 		}
// 		if (bFirst)
// 		{
// 			strValue += pChar;
// 		}
		strValue += (char)(((nNumber >> i) & 1) + '0');
		if (i%4 == 0 && i != 0)
		{
			strValue += ',';
		}
	}
	return strValue;
}

void CSimpleCmd::OnBnClickedButtonClear()
{
	// TODO: ڴӿؼ֪ͨ
	m_listInfo.DeleteAllItems();
}

void CSimpleCmd::OnClose()
{
    // TODO: ڴϢ/Ĭֵ
    m_bClose = TRUE;
    if(m_hCmd != NULL)
    {
        Sleep(200);
        CloseHandle(m_hCmd);
        m_hCmd = NULL;
    }
    CDialog::OnClose();
}
