// CheckListCtrl.cpp : implementation file
//

#include "stdafx.h"
#include "resource.h"
#include "CheckListCtrl.h"
#include "DrawGradiant.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCheckListCtrl

CCheckListCtrl::CCheckListCtrl() : m_blInited(FALSE),m_iNumColumns(0)
{
	GridMode = false;
	AltRowMode = false;
	MaskMode = false;
}

CCheckListCtrl::~CCheckListCtrl()
{
}


BEGIN_MESSAGE_MAP(CCheckListCtrl, CListCtrl)
	//{{AFX_MSG_MAP(CCheckListCtrl)
	ON_NOTIFY_REFLECT(LVN_ITEMCHANGED, OnItemChanged)	
	ON_NOTIFY_REFLECT(LVN_DELETEITEM, OnDeleteitem)
	ON_NOTIFY_REFLECT(LVN_DELETEALLITEMS, OnDeleteallitems)
	ON_NOTIFY_REFLECT(NM_CUSTOMDRAW, CustDraw)
	ON_NOTIFY_REFLECT(LVN_INSERTITEM, OnInsertitem)	
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCheckListCtrl message handlers
void CCheckListCtrl::OnItemChanged(NMHDR* pNMHDR, LRESULT* pResult)
{
	NMLISTVIEW* pNMLV = (NMLISTVIEW*)pNMHDR;
	*pResult = 0;

	if ( m_blInited && LVIF_STATE == pNMLV->uChanged)
	{
		BOOL blAllChecked = TRUE;
		int nCount = GetItemCount();
		for(int nItem = 0; nItem < nCount; nItem++)
		{
			if ( !ListView_GetCheckState(GetSafeHwnd(), nItem) )
			{
				blAllChecked = FALSE;
				break;
			}
		}
		
		HDITEM hdItem;
		hdItem.mask = HDI_IMAGE;
		if (blAllChecked)
			hdItem.iImage = 2;
		else
			hdItem.iImage = 1;
		VERIFY( m_checkHeadCtrl.SetItem(0, &hdItem) );
		::PostMessage(GetParent()->GetSafeHwnd(),WM_CHECK_ALL+WM_USER,GetDlgCtrlID(), blAllChecked);
	}
}

BOOL CCheckListCtrl::Init()
{
	if (m_blInited)
		return TRUE;

	CHeaderCtrl* pHeadCtrl = this->GetHeaderCtrl();
	ASSERT(pHeadCtrl->GetSafeHwnd());

	VERIFY( m_checkHeadCtrl.SubclassWindow(pHeadCtrl->GetSafeHwnd()) );
	VERIFY( m_checkImgList.Create(IDB_CHECKBOXES, 16, 3, RGB(255,0,255)) );
	int i = m_checkImgList.GetImageCount();
	m_checkHeadCtrl.SetImageList(&m_checkImgList);
	
	HDITEM hdItem;
	hdItem.mask = HDI_IMAGE | HDI_FORMAT;
	VERIFY( m_checkHeadCtrl.GetItem(0, &hdItem) );
	hdItem.iImage = 1;
	hdItem.fmt |= HDF_IMAGE;	
	VERIFY( m_checkHeadCtrl.SetItem(0, &hdItem) );

	m_blInited = TRUE;

	return TRUE;
}

void CCheckListCtrl::CustDraw(NMHDR *pNotifyStruct, LRESULT *result)
{
	LPNMLVCUSTOMDRAW lplvcd = (LPNMLVCUSTOMDRAW) pNotifyStruct; // cast our generic structure to bigger/specialized strc
	int i = 0;
	long iRow = 0;
	long iCol = 0;
	long iCIndex = 0;
	long iCelIndex = 0;
	long iRIndex = 0;
	switch(lplvcd->nmcd.dwDrawStage)
	{
	case CDDS_PREPAINT:
		*result  = CDRF_NOTIFYITEMDRAW|CDRF_NOTIFYSUBITEMDRAW;	// request notifications for individual items
		break;

	case CDDS_ITEMPREPAINT:
		*result = CDRF_NOTIFYSUBITEMDRAW;
		break;

	case CDDS_ITEMPREPAINT|CDDS_SUBITEM:	// drawing subitem
		iRow = lplvcd->nmcd.dwItemSpec;	
		iCol = lplvcd->iSubItem;

		if(GridMode)		// grid mode
		{
			if( iRow %2 == 1)
			{
				if( iCol %2 == 0)
					lplvcd->clrTextBk = Gx;
				else
					lplvcd->clrTextBk = Gy;
			}
			else
			{
				if( iCol %2 == 0)
					lplvcd->clrTextBk = Gy;
				else
					lplvcd->clrTextBk = Gx;
			}
		}

		if(AltRowMode)	//alternate row mode
		{
			if( iRow %2 == 1)
				lplvcd->clrTextBk = Rx;
			else
				lplvcd->clrTextBk = Ry;
		}

		iRIndex = findDetails(iRow,ROW);	// individual cell,coloumn,row color setting
		iCIndex = findDetails(iCol,COL);
		iCelIndex = findDetails(iRow,CELL,iCol);
		
		if(iRIndex == -1 && iCIndex == -1 && iCelIndex == -1 )
		{
			if(!GridMode && !AltRowMode)
				lplvcd->clrTextBk = GetBkColor();
		}
		else
		{
			if( iCelIndex != -1)
				lplvcd->clrTextBk = CellColors[iCelIndex].cf;
			else
			{
				if(iRIndex != -1)
					lplvcd->clrTextBk = RowColors[iRIndex].cf;
				else
					lplvcd->clrTextBk = ColColors[iCIndex].cf;
			}
			
		}

		if(MaskMode)		// text mask mode
			lplvcd->clrText = InvertColor(lplvcd->clrTextBk);
		*result = CDRF_NEWFONT;
		break;
	default:
		*result = CDRF_DODEFAULT;
	}

}

void CCheckListCtrl::SetRowColor(COLORREF cf,long row)
{
	ColorStruct cs;
	cs.cf = cf;
	cs.id = row;
	RowColors.push_back(cs);
	RedrawWindow(NULL,NULL,RDW_FRAME | RDW_INVALIDATE | RDW_ERASE | RDW_UPDATENOW);
}

void CCheckListCtrl::SetColColor(COLORREF cf,long col)
{
	ColorStruct cs;
	cs.cf = cf;
	cs.id = col;
	ColColors.push_back(cs);
	RedrawWindow(NULL,NULL,RDW_FRAME | RDW_INVALIDATE | RDW_ERASE | RDW_UPDATENOW);
}

void CCheckListCtrl::SetCellColor(COLORREF cf,long row,long col)
{
	ColorStruct cs;
	cs.cf = cf;
	cs.id = row;
	cs.subId = col;
	CellColors.push_back(cs);
	RedrawWindow(NULL,NULL,RDW_FRAME | RDW_INVALIDATE | RDW_ERASE | RDW_UPDATENOW);
}

long CCheckListCtrl::findDetails(long id,RecType rt,long subId)
{
	if( rt == ROW)
	{
		for(UINT i=0;i< RowColors.size(); i++)
		{
			if(RowColors[i].id == id)
				return i;
		}
	}

	if( rt == COL)
	{
		for(UINT i=0;i< ColColors.size(); i++)
		{
			if(ColColors[i].id == id)
				return i;
		}
	}

	if( rt == CELL)
	{
		for(UINT i=0;i< CellColors.size(); i++)
		{
			if( subId >=0){
				if(CellColors[i].id == id && CellColors[i].subId == subId)
					return i;
			}
		}
	}
	return -1;
}

void CCheckListCtrl::OnDeleteitem(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	
	// TODO: Add your control notification handler code here
	long row  = pNMListView->iItem;
	long index = findDetails(row);
	
	for(UINT i=0;i< RowColors.size();i++)
	{
		if(RowColors[i].id == row){
			RowColors.erase(RowColors.begin()+i);
			i--;
			continue;
		}
		if(RowColors[i].id > row){
			RowColors[i].id--;
		}
	}
	for(UINT i=0;i< CellColors.size();i++)
	{
		if(CellColors[i].id == row){
			CellColors.erase(CellColors.begin()+i);
			i--;
			continue;
		}
		if(CellColors[i].id > row){
			CellColors[i].id--;
		}
	}
	*pResult = 0;
}

void CCheckListCtrl::OnDeleteallitems(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	RowColors.clear();
	ColColors.clear();
	CellColors.clear();
	*pResult = 0;
}

void CCheckListCtrl::OnInsertitem(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// TODO: Add your control notification handler code here
	long row  = pNMListView->iItem;
	long col  = pNMListView->iSubItem;
		
	for(UINT i=0;i< RowColors.size();i++)
	{
		if(RowColors[i].id > row){
			RowColors[i].id++;
		}
	}

	for(UINT i=0;i< CellColors.size();i++)
	{
		if(CellColors[i].id > row)
		{
			CellColors[i].id++;
		}
	}

	*pResult = 0;
}

void CCheckListCtrl::SetGridMode(bool TurnOn,COLORREF x,COLORREF y)
{
	Gx = y;
	Gy = x;
	GridMode = TurnOn;
	RedrawWindow(NULL,NULL,RDW_FRAME | RDW_INVALIDATE | RDW_ERASE | RDW_UPDATENOW);
}

void CCheckListCtrl::SetAltRowColors(bool TurnOn,COLORREF x,COLORREF y)
{
	Rx = x;
	Ry = y;
	AltRowMode = TurnOn;
	RedrawWindow(NULL,NULL,RDW_FRAME | RDW_INVALIDATE | RDW_ERASE | RDW_UPDATENOW);
}

void CCheckListCtrl::SetTextMask(bool TurnOn)
{
	MaskMode = TurnOn;
	RedrawWindow(NULL,NULL,RDW_FRAME | RDW_INVALIDATE | RDW_ERASE | RDW_UPDATENOW);
}

void CCheckListCtrl::ClrRowColor(long row)
{
	long index = findDetails(row);
	if(index != -1)
		RowColors.erase(RowColors.begin()+index);
	RedrawWindow(NULL,NULL,RDW_FRAME | RDW_INVALIDATE | RDW_ERASE | RDW_UPDATENOW);
}

void CCheckListCtrl::ClrColColor(long col)
{
	long index = findDetails(col,COL);
	if(index != -1)
		ColColors.erase(ColColors.begin()+index);
	RedrawWindow(NULL,NULL,RDW_FRAME | RDW_INVALIDATE | RDW_ERASE | RDW_UPDATENOW);
}

void CCheckListCtrl::ClrCellColor(long row,long col)
{
	long index = findDetails(row,CELL,col);
	if(index != -1)
		CellColors.erase(CellColors.begin()+index);
	RedrawWindow(NULL,NULL,RDW_FRAME | RDW_INVALIDATE | RDW_ERASE | RDW_UPDATENOW);
}

COLORREF CCheckListCtrl::InvertColor(COLORREF cf)
{
	return RGB(abs(220-GetRValue(cf)),abs(220-GetGValue(cf)),abs(220-GetBValue(cf)));
}

void CCheckListCtrl::ResetColors(void)
{
	RowColors.clear();
	ColColors.clear();
	CellColors.clear();
	GridMode = false;
	AltRowMode = false;
	MaskMode = false;
	RedrawWindow(NULL,NULL,RDW_FRAME | RDW_INVALIDATE | RDW_ERASE | RDW_UPDATENOW);
}

BOOL CCheckListCtrl::SetHeadings( const CString& strHeadings )
{
	int iStart = 0;

	for( ;; )
	{
		const int iComma = strHeadings.Find( _T(','), iStart );

		if( iComma == -1 )
			break;

		const CString strHeading = strHeadings.Mid( iStart, iComma - iStart );

		iStart = iComma + 1;

		int iSemiColon = strHeadings.Find( _T(';'), iStart );

		if( iSemiColon == -1 )
			iSemiColon = strHeadings.GetLength();

		const int iWidth = atoi( strHeadings.Mid( iStart, iSemiColon - iStart ) );

		iStart = iSemiColon + 1;

		if( InsertColumn( m_iNumColumns++, strHeading, LVCFMT_LEFT, iWidth ) == -1 )
			return FALSE;

	}

	return TRUE;
}