// VCSampleDlg.cpp : implementation file
//

#include "stdafx.h"
#include "VCSample.h"
#include "VCSampleDlg.h"
#include "Shlwapi.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCSampleDlg dialog

CVCSampleDlg::CVCSampleDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CVCSampleDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CVCSampleDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CVCSampleDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CVCSampleDlg)
	DDX_Control(pDX, IDC_EDIT26, m_EncryptEdit);
	DDX_Control(pDX, IDC_EDIT25, m_FullTimeText_H);
	DDX_Control(pDX, IDC_EDIT24, m_FullTimeText_Y);
	DDX_Control(pDX, IDC_EDIT23, m_FullTimeText_X);
	DDX_Control(pDX, IDC_EDIT22, m_TitleText_H);
	DDX_Control(pDX, IDC_EDIT21, m_TitleText_Y);
	DDX_Control(pDX, IDC_EDIT20, m_TitleText_X);
	DDX_Control(pDX, IDC_EDIT19, m_TimeText_H);
	DDX_Control(pDX, IDC_EDIT18, m_TimeText_Y);
	DDX_Control(pDX, IDC_EDIT17, m_TimeText_X);
	DDX_Control(pDX, IDC_EDIT16, m_OSD_B);
	DDX_Control(pDX, IDC_EDIT15, m_OSD_G);
	DDX_Control(pDX, IDC_EDIT14, m_OSD_R);
	DDX_Control(pDX, IDC_EDIT13, m_OSD_Height);
	DDX_Control(pDX, IDC_EDIT12, m_OSD_Y);
	DDX_Control(pDX, IDC_EDIT11, m_OSD_X);
	DDX_Control(pDX, IDC_EDIT10, m_OSD_String);
	DDX_Control(pDX, IDC_EDIT9, m_EditReturn);
	DDX_Control(pDX, IDC_EDIT8, m_EditCGI);
	DDX_Control(pDX, IDC_EDIT7, m_EditACh);
	DDX_Control(pDX, IDC_EDIT6, m_EditVCh);
	DDX_Control(pDX, IDC_EDIT5, m_EditType);
	DDX_Control(pDX, IDC_EDIT4, m_EditPass);
	DDX_Control(pDX, IDC_EDIT3, m_EditUser);
	DDX_Control(pDX, IDC_EDIT2, m_EditPort);
	DDX_Control(pDX, IDC_EDIT1, m_EditIP);
	DDX_Control(pDX, IDC_HIPCAMXCTRL1, m_IPCamX1);
	DDX_Control(pDX, IDC_HIPCAMXCTRL2, m_IPCamX2);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CVCSampleDlg, CDialog)
	//{{AFX_MSG_MAP(CVCSampleDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BUTTON1, OnConnect)
	ON_WM_DESTROY()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BUTTON2, OnPlayAudio)
	ON_BN_CLICKED(IDC_BUTTON3, OnStopAudio)
	ON_BN_CLICKED(IDC_BUTTON4, OnStopRecv)
	ON_BN_CLICKED(IDC_BUTTON5, OnContinueRecv)
	ON_BN_CLICKED(IDC_BUTTON6, OnFlip)
	ON_BN_CLICKED(IDC_BUTTON7, OnMirror)
	ON_BN_CLICKED(IDC_BUTTON8, On2WayON)
	ON_BN_CLICKED(IDC_BUTTON9, On2WayOFF)
	ON_BN_CLICKED(IDC_BUTTON10, OnExecuteCGI)
	ON_BN_CLICKED(IDC_BUTTON11, OnSetOSD)
	ON_BN_CLICKED(IDC_BUTTON12, OnSetPosition)
	ON_BN_CLICKED(IDC_BUTTON13, OnSetHeight)
	ON_BN_CLICKED(IDC_BUTTON14, OnSetColor)
	ON_BN_CLICKED(IDC_BUTTON15, OnShowOSD)
	ON_BN_CLICKED(IDC_BUTTON16, OnCloseOSD)
	ON_BN_CLICKED(IDC_BUTTON17, OnSetTimePos)
	ON_BN_CLICKED(IDC_BUTTON18, OnSetTitlePos)
	ON_BN_CLICKED(IDC_BUTTON19, OnFullTimePos)
	ON_BN_CLICKED(IDC_BUTTON20, OnButton20)
	ON_BN_CLICKED(IDC_BUTTON21, OnButton21)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CVCSampleDlg message handlers

BOOL CVCSampleDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	// TODO: Add extra initialization here
	m_IPCamX1.InitCamera();
	m_IPCamX2.InitCamera();

	m_EditIP.SetWindowText(m_IPCamX1.GetIPAddress());
	int iPort = m_IPCamX1.GetPort();
	char cBuf[10];
	itoa(iPort,cBuf,10);
	m_EditPort.SetWindowText(cBuf);
	m_EditUser.SetWindowText(m_IPCamX1.GetAccount());
	m_EditPass.SetWindowText(m_IPCamX1.GetPassword());

	m_EditType.SetWindowText("0");
	m_EditVCh.SetWindowText("0");
	m_EditACh.SetWindowText("0");
	m_EditCGI.SetWindowText("GetName.cgi");

	int iTmp;
	CString sTmp;
	m_OSD_String.SetWindowText(m_IPCamX1.GetOSDString());
	iTmp=m_IPCamX1.GetOSDPosX();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_OSD_X.SetWindowText(sTmp);
	iTmp=m_IPCamX1.GetOSDPosY();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_OSD_Y.SetWindowText(sTmp);
	iTmp=m_IPCamX1.GetOSDHeight();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_OSD_Height.SetWindowText(sTmp);
	iTmp=m_IPCamX1.GetOSDColorR();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_OSD_R.SetWindowText(sTmp);
	iTmp=m_IPCamX1.GetOSDColorG();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_OSD_G.SetWindowText(sTmp);
	iTmp=m_IPCamX1.GetOSDColorB();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_OSD_B.SetWindowText(sTmp);

	iTmp=m_IPCamX2.GetTimeTextX();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_TimeText_X.SetWindowText(sTmp);
	iTmp=m_IPCamX2.GetTimeTextY();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_TimeText_Y.SetWindowText(sTmp);
	iTmp=m_IPCamX2.GetTimeTextFontHeight();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_TimeText_H.SetWindowText(sTmp);
	iTmp=m_IPCamX2.GetTitleTextX();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_TitleText_X.SetWindowText(sTmp);
	iTmp=m_IPCamX2.GetTitleTextY();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_TitleText_Y.SetWindowText(sTmp);
	iTmp=m_IPCamX2.GetTitleTextFontHeight();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_TitleText_H.SetWindowText(sTmp);
	iTmp=m_IPCamX2.GetFullTimeTextX();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_FullTimeText_X.SetWindowText(sTmp);
	iTmp=m_IPCamX2.GetFullTimeTextY();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_FullTimeText_Y.SetWindowText(sTmp);
	iTmp=m_IPCamX2.GetFullTimeTextFontHeight();
	itoa(iTmp,(char*)(LPCTSTR)sTmp,10);
	m_FullTimeText_H.SetWindowText(sTmp);
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CVCSampleDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CVCSampleDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CVCSampleDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CVCSampleDlg::OnConnect() 
{
	// TODO: Add your control notification handler code here
	CString str;
	m_EditIP.GetWindowText(str);
	m_IPCamX1.SetIPAddress(str);
	m_EditPort.GetWindowText(str);
	m_IPCamX1.SetPort(atoi(str));
	m_EditUser.GetWindowText(str);
	m_IPCamX1.SetAccount(str);
	m_EditPass.GetWindowText(str);
	m_IPCamX1.SetPassword(str);
	
	m_IPCamX1.ConnectCamera();
	m_IPCamX1.StartReceiveData();
	m_IPCamX1.StartPlay();
	m_IPCamX2.StartPlay();
}

BEGIN_EVENTSINK_MAP(CVCSampleDlg, CDialog)
    //{{AFX_EVENTSINK_MAP(CVCSampleDlg)
	ON_EVENT(CVCSampleDlg, IDC_HIPCAMXCTRL1, 8 /* OnFrameComingByBSTR */, OnOnFrameComingByBSTRHipcamxctrl1, VTS_I4 VTS_I4 VTS_PBSTR VTS_I4 VTS_I4 VTS_I4)
	ON_EVENT(CVCSampleDlg, IDC_HIPCAMXCTRL1, 7 /* OnGetTypeChannel */, OnOnGetTypeChannelHipcamxctrl1, VTS_I4 VTS_I4 VTS_I4)
	//}}AFX_EVENTSINK_MAP
END_EVENTSINK_MAP()

void CVCSampleDlg::OnOnFrameComingByBSTRHipcamxctrl1(long FrameType, long DataLength, BSTR FAR* DataBSTR, long HighDateTime, long LowDateTime, long SpareParts) 
{
	// TODO: Add your control notification handler code here
	m_IPCamX2.PushPlayBackFrameByBSTR(FrameType,DataLength,DataBSTR,HighDateTime,LowDateTime,SpareParts);
}

void CVCSampleDlg::OnDestroy() 
{
	CDialog::OnDestroy();
	
	// TODO: Add your message handler code here

}

void CVCSampleDlg::OnClose() 
{
	// TODO: Add your message handler code here and/or call default
	m_IPCamX2.DeinitCamera();
	m_IPCamX1.DeinitCamera();
	CDialog::OnClose();
}

void CVCSampleDlg::OnPlayAudio() 
{
	// TODO: Add your control notification handler code here
	m_IPCamX1.SetPlayAudio(1);	
}

void CVCSampleDlg::OnStopAudio() 
{
	// TODO: Add your control notification handler code here
	m_IPCamX1.SetPlayAudio(0);	
}

void CVCSampleDlg::OnStopRecv() 
{
	// TODO: Add your control notification handler code here
	m_IPCamX1.PauseReceiveData();	
}

void CVCSampleDlg::OnContinueRecv() 
{
	// TODO: Add your control notification handler code here
	m_IPCamX1.ContinueReceiveData();
}

void CVCSampleDlg::OnFlip() 
{
	// TODO: Add your control notification handler code here
	if(m_IPCamX1.GetVideoFlip() == 0)
		m_IPCamX1.SetVideoFlip(1);
	else
		m_IPCamX1.SetVideoFlip(0);
}

void CVCSampleDlg::OnMirror() 
{
	// TODO: Add your control notification handler code here
	if(m_IPCamX1.GetVideoMirror() == 0)
		m_IPCamX1.SetVideoMirror(1);
	else
		m_IPCamX1.SetVideoMirror(0);
}

void CVCSampleDlg::On2WayON() 
{
	// TODO: Add your control notification handler code here
	m_IPCamX1.Set2WayAudioON();
}

void CVCSampleDlg::On2WayOFF() 
{
	// TODO: Add your control notification handler code here
	m_IPCamX1.Set2WayAudioOFF();
}

void CVCSampleDlg::OnOnGetTypeChannelHipcamxctrl1(long DeviceType, long VChannels, long AChannels) 
{
	// TODO: Add your control notification handler code here
	CString str;
	itoa(DeviceType,(char*)(LPCTSTR)str,10);
	m_EditType.SetWindowText(str);
	itoa(VChannels,(char*)(LPCTSTR)str,10);
	m_EditVCh.SetWindowText(str);
	itoa(AChannels,(char*)(LPCTSTR)str,10);
	m_EditACh.SetWindowText(str);
}

void CVCSampleDlg::OnExecuteCGI() 
{
	// TODO: Add your control notification handler code here
	CString str;
	m_EditCGI.GetWindowText(str);
	//m_IPCamX1.ExecuteCGIByBSTR(str,str.GetLength());
	char cBuf[2000];
	long lRet;
	m_IPCamX1.ExecuteCGIByPointer(str,str.GetLength(),(long*)cBuf,&lRet);
	m_EditReturn.SetWindowText(cBuf);
}

void CVCSampleDlg::OnSetOSD() 
{
	// TODO: Add your control notification handler code here
	CString sOSD;
	m_OSD_String.GetWindowText(sOSD);
	m_IPCamX1.SetOSDString(sOSD);
}

void CVCSampleDlg::OnSetPosition() 
{
	// TODO: Add your control notification handler code here
	CString sX,sY;
	m_OSD_X.GetWindowText(sX);
	m_OSD_Y.GetWindowText(sY);
	m_IPCamX1.SetOSDPosX(StrToInt(sX));
	m_IPCamX1.SetOSDPosY(StrToInt(sY));
}

void CVCSampleDlg::OnSetHeight() 
{
	// TODO: Add your control notification handler code here
	CString sHeight;
	m_OSD_Height.GetWindowText(sHeight);
	m_IPCamX1.SetOSDHeight(StrToInt(sHeight));
}

void CVCSampleDlg::OnSetColor() 
{
	// TODO: Add your control notification handler code here
	CString sR,sG,sB;
	m_OSD_R.GetWindowText(sR);
	m_OSD_G.GetWindowText(sG);
	m_OSD_B.GetWindowText(sB);
	m_IPCamX1.SetOSDColorR(StrToInt(sR));
	m_IPCamX1.SetOSDColorG(StrToInt(sG));
	m_IPCamX1.SetOSDColorB(StrToInt(sB));
}

void CVCSampleDlg::OnShowOSD() 
{
	// TODO: Add your control notification handler code here
	m_IPCamX1.OSDShow();
}

void CVCSampleDlg::OnCloseOSD() 
{
	// TODO: Add your control notification handler code here
	m_IPCamX1.OSDClose();
}

void CVCSampleDlg::OnSetTimePos() 
{
	// TODO: Add your control notification handler code here
	CString str;
	m_TimeText_X.GetWindowText(str);
	m_IPCamX2.SetTimeTextX(atoi(str));
	m_TimeText_Y.GetWindowText(str);
	m_IPCamX2.SetTimeTextY(atoi(str));
	m_TimeText_H.GetWindowText(str);
	m_IPCamX2.SetTimeTextFontHeight(atoi(str));
}

void CVCSampleDlg::OnSetTitlePos() 
{
	// TODO: Add your control notification handler code here
	CString str;
	m_TitleText_X.GetWindowText(str);
	m_IPCamX2.SetTitleTextX(atoi(str));
	m_TitleText_Y.GetWindowText(str);
	m_IPCamX2.SetTitleTextY(atoi(str));
	m_TitleText_H.GetWindowText(str);
	m_IPCamX2.SetTitleTextFontHeight(atoi(str));
}

void CVCSampleDlg::OnFullTimePos() 
{
	// TODO: Add your control notification handler code here
	CString str;
	m_FullTimeText_X.GetWindowText(str);
	m_IPCamX2.SetFullTimeTextX(atoi(str));
	m_FullTimeText_Y.GetWindowText(str);
	m_IPCamX2.SetFullTimeTextY(atoi(str));
	m_FullTimeText_H.GetWindowText(str);
	m_IPCamX2.SetFullTimeTextFontHeight(atoi(str));
}

void CVCSampleDlg::OnButton20() 
{
	// TODO: Add your control notification handler code here
	CString str;
	m_EncryptEdit.GetWindowText(str);
	m_IPCamX1.EnableEncrypt(str);
}

void CVCSampleDlg::OnButton21() 
{
	// TODO: Add your control notification handler code here
	m_IPCamX1.DisableEncrypt();
}
