﻿using System;
using System.Collections.Generic;
using System.Text;

using System.Runtime.InteropServices;




namespace TestByCSharp
{
    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
    public struct BITMAPINFOHEADER
    {   
        /// DWORD->unsigned int
        public uint biSize;

        /// LONG->int
        public int biWidth;

        /// LONG->int
        public int biHeight;

        /// WORD->unsigned short
        public ushort biPlanes;

        /// WORD->unsigned short
        public ushort biBitCount;

        /// DWORD->unsigned int
        public uint biCompression;

        /// DWORD->unsigned int
        public uint biSizeImage;

        /// LONG->int
        public int biXPelsPerMeter;

        /// LONG->int
        public int biYPelsPerMeter;

        /// DWORD->unsigned int
        public uint biClrUsed;

        /// DWORD->unsigned int
        public uint biClrImportant;
    }


    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential, CharSet = System.Runtime.InteropServices.CharSet.Ansi)]
    public struct AVISTREAMINFO
    {

        /// DWORD->unsigned int
        public uint fccType;

        /// DWORD->unsigned int
        public uint fccHandler;

        /// DWORD->unsigned int
        public uint dwFlags;

        /// DWORD->unsigned int
        public uint dwCaps;

        /// WORD->unsigned short
        public ushort wPriority;

        /// WORD->unsigned short
        public ushort wLanguage;

        /// DWORD->unsigned int
        public uint dwScale;

        /// DWORD->unsigned int
        public uint dwRate;

        /// DWORD->unsigned int
        public uint dwStart;

        /// DWORD->unsigned int
        public uint dwLength;

        /// DWORD->unsigned int
        public uint dwInitialFrames;

        /// DWORD->unsigned int
        public uint dwSuggestedBufferSize;

        /// DWORD->unsigned int
        public uint dwQuality;

        /// DWORD->unsigned int
        public uint dwSampleSize;

        /// RECT->tagRECT
        public tagRECT rcFrame;

        /// DWORD->unsigned int
        public uint dwEditCount;

        /// DWORD->unsigned int
        public uint dwFormatChangeCount;

        /// char[64]
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValTStr, SizeConst = 64)]
        public string szName;
    }

    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
    public struct tagRECT
    {

        /// LONG->int
        public int left;

        /// LONG->int
        public int top;

        /// LONG->int
        public int right;

        /// LONG->int
        public int bottom;
    }


    class AVIFileSave
    {
        [DllImport("avifil32.dll")]
        private static extern void AVIFileInit();

        [DllImport("avifil32.dll")]
        private static extern int AVIFileOpen(ref int ptr_pfile, string fileName, int flags, int dummy);

        [DllImport("avifil32.dll")]
        private static extern int AVIFileCreateStream(
          int ptr_pfile, out IntPtr ptr_ptr_avi, ref AVISTREAMINFO ptr_streaminfo);
        

        //[DllImport("avifil32.dll")]
        [System.Runtime.InteropServices.DllImportAttribute("avifil32.dll", EntryPoint = "AVIStreamSetFormat", CallingConvention = System.Runtime.InteropServices.CallingConvention.StdCall)]
        public static extern int AVIStreamSetFormat(IntPtr aviStream,int lPos, System.IntPtr lpFormat, int cbFormat);
        
 
        [DllImport("avifil32.dll")]
        private static extern int AVIStreamWrite(
          IntPtr aviStream, Int32 lStart, Int32 lSamples, IntPtr  lpBuffer,
          Int32 cbBuffer, Int32 dwFlags, Int32 dummy1, Int32 dummy2);

        [DllImport("avifil32.dll")]
        private static extern int AVIStreamRelease(IntPtr aviStream);

        [DllImport("avifil32.dll")]
        private static extern int AVIFileRelease(int pfile);

        [DllImport("avifil32.dll")]
        private static extern void AVIFileExit();



        public byte[] m_AudioData = new byte[19200 * 4];
        private BITMAPINFOHEADER sBitmapInfo = new BITMAPINFOHEADER();
        AVISTREAMINFO VStreamInfo = new AVISTREAMINFO();
        AVISTREAMINFO AStreamInfo = new AVISTREAMINFO();
        uint  m_iType;
        int   m_Avifile;
        bool  m_err;

        IntPtr   m_pVStream;
        IntPtr   m_pAStream;
        //======================================================//
        const int AVIERR_OK = 0;   
        const int OF_READ=  0;
        const int OF_WRITE =  1;
        const int OF_READWRITE = 2;
        const int OF_CREATE = 0x00001000;
        const int WAVE_FORMAT_PCM = 1;
        const int AVIIF_KEYFRAME = 	0x00000010;
       
         static uint mmioFOURCC(char c0, char c1, char c2, char c3) 
         { 
                return (uint)c3 << 24 | (uint)c2 << 16 | (uint)c1 << 8 | (uint)c0; 
         } 


        public bool OpenAviFile(string filename, bool bFileCreate,
                                 bool bWithAudio,
                                 HVideo_Info VInfo,
                                 int iCh)
        {
            
            m_iType = VInfo.uVideoType;
            int lVideoWidth = Math.Abs(VInfo.iWidth);
            int lVideoHeight = Math.Abs(VInfo.iHeight);

            bool bSetFormat;
            int hr;
     

            AVIFileInit();

            if (bFileCreate)
            {
                hr = AVIFileOpen(ref m_Avifile, filename, 
                                  OF_WRITE | OF_CREATE, 0);

                if (hr != AVIERR_OK)
                {
                    m_err = true; AVIFileExit();                                        
                    return false;
                }             
                m_err = false;
                bSetFormat = true;
            }
            else
            {
                hr = AVIFileOpen(ref m_Avifile, filename, OF_READWRITE, 0);
                if (hr != AVIERR_OK)
                {
                    m_err = true; AVIFileExit();                    
                    return false;
                }
                bSetFormat = false;
            }


            if (bSetFormat == true)                                //Create Video Stream File
            {
                VStreamInfo.fccType = mmioFOURCC('v', 'i', 'd', 's');   //streamtypeVIDEO
                if (m_iType == 4)
					VStreamInfo.fccHandler = mmioFOURCC('D','I','V','X');
				else if (m_iType == 5)
					VStreamInfo.fccHandler = mmioFOURCC('H','2','6','4');
				else if (m_iType == 0)
					VStreamInfo.fccHandler = mmioFOURCC('M','J','P','G');
                //VStreamInfo.fccHandler = (m_iType == 4) ? mmioFOURCC('D', 'I', 'V', 'X') : mmioFOURCC('M', 'J', 'P', 'G');
                VStreamInfo.dwFlags = 0;
                VStreamInfo.dwCaps = 0;
                VStreamInfo.wPriority = 0;
                VStreamInfo.wLanguage = 0;
                VStreamInfo.dwScale = 1;
                VStreamInfo.dwRate = ( uint) VInfo.dFrameRate;
                VStreamInfo.dwStart = 0;
                VStreamInfo.dwLength = 0;
                VStreamInfo.dwInitialFrames = 0;
                VStreamInfo.dwSuggestedBufferSize = 0;
                VStreamInfo.dwQuality = 0xFFFFFFFF;
                VStreamInfo.dwSampleSize = 0;
                VStreamInfo.rcFrame.left = 0;
                VStreamInfo.rcFrame.top = 0;
                VStreamInfo.rcFrame.bottom = lVideoHeight;
                VStreamInfo.rcFrame.right = lVideoWidth;

                hr = AVIFileCreateStream(m_Avifile, out m_pVStream, ref VStreamInfo);

                if (hr != AVIERR_OK)
                {
                    m_err = true;
                    //MessageBox(NULL, "AVIFileCreateStream[Video] Error", "Warning", MB_OK | MB_ICONERROR);
                    return false;
                }


                sBitmapInfo.biSize = (uint)System.Runtime.InteropServices.Marshal.SizeOf(sBitmapInfo);
                sBitmapInfo.biWidth = lVideoWidth;
                sBitmapInfo.biHeight = lVideoHeight;
                sBitmapInfo.biPlanes = 1;
                sBitmapInfo.biBitCount = 24;
                if (m_iType == 4)
					sBitmapInfo.biCompression = mmioFOURCC('D','I','V','X');
				else if (m_iType == 5)
					sBitmapInfo.biCompression = mmioFOURCC('H','2','6','4');
				else if (m_iType == 0)
					sBitmapInfo.biCompression = mmioFOURCC('M','J','P','G');
                //sBitmapInfo.biCompression = (m_iType == 4) ? mmioFOURCC('D', 'I', 'V', 'X') : mmioFOURCC('M', 'J', 'P', 'G');
                sBitmapInfo.biSizeImage = (uint)(lVideoWidth * lVideoHeight * 3);
                sBitmapInfo.biXPelsPerMeter = 0;
                sBitmapInfo.biYPelsPerMeter = 0;
                sBitmapInfo.biClrUsed = 0;
                sBitmapInfo.biClrImportant = 0;


                IntPtr intParam = Marshal.AllocHGlobal(Marshal.SizeOf(sBitmapInfo));
                try
                {
                    Marshal.StructureToPtr(sBitmapInfo, intParam, false);

                    hr = AVIStreamSetFormat(m_pVStream, 0, intParam, Marshal.SizeOf(sBitmapInfo));
                    if (hr != AVIERR_OK)
                    {
                        m_err = true;
                        //  MessageBox(NULL, "AVIStreamSetFormat[Video] Error", "Warning", MB_OK | MB_ICONERROR);
                        return false;
                    }
                }
                finally
                {
                     // Free the unmanaged memory.
                     Marshal.FreeHGlobal(intParam);
                }

               
            }



            if (bSetFormat == true && bWithAudio == true)           //Create Audio Stream File
            {
                //Initial Audio Convert Module               
                int iRes = HomePlay.HOEM_Play_AudioConvert_Init(iCh, VInfo);

                AStreamInfo.fccType = mmioFOURCC('a', 'u', 'd', 's');// streamtypeAUDIO;
                AStreamInfo.fccHandler = 0;
                AStreamInfo.dwFlags = 0;
                AStreamInfo.dwCaps = 0;
                AStreamInfo.wPriority = 0;
                AStreamInfo.wLanguage = 0;
                AStreamInfo.dwScale = 1;
                AStreamInfo.dwRate = (uint)VInfo.iAudioSampleRate;
                AStreamInfo.dwStart = 0;
                AStreamInfo.dwLength = (uint)VInfo.iAudioFrameSize;
                AStreamInfo.dwInitialFrames = 0;
                AStreamInfo.dwSuggestedBufferSize = (uint)VInfo.iAudioFrameSize;
                AStreamInfo.dwQuality = 0;
                AStreamInfo.dwSampleSize = (uint)VInfo.iAudioSampleRate;

                AStreamInfo.rcFrame.left = 0;
                AStreamInfo.rcFrame.top = 0;
                AStreamInfo.rcFrame.right = 0;
                AStreamInfo.rcFrame.bottom = 0;


                hr = AVIFileCreateStream(m_Avifile, out m_pAStream, ref AStreamInfo);
                if (hr != AVIERR_OK)
                {
                    m_err = true;
                    //MessageBox(NULL, "AVIFileCreateStream[Audio] Error", "Warning", MB_OK | MB_ICONERROR);
                    return false;
                }

                
                WAVEFORMATEX sWAVEFORMATEX;
                
                sWAVEFORMATEX.wFormatTag = WAVE_FORMAT_PCM;
                sWAVEFORMATEX.nChannels = 2;
                sWAVEFORMATEX.wBitsPerSample = 16;
                sWAVEFORMATEX.nSamplesPerSec = (uint)VInfo.iAudioSampleRate;//hardcoded for now 48k sample rate
                sWAVEFORMATEX.nBlockAlign = (ushort)(sWAVEFORMATEX.wBitsPerSample * sWAVEFORMATEX.nChannels / 8);
                sWAVEFORMATEX.nAvgBytesPerSec = sWAVEFORMATEX.nSamplesPerSec * sWAVEFORMATEX.nBlockAlign;//* 2 channel * 2bytes per channel
                sWAVEFORMATEX.cbSize = 0;

                
                IntPtr intParam = Marshal.AllocHGlobal(Marshal.SizeOf(sWAVEFORMATEX));
                try
                {
                    Marshal.StructureToPtr(sWAVEFORMATEX, intParam, false);
                    hr = AVIStreamSetFormat(m_pAStream, 0, intParam, Marshal.SizeOf(sWAVEFORMATEX));

                    if (hr != AVIERR_OK)
                    {
                        m_err = true;
                        // MessageBox(NULL, "AVIStreamSetFormat[Audio] Error", "Warning", MB_OK | MB_ICONERROR);
                        return false;
                    }
                }
                finally
                {
                    Marshal.FreeHGlobal(intParam);
                }
            }

            return true;

        }


        //#define AVIIF_KEYFRAME	0x00000010L
        public bool SaveFrame(bool FrameType,
                              int iCount,
                              ref HFrame FrameData, 
                              int iCh)
        {   
            if (m_err == true) return false;

            int hr;
            if (FrameType == false)                 //Video Frame
            {
                if (FrameData.iFrameType == 2)   //I Frame
                {
                    hr = AVIStreamWrite(m_pVStream, iCount, 1,
                                        FrameData.cFrameData,
                                        FrameData.iDataLen, 
                                        AVIIF_KEYFRAME, 0, 0);

                    if (hr != AVIERR_OK)
                    {
                        m_err = true;
                      //  MessageBox(NULL, "AVIStreamWrite[I-frame] Error", "Warning", MB_OK | MB_ICONERROR);
                        return false;
                    }
                }
                else                               //P or B Frame
                {
                    hr = AVIStreamWrite(m_pVStream, iCount, 1,
                                        FrameData.cFrameData,
                                        FrameData.iDataLen, 
                                        0, 0, 0);
                    if (hr != AVIERR_OK)
                    {
                        m_err = true;
                     //   MessageBox(NULL, "AVIStreamWrite[P,B-frame] Error", "Warning", MB_OK | MB_ICONERROR);
                        return false;
                    }
                }
            }
            else                                   //Audio Frame
            {
                //Convert Audio to PCM Format                
                int iLen = HomePlay.HOEM_Play_ConvertAudioData(iCh, ref FrameData, 
                                                               m_AudioData);
                if (iLen > 0)
                {

                    int size = Marshal.SizeOf(m_AudioData[0]) * iLen;
                    IntPtr ptr = Marshal.AllocHGlobal(size);
                    try
                    {
                        Marshal.Copy(m_AudioData, 0, ptr, iLen);
                        hr = AVIStreamWrite(m_pAStream, iCount, 1,
                                        ptr,
                                        iLen,
                                        AVIIF_KEYFRAME,
                                        0, 0);
                        if (hr != AVIERR_OK)
                        {
                            m_err = true;
                            //MessageBox(NULL, "AVIStreamWrite[Audio-frame] Error", "Warning", MB_OK | MB_ICONERROR);
                            return false;
                        }
                    }
                    finally
                    {
                        Marshal.FreeHGlobal(ptr);
                    }
                }
                else
                {
                    return false;
                }

            }
            
            
            return true;
        }

        public bool CloseFile(int iCh)
        {

            HomePlay.HOEM_Play_AudioConvert_Deinit(iCh);            

            if (m_pVStream != IntPtr.Zero)
            {
                AVIStreamRelease(m_pVStream);
                m_pVStream = IntPtr.Zero;
            }

            if (m_pAStream != IntPtr.Zero)
            {
                AVIStreamRelease(m_pAStream);
                m_pAStream = IntPtr.Zero;
            }

            if (m_Avifile != 0)
            {
                AVIFileRelease(m_Avifile);
                m_Avifile = 0;
            }

            AVIFileExit();
                        
            return true;            
        }



    }
}
