﻿using System;
using System.Collections.Generic;


using System.ComponentModel;
using System.Data;

using System.Drawing;
using System.Text;

using System.Windows.Forms;

using System.IO;
using System.Runtime.InteropServices;

using DWORD = System.UInt32;
using WORD = System.UInt16;



namespace TestByCSharp
{
    
    public partial class Form1 : Form
    {              
        List<HFrame> myIntLists = new List<HFrame>();

        const int PLAY_BUFFER_IS_FULL = -3;
        //bool  m_bPushDecodeFrame = false;
        bool  m_bPushList = true;
        int   m_ICount = 0;   


        int	  m_iPlayBackCount = 0;
	    bool  m_bRecordPlayBack = true;
        int[]   m_Status = new int[16];
        HFrame[]  m_PlayBackFrameList = new HFrame[200];

        int[]     m_CamHandle = new int[16];
        static bool mbSaveAVI = true;
        static int  miCountV = 0;
        //static int  miCountA = 0;

        int[]  m_lWidth = new int[16];
        int[] m_lHeight = new int[16];

        AVIFileSave m_AVISaver = new AVIFileSave();
        HEVENT_CALLBACK fEventCallBack = new HEVENT_CALLBACK(EVENT_CALLBACK);
        HFRAME_CALLBACK fFrameCallBack = new HFRAME_CALLBACK(FRAME_CALLBACK);


        public Form1()
        {
            InitializeComponent();
           
        }
       
        private void Form1_Load(object sender, EventArgs e)
        {
            
            int iInit = HomeIPCam.HOEM_Cam_Init();
            HomePlay.HOEM_Play_Init();
            
            Color colRGB = System.Drawing.Color.FromArgb(0x14,0x00,0x14);
            DWORD dwColor = (DWORD)colRGB.ToArgb();


            HomePlay.HOEM_Play_SetUseOverlay(false, dwColor);
            HomePlay.HOEM_Play_CreatePlayer();


            HomePlay.HOEM_Play_SetPlayWindow(lblCH1.Handle, 0, lblCH1.Width, lblCH1.Height);
            HomePlay.HOEM_Play_SetPlayWindow(lblCH2.Handle, 1, lblCH2.Width, lblCH2.Height);
            HomePlay.HOEM_Play_SetPlayWindow(lblCH3.Handle, 2, lblCH3.Width, lblCH3.Height);
            HomePlay.HOEM_Play_SetPlayWindow(lblCH4.Handle, 3, lblCH4.Width, lblCH4.Height);
            HomePlay.HOEM_Play_SetPlayWindow(lblCH5.Handle, 4, lblCH5.Width, lblCH5.Height);



        }

        private void ClosedWindow(object sender, FormClosedEventArgs e)
        {
            HomeIPCam.HOEM_Cam_Deinit();            
            HomePlay.HOEM_Play_ReleasePlayWindow(0);
            HomePlay.HOEM_Play_ReleasePlayWindow(1);
            HomePlay.HOEM_Play_ReleasePlayWindow(2);
            HomePlay.HOEM_Play_ReleasePlayWindow(3);

            HomePlay.HOEM_Play_DestoryPlayer();
	        HomePlay.HOEM_Play_Deinit();


            for (int i = 0; i < myIntLists.Count; i++)
            {
                if (myIntLists[i].cFrameData != IntPtr.Zero)
                {
                    Marshal.FreeHGlobal(myIntLists[i].cFrameData);                    			        
                }
            }

            for(int i=0;i<200;++i)
	        {   		
		        if(m_PlayBackFrameList[i].cFrameData != IntPtr.Zero)
		        {
                    Marshal.FreeHGlobal(m_PlayBackFrameList[i].cFrameData);                    			        
		        }	        
            }
        }

        private unsafe void btnConnect1_Click(object sender, EventArgs e)
        {
            Connect_Info cInfo;            
            cInfo.iCh   = 0;
            cInfo.sIP   = tBoxIP1.Text;
            cInfo.iPort = Convert.ToInt32(tBoxPort.Text);
            cInfo.sPass = tBoxUser.Text;
            cInfo.sUser = tBoxPassword.Text;
       
            HomeIPCam.HOEM_Cam_Create(ref m_CamHandle[0],
                                       cInfo,
                                       fEventCallBack,0);
            
            int iType, iVideoChannel, iAudioChannel;
            int iRes = HomeIPCam.HOEM_Cam_GetCamera_TypeChannel(m_CamHandle[0],
                                                                out iType,
                                                                out iVideoChannel,
                                                                out iAudioChannel);

            iRes = HomeIPCam.HOEM_Cam_SetIPCamStreamNum(m_CamHandle[0], 0, 0);
            iRes = HomeIPCam.HOEM_Cam_SetRtspParams(m_CamHandle[0], HRTSP_TYPE.HUDP, "v2", 0);
         
            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[0], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_VIDEO);
            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[0], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_AUDIO);

            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[0], HFRAMETYPE_DLL.HIPCam_VIDEO);
            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[0], HFRAMETYPE_DLL.HIPCam_AUDIO);

        }

            
        public static int EVENT_CALLBACK(int iContext, int hCam, 
                                         byte ucChannel, 
                                         int iEventNum)
        {               
	        int iCh = ucChannel;            
            if (iEventNum != Program.mMeForm.m_Status[iCh])
	        {
		        string  sMsg;
		        if(iEventNum == 0)
		        {   			        
			        sMsg = string.Format("IPCam {0}  is Connect",iCh);
                    MessageBox.Show(sMsg, "Warning",MessageBoxButtons.OK);			        
		        }
		        else if(iEventNum < 0)
		        {   			        
                    sMsg = string.Format("IPCam {0}  is Unconnect",iCh);

			        MessageBox.Show(sMsg, "Warning",MessageBoxButtons.OK);
		        }
		        Program.mMeForm.m_Status[iCh] = iEventNum;
	        }
            return 1;    
        }


        public static int FRAME_CALLBACK(int iContext, byte ucChannel, 
                                 ref HFrame pFrame, 
                                 HVideo_Info VInfo)
        {
                int iCh = ucChannel;
                byte[] x = new byte[pFrame.iDataLen];
                Marshal.Copy(pFrame.cFrameData, x, 0, pFrame.iDataLen);


                if (mbSaveAVI && iCh == 0 && VInfo.iAudioType != -1)	//Wait for correct Audio Format
                {
                    //SaveToAVI just save video frame
                    HFrame pMPEG4Frame = new HFrame();
                    pMPEG4Frame.iDataLen = pFrame.iDataLen;
                    pMPEG4Frame.iFrameType = pFrame.iFrameType;
                    pMPEG4Frame.ftFrameTime = pFrame.ftFrameTime;

                    try
                    {                           
                        int size = Marshal.SizeOf(x[0]) * pFrame.iDataLen;
                        pMPEG4Frame.cFrameData = Marshal.AllocHGlobal(size);
                        Marshal.Copy(x, 0, pMPEG4Frame.cFrameData, pFrame.iDataLen);

                        HomeIPCam.HOEM_Cam_GetMPEG4Frame(ref pMPEG4Frame);  //To Get MPEG4 Data

                        if (pMPEG4Frame.iFrameType == 2 || pMPEG4Frame.iFrameType == 3
                           || pMPEG4Frame.iFrameType == 4 || pMPEG4Frame.iFrameType == 5)
                        {
                            if (miCountV == 0)
                            {
                                if (pMPEG4Frame.iFrameType != 5)
                                {
                                    string sName = "TestSaveAVI.avi";
                                    Program.mMeForm.m_AVISaver.OpenAviFile(sName, true, true, VInfo, iCh);
                                }
                            }

                            if (miCountV < 200)
                            {
                                if (pMPEG4Frame.iFrameType == 2 || pMPEG4Frame.iFrameType == 3
                                   || pMPEG4Frame.iFrameType == 4)
                                {
                                    Program.mMeForm.m_AVISaver.SaveFrame(false, miCountV, ref  pMPEG4Frame, iCh);
                                    ++miCountV;
                                }
                            }
                            else
                            {
                                if (pMPEG4Frame.iFrameType != 5)
                                {
                                    Program.mMeForm.m_AVISaver.CloseFile(iCh);
                                    mbSaveAVI = false;
                                    MessageBox.Show("Save AVI Done", "Warning", MessageBoxButtons.OK);
                                }
                            }
                        }
                    }
                    finally
                    {
                        // Free the unmanaged memory.
                        Marshal.FreeHGlobal(pMPEG4Frame.cFrameData);
                    }
                }
		           


                //Record PlayBack Frame
                if(iCh == 0 && (pFrame.iFrameType == 2 
                    || pFrame.iFrameType == 3 || 
                       pFrame.iFrameType == 4 || 
                       pFrame.iFrameType == 7))
                {
                    if (Program.mMeForm.m_bRecordPlayBack)
                    {
                        if (Program.mMeForm.m_iPlayBackCount < 200)
                        {
                            HFrame pNew = new HFrame();
                            pNew.iFrameType = pFrame.iFrameType;
                            pNew.ftFrameTime = pFrame.ftFrameTime;
                            pNew.iDataLen = pFrame.iDataLen;                            
                            int size = Marshal.SizeOf(x[0]) * pFrame.iDataLen;

                            Program.mMeForm.m_PlayBackFrameList[Program.mMeForm.m_iPlayBackCount] = pNew;
                            Program.mMeForm.m_PlayBackFrameList[Program.mMeForm.m_iPlayBackCount].cFrameData = Marshal.AllocHGlobal(size);
                            Marshal.Copy(x, 0, Program.mMeForm.m_PlayBackFrameList[Program.mMeForm.m_iPlayBackCount].cFrameData, pFrame.iDataLen);

                            ++Program.mMeForm.m_iPlayBackCount;
                        }
                        else
                        {                               
                            Program.mMeForm.m_bRecordPlayBack = false;
                            MessageBox.Show("Already Record PlayBack Data", "Warning",MessageBoxButtons.OK);
                            //pForm->m_PlayBackBtn.EnableWindow(true);
                        }
                    }
                }

                //Push Frame To Do Live PlayBack
                if (pFrame.iFrameType == 2 || 
                    pFrame.iFrameType == 3 || 
                    pFrame.iFrameType == 4 || 
                    pFrame.iFrameType == 5 || 
                    pFrame.iFrameType == 7)
                {
                    int iRes = HomePlay.HOEM_Play_PushPlayFrame(Program.mMeForm.m_CamHandle[iCh], 
                                                                iCh, ref pFrame);
                    if (iRes == PLAY_BUFFER_IS_FULL)
                    {
                        MessageBox.Show("PLAY_BUFFER_IS_FULL","Debug",MessageBoxButtons.OK);
                    }
                }
            
		           
                //Ch1 Make FrameList to Test Save AVI
                if(Program.mMeForm.m_bPushList && iCh == 0)
                {
                    if((pFrame.iFrameType == 2 || 
                        pFrame.iFrameType == 3 || 
                        pFrame.iFrameType == 4) && ++Program.mMeForm.m_ICount < 3)
                    {                           
                        HFrame cpFrame2 = new HFrame();
                        cpFrame2.iFrameType = pFrame.iFrameType;
                        cpFrame2.iDataLen = pFrame.iDataLen;
                        cpFrame2.ftFrameTime = pFrame.ftFrameTime;

                        int size = Marshal.SizeOf(x[0]) * pFrame.iDataLen;
                        cpFrame2.cFrameData = Marshal.AllocHGlobal(size);

                        Marshal.Copy(x, 0, cpFrame2.cFrameData, pFrame.iDataLen);
                       
                        //memcpy(cpFrame2->cFrameData, pFrame->cFrameData, pFrame->iDataLen);                        
                        //pForm->m_FrameList.push_back(cpFrame2);

                        Program.mMeForm.myIntLists.Add(cpFrame2);
                    }
                    else
                    {
                        MessageBox.Show("Make CH1 Frame List Done","Test",MessageBoxButtons.OK);
                        Program.mMeForm.m_bPushList = false;
                    }
                }
                      
                Program.mMeForm.m_lWidth[iCh] = VInfo.iWidth;
                Program.mMeForm.m_lHeight[iCh] = VInfo.iHeight;                
                return 1;
        }

        private void btnDisconnect1_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_Delete(ref m_CamHandle[0]);
        }

        private void btnPlay_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Play(0);
        }

        private void btnStop_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Stop(0);
        }

        private void btnPause_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Pause(0);
        }

        private void btnStep_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Step(0);
        }

        private void btnSet2WayOn_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_Set2WayAudio(m_CamHandle[0], true);
        }

        private void btnSet2WayOff_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_Set2WayAudio(m_CamHandle[0], false);
        }

        private void btnPlayAudio_Click(object sender, EventArgs e)
        {
            bool bPlay = HomePlay.HOEM_Play_GetPlayAudio(0);
            HomePlay.HOEM_Play_SetPlayAudio(0, !bPlay);
        }

        private void btnSetVideo_Click(object sender, EventArgs e)
        {                                       
            HVideo_Config vConfig;
            vConfig.iFormat = 0;
            vConfig.iFps = 0;
            vConfig.iMode = 0;
            vConfig.iQuality = 0;
            vConfig.iResolution = 0;

            HomeIPCam.HOEM_Cam_GetVideo(m_CamHandle[0], ref vConfig);

            vConfig.iResolution = Convert.ToInt32(tBoxResolution.Text);
            vConfig.iQuality = Convert.ToInt32(tBoxQuality.Text);

            bool iRes = HomeIPCam.HOEM_Cam_SetVideo(m_CamHandle[0], vConfig);
        }

        private void btnGetVideo_Click(object sender, EventArgs e)
        {                                       
            HVideo_Config vConfig;
            vConfig.iFormat = 0;
            vConfig.iFps = 0;
            vConfig.iMode = 0;
            vConfig.iQuality = 0;
            vConfig.iResolution = 0;

            HomeIPCam.HOEM_Cam_GetVideo(m_CamHandle[0], ref vConfig);

            tBoxResolution.Text = string.Format("{0}",vConfig.iResolution);
            tBoxQuality.Text = string.Format("{1}", vConfig.iQuality);                       
        }

        private void btnCH1_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_Delete(ref m_CamHandle[0]);
            Connect_Info cInfo;
            cInfo.iCh = 0;
            cInfo.sIP = "192.168.1.225";
            cInfo.iPort = 80;
            cInfo.sPass = "admin";
            cInfo.sUser = "admin";

            int iRes = HomeIPCam.HOEM_Cam_Create(ref m_CamHandle[0],
                                       cInfo,
                                       fEventCallBack, 0);

            iRes = HomeIPCam.HOEM_Cam_SetIPCamStreamNum(m_CamHandle[0], 0, 0);
            iRes = HomeIPCam.HOEM_Cam_SetRtspParams(m_CamHandle[0], HRTSP_TYPE.HUDP, "v2", 0);
                                                      
            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[0], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_VIDEO);
            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[0], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_AUDIO);

            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[0], HFRAMETYPE_DLL.HIPCam_VIDEO);
            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[0], HFRAMETYPE_DLL.HIPCam_AUDIO);
        }

        private void btnCH2_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_Delete(ref m_CamHandle[0]);
            Connect_Info cInfo;
            cInfo.iCh = 0;
            cInfo.sIP = "192.168.1.225";
            cInfo.iPort = 80;
            cInfo.sPass = "admin";
            cInfo.sUser = "admin";
      
            int iRes = HomeIPCam.HOEM_Cam_Create(ref m_CamHandle[0],
                                       cInfo,
                                       fEventCallBack, 0);

            iRes = HomeIPCam.HOEM_Cam_SetIPCamStreamNum(m_CamHandle[0], 1, 0);
            iRes = HomeIPCam.HOEM_Cam_SetRtspParams(m_CamHandle[0], HRTSP_TYPE.HUDP, "v2", 0);

        

            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[0], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_VIDEO);
            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[0], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_AUDIO);

            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[0], HFRAMETYPE_DLL.HIPCam_VIDEO);
            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[0], HFRAMETYPE_DLL.HIPCam_AUDIO);

        }

        private void btnCH3_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_Delete(ref m_CamHandle[0]);
            Connect_Info cInfo;
            cInfo.iCh = 0;
            cInfo.sIP = "192.168.1.225";
            cInfo.iPort = 80;
            cInfo.sPass = "admin";
            cInfo.sUser = "admin";

            int iRes = HomeIPCam.HOEM_Cam_Create(ref m_CamHandle[0],
                                       cInfo,
                                       fEventCallBack, 0);

            iRes = HomeIPCam.HOEM_Cam_SetIPCamStreamNum(m_CamHandle[0], 2, 0);
            iRes = HomeIPCam.HOEM_Cam_SetRtspParams(m_CamHandle[0], HRTSP_TYPE.HUDP, "v2", 0);


            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[0], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_VIDEO);
            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[0], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_AUDIO);

            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[0], HFRAMETYPE_DLL.HIPCam_VIDEO);
            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[0], HFRAMETYPE_DLL.HIPCam_AUDIO);
        }

        private void btnCH4_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_Delete(ref m_CamHandle[0]);
            Connect_Info cInfo;
            cInfo.iCh = 0;
            cInfo.sIP = "192.168.1.225";
            cInfo.iPort = 80;
            cInfo.sPass = "admin";
            cInfo.sUser = "admin";

            int iRes = HomeIPCam.HOEM_Cam_Create(ref m_CamHandle[0],
                                       cInfo,
                                       fEventCallBack, 0);

            iRes = HomeIPCam.HOEM_Cam_SetIPCamStreamNum(m_CamHandle[0], 3, 0);
            iRes = HomeIPCam.HOEM_Cam_SetRtspParams(m_CamHandle[0], HRTSP_TYPE.HUDP, "v2", 0);

       
            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[0], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_VIDEO);
            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[0], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_AUDIO);

            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[0], HFRAMETYPE_DLL.HIPCam_VIDEO);
            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[0], HFRAMETYPE_DLL.HIPCam_AUDIO);
        }

        private void btnGetChannel_Click(object sender, EventArgs e)
        {
            int iType, iVideoChannel, iAudioChannel;
	        int iRes = HomeIPCam.HOEM_Cam_GetCamera_TypeChannel(m_CamHandle[0],
                                                     out iType,
                                                     out iVideoChannel,
                                                     out iAudioChannel);
	        if(iRes < 0)
	        {   
		        MessageBox.Show("Get Camera Type Channel failed!!","debug",MessageBoxButtons.OK);
		        return;
	        }

            tBoxVideoCh.Text = string.Format("{0}", iVideoChannel);
            tBoxAudioCh.Text = string.Format("{0}", iAudioChannel);
        }

        private void tBoxResize_Click(object sender, EventArgs e)
        {                                       
            int bSuccess = HomePlay.HOEM_Play_SetWindowSize(0, 
                                  Convert.ToInt32(tBoxWidth.Text),
                                  Convert.ToInt32(tBoxHeight.Text));
        }

        private void btnSnapShotBmp_Click(object sender, EventArgs e)
        {               
	        HomePlay.HOEM_Play_SnapShot_BMP(0,tBoxImageFile.Text,
                                           tBoxImageFile.Text.Length);
        }

        private void btnSnapShotJPG_Click(object sender, EventArgs e)
        {                                       
            HomePlay.HOEM_Play_SnapShot_JPG(0, tBoxImageFile.Text,
                                            tBoxImageFile.Text.Length);
        }

        private void btnExecuteCGI_Click(object sender, EventArgs e)
        { 
          uint ulSize = 512;                  
          //========================================//
          IntPtr ptrStr = new IntPtr();
          ptrStr = Marshal.AllocHGlobal(512);

          if (!HomeIPCam.HOEM_Cam_Execute_CGI(m_CamHandle[0], 
                                              tBoxExecuteCGI.Text,
                                              ptrStr, ref ulSize))
          {   
              MessageBox.Show("CGI Error", "Debug", MessageBoxButtons.OK);
          }else
          {
              byte[] byBuf = new byte[ulSize];
              Marshal.Copy(ptrStr, byBuf, 0, (int)ulSize);
              tBoxRecCGI.Text = System.Text.ASCIIEncoding.ASCII.GetString(byBuf); 
          }
          Marshal.FreeHGlobal(ptrStr);                            
        }

        

        private void btnGetResolution_Click(object sender, EventArgs e)
        {
            HVideo_Config[] HVC = new HVideo_Config[4];
	        int[] iWidth = new int[4];
            int[] iHeigh = new int[4];
	
            for(int i=0;i<4;++i)
            {
                if (HomeIPCam.HOEM_Cam_GetVideo(m_CamHandle[i], ref HVC[i]) == true)
	            {
                    HomeIPCam.HOEM_Cam_GetResolutionSet(m_CamHandle[i], HVC[i].iResolution, ref iWidth[i], ref iHeigh[i]);
	            }
            }

            tBoxResCh1.Text = string.Format("{0} * {1}", iWidth[0], iHeigh[0]);
            tBoxResCh2.Text = string.Format("{0} * {1}", iWidth[1], iHeigh[1]);
            tBoxResCh3.Text = string.Format("{0} * {1}", iWidth[2], iHeigh[2]);
            tBoxResCh4.Text = string.Format("{0} * {1}", iWidth[3], iHeigh[3]);
        }

        private void btnPlayBack_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Play(4);
            for (int i = 0; i < 200; ++i)
            {
                HomePlay.HOEM_Play_PushPlayFrame(m_CamHandle[4], 4, 
                                            ref m_PlayBackFrameList[i]);
            }
        }
  
        private unsafe void btnGetDecodeBitmap_Click(object sender, EventArgs e)
        {   
            if (myIntLists.Count <= 0) return;
            
            uint lWidth, lHeight;            
//===============================================================//                        
            SYSTEMTIME stTime;
            HFrame*[] FrameList = new HFrame*[myIntLists.Count];
            

            HFrame[] FrameTemp = new HFrame[myIntLists.Count];
            for (int i = 0; i < myIntLists.Count; i++)
            {
                FrameTemp[i] = myIntLists[i];
                fixed (HFrame* FrameTemp2 = FrameTemp)
                {
                    FrameList[i] = FrameTemp2+i;
                }                
            }

            fixed (HFrame** ptrFramePtrs = FrameList)
            {                    
                char* pBuf=null;
                int iRet = HomePlay.HOEM_Play_GetDecodeFrame(HDecode_Type.HDTYPE_YUV422,
                                                              0, ptrFramePtrs,
                                                              myIntLists.Count,
                                                              out pBuf,
                                                              out lWidth,
                                                              out lHeight,
                                                              out stTime);

                if (pBuf != null)
                {
                    HomePlay.HOEM_Play_DeleteDecodeFrameData(ref pBuf);
                }
            }

        }

        private void btnGetDecodeFrame_Click(object sender, EventArgs e)
        {
            HFrame hFrame = new HFrame();       
            if(myIntLists.Count>0)
            {                   
                //myIntLists.
                hFrame.iFrameType = myIntLists[0].iFrameType;
                hFrame.iDataLen = myIntLists[0].iDataLen;
                hFrame.ftFrameTime = myIntLists[0].ftFrameTime;


                byte[] x = new byte[hFrame.iDataLen];
                Marshal.Copy(myIntLists[0].cFrameData, x, 0, hFrame.iDataLen);

                int size = Marshal.SizeOf(x[0]) * hFrame.iDataLen;
                hFrame.cFrameData = Marshal.AllocHGlobal(size);
                Marshal.Copy(x, 0, hFrame.cFrameData, hFrame.iDataLen);
                
                HomePlay.HOEM_Play_GetMPEG4Frame(0,out hFrame);

                Marshal.FreeHGlobal(hFrame.cFrameData);
            }            
        }

        private void btnConnect2_Click(object sender, EventArgs e)
        {
            Connect_Info cInfo;            
            cInfo.sIP = tBoxIP2.Text;
            cInfo.iPort = Convert.ToInt32(tBoxPort2.Text);
            cInfo.sUser = tBoxUser2.Text;
            cInfo.sPass = tBoxPassword2.Text;
            cInfo.iCh = 1;
       
            int iRes = HomeIPCam.HOEM_Cam_Create(ref m_CamHandle[1],
                                                  cInfo,
                                                  fEventCallBack, 
                                                  0);
                   
            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[1], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_VIDEO);
            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[1], HFRAMETYPE_DLL.HIPCam_VIDEO);                        
            
        }

        private void btnDisconnect2_Click(object sender, EventArgs e)
        {                                       
            HomeIPCam.HOEM_Cam_Delete(ref m_CamHandle[1]);
        }

        private void btnPlay2_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Play(1);
        }

        private void btnStop2_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Stop(1);
        }

        private void btnPause2_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Pause(1);
        }

        private void btnGetPTZ_Click(object sender, EventArgs e)
        {               
            HPTZ_Info mInfo = new HPTZ_Info();
            mInfo.sPointName = new IntPtr[10];           
            if(!HomeIPCam.HOEM_Cam_GetPTZ(m_CamHandle[1],out mInfo))
            {
                MessageBox.Show("GetPTZFailed","",MessageBoxButtons.OK);
            }
                                  
            string str = string.Format("{0}",mInfo.iPTZType);
            tBoxPTZ.Text = str;                
        }

        private void btnTestPreset_Click(object sender, EventArgs e)
        {
             string pStr = "3:Test";
             HomeIPCam.HOEM_Cam_SetPTZ_Preset(m_CamHandle[1], pStr, pStr.Length);
        }

        private void btnPTZUp_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_SetPTZ_Up(m_CamHandle[1]);
        }

        private void btnPTZLeft_Click(object sender, EventArgs e)
        {   
            HomeIPCam.HOEM_Cam_SetPTZ_Left(m_CamHandle[1]);

        }

        private void btnPTZHome_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_SetPTZ_Home(m_CamHandle[1]);
        }

        private void btnPTZRight_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_SetPTZ_Right(m_CamHandle[1]);
        }

        private void btnPTZDown_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_SetPTZ_Down(m_CamHandle[1]);
        }

        private void btnPTZAuto_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_SetPTZ_AutoScan(m_CamHandle[1]);
        }

        private void btnPTZStop_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_SetPTZ_StopScan(m_CamHandle[1]);
        }

        private void btnSetOSD_Click(object sender, EventArgs e)
        {               
            bool bBold = cBoxBold.Checked, bItalic = cBoxItalic.Checked;                                                                                                      
            HomePlay.HOEM_Play_SetOSD(1, tBoxOSD.Text,
                            Convert.ToInt32(tBoxX.Text),
                            Convert.ToInt32(tBoxY.Text),
                            Convert.ToInt32(tBoxOSDHeight.Text), 
                            bBold, 
                            bItalic,
                            Convert.ToInt32(tBoxOSDR.Text),
                            Convert.ToInt32(tBoxOSDG.Text),
                            Convert.ToInt32(tBoxOSDB.Text));
        }

        private void btnCloseOSD_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_CloseOSD(1);
        }

        private void btnConnect3_Click(object sender, EventArgs e)
        {
            Connect_Info cInfo;
            cInfo.sIP = tBoxIP3.Text;
            cInfo.iPort = Convert.ToInt32(tBoxPort3.Text);
            cInfo.sUser = tBoxUser3.Text;
            cInfo.sPass = tBoxPassword3.Text;
            cInfo.iCh = 2;

       
            int iRes = HomeIPCam.HOEM_Cam_Create(ref m_CamHandle[2],
                                                  cInfo,
                                                  fEventCallBack,
                                                  0);
  
            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[2], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_VIDEO);            
            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[2], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_AUDIO);


            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[2], HFRAMETYPE_DLL.HIPCam_VIDEO);
            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[2], HFRAMETYPE_DLL.HIPCam_AUDIO);

        }

        private void btnDisconnect3_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_Delete(ref m_CamHandle[2]);
        }

        private void btnPlay3_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Play(2);
        }

        private void btnStop3_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Stop(2);
        }

        private void btnPause3_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Pause(2);
        }

        private void btnGetMotion_Click(object sender, EventArgs e)
        {
            HGet_Motion_Info mInfo;
            mInfo.rArea = new RECT[3];
            mInfo.bEnabled = new bool[3];
            mInfo.iSensitivity = new int[3];

            HomeIPCam.HOEM_Cam_GetMotion(m_CamHandle[2], out mInfo);
        }

        private void btnSetMotion_Click(object sender, EventArgs e)
        {

            HGet_Motion_Info mGInfo = new HGet_Motion_Info();
            mGInfo.rArea = new RECT[3];
            mGInfo.bEnabled = new bool[3];
            mGInfo.iSensitivity = new int[3];
            HomeIPCam.HOEM_Cam_GetMotion(m_CamHandle[2], out mGInfo);
            
            
            HSet_Motion_Info mSInfo = new HSet_Motion_Info();
            //modify later   mike mark......
            mSInfo.bEnabled = new bool[3];
            mSInfo.rArea = new RECT[3];
            mSInfo.iSensitivity = new int[3];
            
            mSInfo.bEnabled[0] = true;
            mSInfo.iSensitivity[0] = 5;
            mSInfo.rArea[0].top = 20;
            mSInfo.rArea[0].left = 20;
            mSInfo.rArea[0].bottom = 50;
            mSInfo.rArea[0].right = 50;

            mSInfo.bEnabled[1] = false;
            mSInfo.iSensitivity[1] = 5;
            mSInfo.rArea[1].top = 0;
            mSInfo.rArea[1].left = 0;
            mSInfo.rArea[1].bottom = 0;
            mSInfo.rArea[1].right = 0;

            HomeIPCam.HOEM_Cam_SetMotion(m_CamHandle[2], mSInfo);
        }

        private void btnSnapShotToMemory_Click(object sender, EventArgs e)
        {                   
            //Test SnapShotToMemory
            //5242980= 1280*1024*4+100
            byte[] cBuf = new byte[5242980];
            uint iBufSize = 5242980;
            

            IntPtr pBuf = new IntPtr();
            pBuf = Marshal.AllocHGlobal((int)iBufSize);
            int iRes = HomePlay.HOEM_Play_SnapShotToMemory_BMP(2, pBuf, ref iBufSize);
                        
            //SaveToFile
            if (iRes > 0 && iBufSize>0)
            {
                string sName = "C:\\Test.bmp";                
                FileStream aFile = new FileStream(sName, FileMode.Create,FileAccess.Write);
                BinaryWriter BW = new BinaryWriter(aFile);

                Marshal.Copy(pBuf, cBuf, 0, (int)iBufSize);  //加入此處......

                BW.Write(cBuf, 0, (int)iBufSize);

                BW.Close();

                aFile.Close();                
            }

            Marshal.FreeHGlobal(pBuf);
        }

        private void btnEncrypt_Click(object sender, EventArgs e)
        {            
            HomePlay.HOEM_Play_Set_EncryptKey(2, true,tBoxEncrypt.Text);
        }

        private void btnDisencrypt_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Set_EncryptKey(2, false,"");            
        }

        private void btnConnect4_Click(object sender, EventArgs e)
        {
            Connect_Info cInfo;
            cInfo.sIP = tBoxIP4.Text;
            cInfo.iPort = Convert.ToInt32(tBoxPort4.Text);
            cInfo.sUser = tBoxUser4.Text;
            cInfo.sPass = tBoxPassword4.Text;
            cInfo.iCh = 3;
        

            int iRes = HomeIPCam.HOEM_Cam_Create(ref m_CamHandle[3],
                                                  cInfo,
                                                  fEventCallBack,
                                                  0);

            iRes = HomeIPCam.HOEM_Cam_SetRtspParams(m_CamHandle[3], HRTSP_TYPE.HUDP, "",0);
    
            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[3], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_VIDEO);
            iRes = HomeIPCam.HOEM_Cam_Connect(m_CamHandle[3], fFrameCallBack, 0, HFRAMETYPE_DLL.HIPCam_AUDIO);


            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[3], HFRAMETYPE_DLL.HIPCam_VIDEO);
            iRes = HomeIPCam.HOEM_Cam_StartReceive(m_CamHandle[3], HFRAMETYPE_DLL.HIPCam_AUDIO);                        

        }

        private void btnDisconnect4_Click(object sender, EventArgs e)
        {
            HomeIPCam.HOEM_Cam_Delete(ref m_CamHandle[3]);
        }

        private void btnPlay4_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Play(3);
        }

        private void btnStop4_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Stop(3);
        }

        private void btnPause4_Click(object sender, EventArgs e)
        {
            HomePlay.HOEM_Play_Pause(3);
        }

        private void cBoxSet2WayAudio_CheckedChanged(object sender, EventArgs e)
        {
            if (cBoxSet2WayAudio.Checked==true)
            {
                HomeIPCam.HOEM_Cam_Set2WayAudio(m_CamHandle[2], true);
            }
            else
            {
                HomeIPCam.HOEM_Cam_Set2WayAudio(m_CamHandle[2], false);
            }
        }        
    }
}