﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

using DWORD = System.UInt32;
using WORD = System.UInt16;

//typedef int (CALLBACK * HEVENT_CALLBACK)(int iContext, HANDLE hCam, unsigned char ucChannel, int iEventNum);

namespace TestByCSharp
{       
    public enum HRTSP_TYPE
    {

        HTCP,

        HUDP,

        /// __INVALID_RTSPTYPE -> 0xFFFFFFFF
        @__INVALID_RTSPTYPE = -1,
    }


    public enum HFRAMETYPE_DLL
    {

        HIPCam_VIDEO,

        HIPCam_AUDIO,

        HIPCam_EVENT,

        /// __FRAMETYPE_BOUNDARY -> 0xFFFFFFFF
        @__FRAMETYPE_BOUNDARY = -1,
    }


    [System.Runtime.InteropServices.UnmanagedFunctionPointerAttribute(System.Runtime.InteropServices.CallingConvention.StdCall)]
    public delegate int HEVENT_CALLBACK(int iContext, int hCam, byte ucChannel, int iEventNum);

    [System.Runtime.InteropServices.UnmanagedFunctionPointerAttribute(System.Runtime.InteropServices.CallingConvention.StdCall)]
    public delegate int HFRAME_CALLBACK(int iContext, byte ucChannel, ref HFrame pFrame, HVideo_Info VInfo);


    public enum HPTZ_MODEL
    {

        /// HPTZ_NONE -> 0
        HPTZ_NONE = 0,

        HPTZ_HPT_11A,

        HPTZ_Panasonic_CS850,

        HPTZ_DynaColor_D,

        HLilin_PIH_7600,

        HPTZ_PELCO_D,

        HPTZ_PELCO_P,

        HPTZ_DMP_15H1,

        HPTZ_HLC_860,

        HPTZ_HLC_870,

        /// __PTZTYPE_BOUNDARY -> 0xFFFFFFFF
        @__PTZTYPE_BOUNDARY = -1,
    }

   [StructLayout(LayoutKind.Sequential)]
    public struct HVideo_Config
    {
        public int iResolution;
        /**	0 : QCIF
            1 : CIF
            2 : VGA
            3 : D1  
        **/
        public int iQuality;
        /** 0 : Low
            1 : Medium
            2 : Standard
            3 : High
            4 : Best
        **/
        public int iFps;
        /**	NTSC	3 ~ 30
            PAL		3 ~ 25
        **/
        public int iMode;
        /**	1 : MPEG4
            2 : JPEG
        **/
        public int iFormat;
        /**	1 : NTSC
            2 : PAL
        **/
    };

    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
    public struct RECT
    {   
        /// LONG->int
        public int left;

        /// LONG->int
        public int top;

        /// LONG->int
        public int right;

        /// LONG->int
        public int bottom;
    }
   

    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
    public struct HGet_Motion_Info
    {           
        /// boolean[3]
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValArray, SizeConst = 3, ArraySubType = System.Runtime.InteropServices.UnmanagedType.Bool)]
        public bool[] bEnabled;

        /// RECT[3]
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValArray, SizeConst = 3, ArraySubType = System.Runtime.InteropServices.UnmanagedType.Struct)]
        public RECT[] rArea;

        /// int[3]
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValArray, SizeConst = 3, ArraySubType = System.Runtime.InteropServices.UnmanagedType.I4)]
        public int[] iSensitivity;

        /// int
        public int iSenMinValue;

        /// int
        public int iSenMaxValue;
    }


    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
    public struct HSet_Motion_Info
    {   
        /// boolean[3]
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValArray, SizeConst = 3, ArraySubType = System.Runtime.InteropServices.UnmanagedType.Bool)]
        public bool[] bEnabled;

        /// RECT[3]
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValArray, SizeConst = 3, ArraySubType = System.Runtime.InteropServices.UnmanagedType.Struct)]
        public RECT[] rArea;

        /// int[3]
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValArray, SizeConst = 3, ArraySubType = System.Runtime.InteropServices.UnmanagedType.I4)]
        public int[] iSensitivity;
    }
  

    [System.Runtime.InteropServices.StructLayoutAttribute(System.Runtime.InteropServices.LayoutKind.Sequential)]
    public struct HPTZ_Info
    {
        public HPTZ_MODEL iPTZType;

        /// int
        public int iDeviceID;

        /// int
        public int iBaudRate;

        /// int
        public int iSpeed;

        /// char*[10]
        [System.Runtime.InteropServices.MarshalAsAttribute(System.Runtime.InteropServices.UnmanagedType.ByValArray, SizeConst = 10, ArraySubType = System.Runtime.InteropServices.UnmanagedType.SysUInt)]
        public System.IntPtr[] sPointName;
    }



    public struct PTZOSCInfo
    {
        public int iWidth;
        public int iHeight;
        public int iX;
        public int iY;
        
        public PTZOSCInfo(int _iW, int _iH, int _iX, int _iY)
        {
            iWidth= _iW;
            iHeight = _iH;
            iX = _iX;
            iY = _iY;
        }
   };

    public struct WAVEFORMATEX
    { 
       public WORD  wFormatTag;
       public WORD nChannels;
       public DWORD nSamplesPerSec;
       public DWORD nAvgBytesPerSec;
       public WORD nBlockAlign;
       public WORD wBitsPerSample;
       public WORD cbSize; 
   };

    public struct Connect_Info
    {
        public string  sIP;
        public int iPort;
        public string sUser;
        public string sPass;
        public int iCh;
    };

    class HomeIPCam
    {
  
        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_GetMaxChannel();
        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_Init();
        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_Deinit();
        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_Create(ref int hCam,
                                                 Connect_Info cInfo,
                                                 HEVENT_CALLBACK peCallback,
                                                 int iContext);        
        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_Delete(ref int hCam);




        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_SetAutoReconnect(int hCam, bool bEnabled);


        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_Connect(int hCam, 
                                                  HFRAME_CALLBACK pfCallback,
                                                  int iContext,
                                                  HFRAMETYPE_DLL eFrameType);

        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_CleanAll();

      
        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_SetRtspParams(int hCam, 
                                                        HRTSP_TYPE rType, 
                                                        string pcUrlPath, 
                                                        int iUdpPort);

         
        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_GetCamera_TypeChannel(int hCam, 
                                                              out int Type,
                                                              out int VideoChannel,
                                                              out int AudioChannel);

        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_SetIPCamStreamNum(int hCam, int iVideoStream, 
                                                          int iAudioStream);

       
        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_StartReceive(int  hCam, HFRAMETYPE_DLL eFrameType);

        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_PauseReceive(int hCam, HFRAMETYPE_DLL eFrameType);
        
        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_ContinueReceive(int hCam, HFRAMETYPE_DLL eFrameType);

        
        [DllImport("HIPCam_SDK.dll")]
        public static extern bool HOEM_Cam_IsCamLive(int hCam);

        
        [DllImport("HIPCam_SDK.dll")]
        public static extern int HOEM_Cam_GetCamStatus(int hCam);


     
         [DllImport("HIPCam_SDK.dll")]
         public static extern bool HOEM_Cam_IsSupportPTZ(int hCam);

         [DllImport("HIPCam_SDK.dll")]
         public static extern bool HOEM_Cam_GetVideo(int hCam, ref HVideo_Config vConfig);
            
         [DllImport("HIPCam_SDK.dll")]
         public static extern bool HOEM_Cam_SetVideo(int hCam, HVideo_Config vConfig);

            
         [DllImport("HIPCam_SDK.dll")]
         public static extern bool HOEM_Cam_GetMotion(int hCam, out HGet_Motion_Info mInfo);

            
         [DllImport("HIPCam_SDK.dll")]
         public static extern bool HOEM_Cam_SetMotion(int hCam, HSet_Motion_Info mInfo);
    

       [DllImport("HIPCam_SDK.dll")]
       public static extern bool HOEM_Cam_GetPTZ(int hCam, out HPTZ_Info m_Info);
       [DllImport("HIPCam_SDK.dll")]
       public static extern bool HOEM_Cam_SetPTZ_Param(int hCam, HPTZ_Info m_Info);        
       [DllImport("HIPCam_SDK.dll")]
       public static extern bool HOEM_Cam_SetPTZ_Up(int hCam);        
       [DllImport("HIPCam_SDK.dll")]
       public static extern bool HOEM_Cam_SetPTZ_Down(int hCam);        
       [DllImport("HIPCam_SDK.dll")]
       public static extern bool HOEM_Cam_SetPTZ_Right(int hCam);

       [DllImport("HIPCam_SDK.dll")]
        public static extern bool HOEM_Cam_SetPTZ_Left(int hCam);


    
     [DllImport("HIPCam_SDK.dll")]
     public static extern bool HOEM_Cam_SetPTZ_UpLeft(int hCam);
     [DllImport("HIPCam_SDK.dll")]
        public static extern bool HOEM_Cam_SetPTZ_UpRight(int hCam);
     [DllImport("HIPCam_SDK.dll")]
        public static extern bool HOEM_Cam_SetPTZ_DownLeft(int hCam);
     [DllImport("HIPCam_SDK.dll")]
        public static extern bool HOEM_Cam_SetPTZ_DownRight(int hCam);
     [DllImport("HIPCam_SDK.dll")]
        public static extern bool HOEM_Cam_SetPTZ_Home(int hCam);

      [DllImport("HIPCam_SDK.dll")]
      public static extern bool HOEM_Cam_SetPTZ_ZoomIn(int hCam);
      [DllImport("HIPCam_SDK.dll")]
      public static extern bool HOEM_Cam_SetPTZ_ZoomOut(int hCam);
      [DllImport("HIPCam_SDK.dll")]
      public static extern bool HOEM_Cam_SetPTZ_FocusIn(int hCam);
      [DllImport("HIPCam_SDK.dll")]
      public static extern bool HOEM_Cam_SetPTZ_FocusOut(int hCam);
      [DllImport("HIPCam_SDK.dll")]
      public static extern bool HOEM_Cam_SetPTZ_IrisOpen(int hCam);


        
        [DllImport("HIPCam_SDK.dll")]
        public static extern bool HOEM_Cam_SetPTZ_IrisClose(int hCam);
        [DllImport("HIPCam_SDK.dll")]
        public static extern bool HOEM_Cam_SetPTZ_AutoScan(int hCam);
            [DllImport("HIPCam_SDK.dll")]
        public static extern bool HOEM_Cam_SetPTZ_StopScan(int hCam);
            [DllImport("HIPCam_SDK.dll")]
        public static extern bool HOEM_Cam_SetPTZ_Type(int hCam, HPTZ_MODEL hType);
            [DllImport("HIPCam_SDK.dll")]
            public static extern bool HOEM_Cam_SetPTZ_Deviceid(int hCam, int iID);

       
            [DllImport("HIPCam_SDK.dll")]
            public static extern bool HOEM_Cam_SetPTZ_Baudrate(int hCam, int iBaud);
              
           [DllImport("HIPCam_SDK.dll")]
           public static extern bool HOEM_Cam_SetPTZ_Speed(int hCam, int iSpeed);
              
           [DllImport("HIPCam_SDK.dll")]
           public static extern bool HOEM_Cam_SetPTZ_Point(int hCam, int iPoint);
              
          [DllImport("HIPCam_SDK.dll")]
          public static extern bool HOEM_Cam_SetPTZ_Preset(int hCam, string pStr, int iStrLength);
              
          [DllImport("HIPCam_SDK.dll")]
          public static extern bool HOEM_Cam_SetPTZ_Remove(int hCam, string pStr, int iStrLength);
              
          [DllImport("HIPCam_SDK.dll")]
          public static extern bool HOEM_Cam_SetPTZ_Move(int hCam, PTZOSCInfo Info);
           
          [DllImport("HIPCam_SDK.dll")]
          public static extern bool HOEM_Cam_Execute_CGI(int hCam, string pCmd, 
                                                         IntPtr      pRecvStr, 
                                                         ref  UInt32 pBufSize);
    
          [DllImport("HIPCam_SDK.dll")]
          public static extern  bool HOEM_Cam_GetMPEG4Frame(ref HFrame pFrame);          
          
          //HFrame     modify later......          
          [DllImport("HIPCam_SDK.dll")]
          unsafe public static extern IntPtr HOEM_Cam_AskSystemFrame(int hCam);
      
          
          [DllImport("HIPCam_SDK.dll")]
          public static extern bool HOEM_Cam_DeleteFrame(ref HFrame pFrame);

          [DllImport("HIPCam_SDK.dll")]
          public static extern bool HOEM_Cam_GetResolutionSet(int hCam, 
                                                              int iMode, 
                                                              ref int iWidth, 
                                                              ref int iHeight);
          
    
          [DllImport("HIPCam_SDK.dll")]
          public static extern int HOEM_Cam_Set2WayAudio(int hCam, bool bEnable);

    

            [DllImport("HIPCam_SDK.dll")]
          public static extern int HOEM_Cam_AudioIn_Init(int hCam, ref WAVEFORMATEX pwfSrc);


          [DllImport("HIPCam_SDK.dll")]
          public static extern int HOEM_Cam_SendAudioIn(int hCam, string  pAudioData, int iLenData);


          [DllImport("HIPCam_SDK.dll")]
          public static extern int HOEM_Cam_AudioIn_Deinit(int  hCam);
               
    }
}