﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.InteropServices;

using COLORREF = System.UInt32;
using DWORD = System.UInt32;
using ULONG = System.UInt32;
using WORD = System.UInt16;

namespace TestByCSharp
{   
    [StructLayout(LayoutKind.Sequential)]
    public  struct FILETIME 
    {
        public DWORD dwLowDateTime;
        public DWORD dwHighDateTime; 
    };
         
    public  struct SYSTEMTIME 
    {
        public WORD wYear;
        public WORD wMonth;
        public WORD wDayOfWeek;
        public WORD wDay;
        public WORD wHour;
        public WORD wMinute;
        public WORD wSecond;
        public WORD wMilliseconds;
    } ;
 
   public  struct HFrame
    {
        public int iFrameType;
        public int iDataLen;
        public IntPtr cFrameData;
        public FILETIME ftFrameTime;
    };

    public struct HVideo_Info
    {   
        // System information
        public ULONG uSystemType;
        // Video information
        public ULONG uVideoType;/**
					   0 : JPEG
					   4 : MPEG4
					   5 : H264
					   **/
        public int iWidth;
        public int iHeight;
        public double dFrameRate;

        // Audio information
        public int iAudioType;
        public int iAudioChannel;
        public int iAudioSampleRate;
        public int iAudioBitRate;
        public int iAudioFrameSize;
    };

    enum HDecode_Type { HDTYPE_RGB32, HDTYPE_YUV422 };

    //HWND  變為   int 
    class HomePlay
    {           
        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_GetMaxChannel();

        [DllImport("HPlay_SDK.dll")]
        public static extern void HOEM_Play_Init();
        
        [DllImport("HPlay_SDK.dll")]
        public static extern void HOEM_Play_Deinit();

        [DllImport("HPlay_SDK.dll")]
        public static extern void HOEM_Play_SetUseOverlay(bool bUseOverlay, COLORREF ColorRef);

        [DllImport("HPlay_SDK.dll")]
        public static extern void HOEM_Play_CreatePlayer();
       
        [DllImport("HPlay_SDK.dll")]
        public static extern void HOEM_Play_DestoryPlayer();

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_SetPlayWindow(IntPtr  hwnd, int iCh, int iWidth, int iHeight);
        
        [DllImport("HPlay_SDK.dll")]
        public static extern  int HOEM_Play_ReleasePlayWindow(int iCh);

        //mike take care
        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_PushPlayFrame(int hwnd, int iCh, ref HFrame pFrame);

        [DllImport("HPlay_SDK.dll")]
        public static extern void HOEM_Play_Play(int iCh);

        [DllImport("HPlay_SDK.dll")]
        public static extern void HOEM_Play_Stop(int iCh);

        [DllImport("HPlay_SDK.dll")]
        public static extern void HOEM_Play_Pause(int iCh);

        [DllImport("HPlay_SDK.dll")]
        public static extern void HOEM_Play_Step(int iCh);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_GetMPEG4Frame(int iCh, out HFrame pFrame);


        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_SetWindowSize(int iCh, int iWidth, int iHeight);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_GetBufSize(int iCh);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_SetBufSize(int iCh, int iSize);

        [DllImport("HPlay_SDK.dll")]
        public static extern bool HOEM_Play_GetPlayAudio(int iCh);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_SetPlayAudio(int iCh, bool bPlay);


        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_SnapShot_BMP(int iCh, string  sName, int iNameLength);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_SnapShot_JPG(int iCh, string sName, int iNameLength);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_GetPlayTime(int iCh, ref SYSTEMTIME stPlayTime);

        [DllImport("HPlay_SDK.dll")]
        unsafe public static extern  int HOEM_Play_GetDecodeFrame(HDecode_Type DT,
                                              int iCh,
                                              HFrame** FrameList,
                                              int iListSize,
                                              out char* pBuf,
                                              out ULONG lWidth,
                                              out ULONG lHeight,
                                              out SYSTEMTIME stTime);


        [DllImport("HPlay_SDK.dll")]
        public static extern unsafe int HOEM_Play_GetDecodeFrame_264(HDecode_Type DT,
                                              int iCh,
                                              ref HFrame* FrameList,
                                              int iListSize,
                                              ref string pBuf,
                                              ref ULONG lWidth,
                                              ref ULONG lHeight,
                                              ref SYSTEMTIME stTime);


        [DllImport("HPlay_SDK.dll")]
        unsafe public static extern bool HOEM_Play_DeleteDecodeFrameData(ref char *pBuf);

        [DllImport("HPlay_SDK.dll")]
        unsafe public static extern int HOEM_Play_SaveToAVI(int iCh, string sPath, int iPathLength,
                                                     ref HFrame* FrameList, int iListSize);

        [DllImport("HPlay_SDK.dll")]
        public static extern bool HOEM_Play_GetIOnly(int iCh);

        [DllImport("HPlay_SDK.dll")]
        public static extern  int HOEM_Play_SetIOnly(int iCh, bool bIOnly);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_SnapShotToMemory_BMP(int iCh,IntPtr  pBuf, ref UInt32 uiBufSize);
                                
        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_AudioConvert_Init(int iCh, HVideo_Info VInfo);

        [DllImport("HPlay_SDK.dll")]
        unsafe public static extern int HOEM_Play_ConvertAudioData(int iCh, 
                                                                   ref HFrame pAudioFrame, 
                                                                   byte[] pBuf);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_AudioConvert_Deinit(int iCh);

        [DllImport("HPlay_SDK.dll")]
        public static extern bool HOEM_Play_GetVideoFlip(int iCh);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_SetVideoFlip(int iCh, bool bFlip);


        [DllImport("HPlay_SDK.dll")]
        public static extern bool HOEM_Play_GetVideoMirror(int iCh);
                        
        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_SetVideoMirror(int iCh, bool bMirror);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_AVI_Open(string pFileName, ref HFrame pSystemFrame);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_AVI_Save(ref HFrame pFrame);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_AVI_Close();




        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_SetOSD(int iCh, string OSD, 
                                                  int PositionX, int PositionY,
									              int CharHeight, bool Bold, 
                                                  bool Italic, 
                                                  int ColorR, int ColorG, 
                                                  int ColorB);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_CloseOSD(int iCh);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_SetFullScreenWindow(int hwnd, int iCh, 
                                                               int iWidth, int iHeight, 
                                                               bool bFull);

        [DllImport("HPlay_SDK.dll")]
        public static extern int HOEM_Play_Set_EncryptKey(int iCh, bool bEnable, string pEncrypt);


    }
}
