using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;
using System.Diagnostics;


using Microsoft.VisualBasic;



namespace CSharpSample
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }        

        private void btnConnect_Click(object sender, EventArgs e)
        {
            axHIPCamX1.IPAddress = tBoxIP.Text;
            axHIPCamX1.Port = Convert.ToInt32(tBoxPort.Text);
            axHIPCamX1.Account = tBoxUser.Text;
            axHIPCamX1.Password = tBoxPassword.Text;
            

            axHIPCamX2.StartPlay();
            axHIPCamX1.ConnectCamera();
            axHIPCamX1.StartReceiveData();            
            axHIPCamX1.StartPlay();            
          
        }
         
        private void btnPlayAudio_Click(object sender, EventArgs e)
        {
            axHIPCamX1.PlayAudio = 1;
        }

        private void btnStopAudio_Click(object sender, EventArgs e)
        {
            axHIPCamX1.PlayAudio = 0;
        }

        private void btnStopRecv_Click(object sender, EventArgs e)
        {
            axHIPCamX1.PauseReceiveData();          
        }

        private void btnFlip_Click(object sender, EventArgs e)
        {

            if (axHIPCamX1.VideoFlip == 0)
            {
                axHIPCamX1.VideoFlip = 1;
            }
            else
            {
                axHIPCamX1.VideoFlip = 0;
            }
        }

        private void tBoxMirror_Click(object sender, EventArgs e)
        {
            if (axHIPCamX1.VideoMirror == 0)
            {
                axHIPCamX1.VideoMirror = 1;
            }
            else
            {
                axHIPCamX1.VideoMirror = 0;
            }
        }

        private void tBoxContinueRecv_Click(object sender, EventArgs e)
        {
            axHIPCamX1.ContinueReceiveData();
        }

        private void tBox2WayOn_Click(object sender, EventArgs e)
        {
            axHIPCamX1.Set2WayAudioON();
        }

        private void tBox2WayOff_Click(object sender, EventArgs e)
        {
            axHIPCamX1.Set2WayAudioOFF();            
        }

        private void btnExeCGI_Click(object sender, EventArgs e)
        {
            axHIPCamX1.ExecuteCGIByBSTR(tBoxCGI.Text,
                                        tBoxCGI.Text.Length);
        }

        private byte[] convertArray(int[] array)
        {
            byte[] newarray = new byte[array.Length * 4];

            for (int i = 0; i < array.Length; i++)
            {
                int j = 4 * i;
                newarray[j] = (byte)(array[i] & 0xFF);
                newarray[j + 1] = (byte)(array[i] >> 8 & 0xFF);
                newarray[j + 2] = (byte)(array[i] >> 16 & 0xFF);
                newarray[j + 3] = (byte)(array[i] >> 24 & 0xFF);
            }
            return newarray;
        }

        private void btnSetOSD_Click(object sender, EventArgs e)
        {
            axHIPCamX1.OSDString = tBoxOSD.Text;
        }

        private void btnSetPosition_Click(object sender, EventArgs e)
        {
            axHIPCamX1.OSDPosX = Convert.ToInt32(tBoxX.Text);
            axHIPCamX1.OSDPosY = Convert.ToInt32(tBoxY.Text);
        }

        private void btnSetHeight_Click(object sender, EventArgs e)
        {
            axHIPCamX1.OSDHeight = Convert.ToInt32(tBoxHeight.Text);
        }

        private void btnSetColor_Click(object sender, EventArgs e)
        {
            axHIPCamX1.OSDColorR =  Convert.ToInt32(tBoxR.Text);
            axHIPCamX1.OSDColorG =  Convert.ToInt32(tBoxG.Text);
            axHIPCamX1.OSDColorB =  Convert.ToInt32(tBoxB.Text);            
        }

        private void btnShowOSD_Click(object sender, EventArgs e)
        {
            axHIPCamX1.OSDShow();
        }

        private void btnCloseOSD_Click(object sender, EventArgs e)
        {
            axHIPCamX1.OSDClose();
        }

        private void btnEnableEncrypt_Click(object sender, EventArgs e)
        {

            axHIPCamX1.EnableEncrypt(tBoxEncrypt.Text);
        }

        private void btnDisableEncrypt_Click(object sender, EventArgs e)
        {
            axHIPCamX1.DisableEncrypt();
        }

        private void btnSetTime_Click(object sender, EventArgs e)
        {               
            axHIPCamX2.TimeTextX = Convert.ToInt16(tBoxTimeLeft.Text);
            axHIPCamX2.TimeTextY = Convert.ToInt16(tBoxTimeTop.Text);
            axHIPCamX1.TimeTextFontHeight = Convert.ToInt16(tBoxTimeFontH.Text);
        }

        private void btnSetTitle_Click(object sender, EventArgs e)
        {
            axHIPCamX2.TitleTextX = Convert.ToInt16(tBoxTitleLeft.Text);
            axHIPCamX2.TitleTextY = Convert.ToInt16(tBoxTitleTop.Text);
            axHIPCamX1.TitleTextFontHeight = Convert.ToInt16(tBoxTitleFontH.Text);
        }

        private void btnSetFullTime_Click(object sender, EventArgs e)
        {

            axHIPCamX2.FullTimeTextX = Convert.ToInt16(tBoxFTimeLeft.Text);
            axHIPCamX2.FullTimeTextY = Convert.ToInt16(tBoxFTimeTop.Text);
            axHIPCamX1.FullTimeTextFontHeight = Convert.ToInt16(tBoxFTimeFontH.Text);
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            axHIPCamX1.InitCamera();          
            axHIPCamX2.InitCamera();

        }

        private void FormClose(object sender, FormClosedEventArgs e)
        {
            //Deinit();     
        
        }

        //static int icount = 0;


        private delegate void SetPushPlayBackFrame(AxHIPCAMXLib._DHIPCamXEvents_OnFrameComingByBSTREvent e);



        private void PushPlayBackFrame(AxHIPCAMXLib._DHIPCamXEvents_OnFrameComingByBSTREvent e)
        {

            axHIPCamX2.PushPlayBackFrameByBSTR(e.frameType, e.dataLength,

                                             ref e.dataBSTR, e.highDateTime,

                                             e.lowDateTime, e.spareParts);

        }



        private void OnFrameComingByBSTRCamX1(object sender, AxHIPCAMXLib._DHIPCamXEvents_OnFrameComingByBSTREvent e)
        {

            Debug.WriteLine("OnFrameComingByBSTRCamX1 Entry\n");

            this.BeginInvoke(new SetPushPlayBackFrame(PushPlayBackFrame), new object[] { e });

            Debug.WriteLine("OnFrameComingByBSTRCamX1 Out\n");

        }

        //private void OnFrameComingByBSTRCamX1(object sender, AxHIPCAMXLib._DHIPCamXEvents_OnFrameComingByBSTREvent e)
        //{
        //    if (icount++ < 10)
        //    {
        //        Debug.WriteLine("OnFrameComingByBSTRCamX1 Entry\n");

        //        axHIPCamX2.PushPlayBackFrameByBSTR(e.frameType, e.dataLength,
        //                                   ref e.dataBSTR, e.highDateTime,
        //                                   e.lowDateTime, e.spareParts);

        //        //axHIPCamX2.PausePlay();

        //        Debug.WriteLine("OnFrameComingByBSTRCamX1 Out\n");
        //    }
        //    else
        //    {
        //        int a = 1;
        //    }
        //}

        private void OnGetTypeChannelCamX1(object sender, AxHIPCAMXLib._DHIPCamXEvents_OnGetTypeChannelEvent e)
        {
            tBoxType.Text = e.deviceType.ToString();
            tBoxVideoCH.Text = e.vChannels.ToString();
            tBoxAudioCH.Text = e.aChannels.ToString();            
        }

        private void OnExecuteCGIByBSTR(object sender, AxHIPCAMXLib._DHIPCamXEvents_OnExecuteCGIByBSTREvent e)
        {
            System.Text.Encoding ansi = System.Text.Encoding.ASCII ;
            System.Text.Encoding unicode = System.Text.Encoding.Unicode;

            byte[] ansibytes = unicode.GetBytes(e.returnStr);
            byte[] unicodebytes = System.Text.Encoding.Convert(ansi, unicode, ansibytes);

            char[] unicodechars = new char[unicode.GetCharCount(unicodebytes, 0, unicodebytes.Length)];
            unicode.GetChars(unicodebytes, 0, unicodebytes.Length, unicodechars, 0);
            tBoxCGIReturn.Text = new string(unicodechars);
     
        }

          private void Deinit()
        {                        
            //axHIPCamX2.DisconnectCamera();            
            axHIPCamX2.DeinitCamera();
            axHIPCamX1.DeinitCamera();
            //axHIPCamX1.DisconnectCamera();
                       
        }

        private void FormClosing2(object sender, FormClosingEventArgs e)
        {
        }

        
        protected override void OnClosing(System.ComponentModel.CancelEventArgs e)
        {

            //[boլݬ......

            Deinit();
            

            base.OnClosing(e);

        }

    }
}


