#ifndef __HOEM_DEVICESEEKER_API_H
#define __HOEM_DEVICESEEKER_API_H

#include "HDEVICE_DEFINE.H"


#ifndef _WIN32_WCE
	#ifdef HOEMDEVICESEEKER_EXPORTS
		#define HOEM_DEVICESEEKER_API extern "C" __declspec(dllexport)
	#else
		#define HOEM_DEVICESEEKER_API extern "C" __declspec(dllimport)
	#endif
#else
	#define DEVICESEEKER_API extern "C"
#endif


/**
 *  Comment : Initial DLL
 */
HOEM_DEVICESEEKER_API void HOEM_Seeker_Init();

/**
 *  Comment : Deinitial DLL
 */
HOEM_DEVICESEEKER_API void HOEM_Seeker_Deinit();

/**
 *  Comment : Search Device
 *  Return Value :
 *  TRUE            successful
 *  FALSE           failed
 *	Parameter :
 *	iTimeOut		TimeOut
 */
HOEM_DEVICESEEKER_API bool HOEM_Seeker_Search(int iTimeOut);

/**
 *  Comment : Get Total Search Device Number
 *  Return Value :
 *	int				Total Number
 */
HOEM_DEVICESEEKER_API int HOEM_Seeker_GetCounts();

/**
 *  Comment : Get Specific Server's MacAddress in String Format
 *  Return Value :
 *	TRUE			successful
 *	FALSE			failed
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 *	cBuf			char array pointer to get Mac String(ex. 00-03-02-03-45-21)
 */
HOEM_DEVICESEEKER_API bool HOEM_Seeker_GetMacString(int iID, char* cBuf);


/**
 *  Comment : Get Specific Server's IPAddress in String Format
 *  Return Value :
 *	TRUE			successful
 *	FALSE			failed
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 *	cBuf			char array pointer to get IP String(ex. "192.168.1.111")
 */
HOEM_DEVICESEEKER_API bool HOEM_Seeker_GetIPString(int iID, char* cBuf);

/**
 *  Comment : Get Specific Server's IPAddress in Raw Value Format
 *  Return Value :
 *	unsigned long	IPAddress in Raw Value Format
					if got 4060195008, IP Address is C0.A8.01.F2 = 192.168.1.242
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 */
HOEM_DEVICESEEKER_API unsigned long HOEM_Seeker_GetIPValue(int iID);

/**
 *  Comment : Get Specific Server's HTTP Port
 *  Return Value :
 *	unsigned long	Port
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 */
HOEM_DEVICESEEKER_API unsigned long HOEM_Seeker_GetPort(int iID);

/**
 *  Comment : Get Specific Server's GateWay in String Format
 *  Return Value :
 *	TRUE			successful
 *	FALSE			failed
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 *	cBuf			char array pointer to get GateWay String(ex. "192.168.1.254")
 */
HOEM_DEVICESEEKER_API bool HOEM_Seeker_GetGateWayString(int iID, char* cBuf);

/**
 *  Comment : Get Specific Server's GateWay in Raw Value Format
 *  Return Value :
 *	unsigned long	GateWay in Raw Value Format
					if got 4060195008, GateWay is C0.A8.01.FE = 192.168.1.254
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 */
HOEM_DEVICESEEKER_API unsigned long HOEM_Seeker_GetGateWayValue(int iID);

/**
 *  Comment : Get Specific Server's NetMask in String Format
 *  Return Value :
 *	TRUE			successful
 *	FALSE			failed
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 *	cBuf			char array pointer to get NetMask String(ex. "255.255.255.0")
 */
HOEM_DEVICESEEKER_API bool HOEM_Seeker_GetNetMaskString(int iID, char* cBuf);

/**
 *  Comment : Get Specific Server's NetMask in Raw Value Format
 *  Return Value :
 *	unsigned long	NetMask in Raw Value Format
					if got 16777215, NetMask is FF.FF.FF.0 = 255.255.255.0
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 */
HOEM_DEVICESEEKER_API unsigned long HOEM_Seeker_GetNetMaskValue(int iID);

/**
 *  Comment : Get Specific Server's Name
 *  Return Value :
 *	TRUE			successful
 *	FALSE			failed
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 *	cBuf			char array pointer to get Name String(ex. "IPCam")
 */
HOEM_DEVICESEEKER_API bool HOEM_Seeker_GetName(int iID, char* cBuf);

/**
 *  Comment : Get Specific Server's DNS1 in String Format
 *  Return Value :
 *	TRUE			successful
 *	FALSE			failed
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 *	cBuf			char array pointer to get DNS1 String(ex. "168.95.1.1")
 */
HOEM_DEVICESEEKER_API bool HOEM_Seeker_GetDNS1String(int iID, char* cBuf);

/**
 *  Comment : Get Specific Server's DNS1 in Raw Value Format
 *  Return Value :
 *	unsigned long	DNS1 in Raw Value Format
					if got 16867240, DNS1 is A8.5F.01.01 = 168.95.1.1
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 */
HOEM_DEVICESEEKER_API unsigned long HOEM_Seeker_GetDNS1Value(int iID);

/**
 *  Comment : Get Specific Server's DNS2 in String Format
 *  Return Value :
 *	TRUE			successful
 *	FALSE			failed
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 *	cBuf			char array pointer to get DNS2 String(ex. "168.95.192.1")
 */
HOEM_DEVICESEEKER_API bool HOEM_Seeker_GetDNS2String(int iID, char* cBuf);

/**
 *  Comment : Get Specific Server's DNS2 in Raw Value Format
 *  Return Value :
 *	unsigned long	DNS2 in Raw Value Format
					if got 29384616, DNS2 is A8.5F.C0.01 = 168.95.192.1
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 */
HOEM_DEVICESEEKER_API unsigned long HOEM_Seeker_GetDNS2Value(int iID);

/**
 *  Comment : Get Specific Server's IP Generate Method
 *  Return Value :
 *	long			1 : DHCP(Automatic Generate IP)
 *					0 : Static IP		
 *					-1 : Access Failed			
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 */
HOEM_DEVICESEEKER_API long HOEM_Seeker_GetDHCP(int iID);

/**
 *  Comment : Set Specific Server Config
 *  Return Value :
 *	long			1 : Success
 *					0 : Failed
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 *	sInfo			Set_Device_Info Device Config
 */
HOEM_DEVICESEEKER_API long HOEM_Seeker_Set(int iID, Set_Device_Info sInfo);

/**
 *  Comment : Get Specific Server Type
 *  Return Value :
 *	long			Server Type
 *	Parameter :
 *	iID				Server ID(from 0 ~ Total Number - 1)
 */
HOEM_DEVICESEEKER_API long HOEM_Seeker_GetType(int iID);


HOEM_DEVICESEEKER_API bool HOEM_Seeker_GetVersion(int iID, char* cBuf);

HOEM_DEVICESEEKER_API bool HOEM_Seeker_GetBrand(int iID, char* cBuf);

HOEM_DEVICESEEKER_API bool HOEM_Seeker_GetModeName(int iID, char* cBuf);

HOEM_DEVICESEEKER_API bool HOEM_Seeker_GetCameraName1(int iID, char* cBuf);

HOEM_DEVICESEEKER_API bool HOEM_Seeker_GetDevice(int iID, char* cBuf);
#endif