//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include "Unit1.h"        
#include <string>
#include <jpeg.hpp>
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
    : TForm(Owner)
{
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormCreate(TObject *Sender)
{
    HOEM_Play_Init();
    COLORREF cr = RGB(0x100,0x100,0x100);
    Panel1->Color = cr;
	HOEM_Play_SetUseOverlay(false,cr);
    HOEM_Play_CreatePlayer();
    int iRes = HOEM_Cam_Init();
    m_pSystemFrame = NULL;
    if(m_pSystemFrame != NULL)
    {
        delete m_pSystemFrame->cFrameData;
        delete m_pSystemFrame;
        m_pSystemFrame = NULL;
    }
    
    m_bSaveAVI = false;

    m_bPushDecodeList = true;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::FormDestroy(TObject *Sender)
{
    while(m_DecodeList.size())
    {
        delete [] m_DecodeList.front()->cFrameData;
        delete m_DecodeList.front();
        m_DecodeList.pop_front();
    }

    HOEM_Cam_Deinit();
    HOEM_Play_ReleasePlayWindow(0);
    HOEM_Play_DestoryPlayer();
    HOEM_Play_Deinit();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button1Click(TObject *Sender)
{
    HOEM_Play_SetPlayWindow(Panel1->Handle, 0, Panel1->Width, Panel1->Height);
    Connect_Info cInfo;
    AnsiString sIP,sUser,sPass;
    int iPort;
    sIP = Edit4->Text;
    sUser = Edit6->Text;
    sPass = Edit7->Text;
    iPort = Edit5->Text.ToInt();
    cInfo.sIP = sIP.c_str();
    cInfo.iPort = iPort;
    cInfo.sUser = sUser.c_str();
    cInfo.sPass = sPass.c_str();
    cInfo.iCh = 0;

    int iRes = HOEM_Cam_Create(&hCam, cInfo, Eventback, (int)this);
    iRes = HOEM_Cam_Connect(hCam, FrameCallback, (int)this, HIPCam_VIDEO);
    iRes = HOEM_Cam_Connect(hCam, FrameCallback, (int)this, HIPCam_AUDIO);
    iRes = HOEM_Cam_StartReceive(hCam, HIPCam_VIDEO);                     
    iRes = HOEM_Cam_StartReceive(hCam, HIPCam_AUDIO);
}
//---------------------------------------------------------------------------

int CALLBACK TForm1::FrameCallback(int iContext, unsigned char ucChannel, HFrame *pFrame, HVideo_Info VInfo)
{                                 
    TForm1 *pForm = (TForm1*)iContext;

    pForm->m_vInfo = VInfo;

    HOEM_Play_PushPlayFrame(pForm->Panel1->Handle, 0, pFrame);

    int iCh = ucChannel;

	static int iCount = 0, iACount = 0;

    if(pFrame->iFrameType == 7)
    {
        if(pForm->m_pSystemFrame != NULL)
        {
            delete [] pForm->m_pSystemFrame->cFrameData;
            delete pForm->m_pSystemFrame;
            pForm->m_pSystemFrame = NULL;
        }
        pForm->m_pSystemFrame = new HFrame;
        memcpy(pForm->m_pSystemFrame, pFrame, sizeof(HFrame));
        pForm->m_pSystemFrame->cFrameData = new char[pFrame->iDataLen];
        memcpy(pForm->m_pSystemFrame->cFrameData, pFrame->cFrameData, pFrame->iDataLen);
    }

    static int iDecodeList = 0;
    if(pForm->m_bPushDecodeList)
    {
        if(pFrame->iFrameType == 2 || pFrame->iFrameType == 3 || pFrame->iFrameType == 4)
        {
             if(++iDecodeList<4)
             {
                HFrame *pcpFrame = new HFrame;
                pcpFrame->iFrameType = pFrame->iFrameType;
                pcpFrame->iDataLen = pFrame->iDataLen;
                pcpFrame->ftFrameTime = pFrame->ftFrameTime;
                pcpFrame->cFrameData = new char[pFrame->iDataLen];
                memcpy(pcpFrame->cFrameData,pFrame->cFrameData,pFrame->iDataLen);
                pForm->m_DecodeList.push_back(pcpFrame);
             }
             else
                pForm->m_bPushDecodeList = false;
        }
    }

    if(pForm->m_bSaveAVI)
    {
        HOEM_Play_AVI_Save(pFrame);
    }
}

int CALLBACK TForm1::Eventback(int iContext, HANDLE hCam, unsigned char ucChannel, int iEventNum)
{
}
void __fastcall TForm1::Button2Click(TObject *Sender)
{
    std::string strName = "TestBMP.bmp";
    HOEM_Play_SnapShot_BMP(0,(char*)strName.c_str(),strName.length());
    Image1->Stretch = true;
    Image1->Picture->LoadFromFile("TestBMP.bmp");

}
//---------------------------------------------------------------------------

void __fastcall TForm1::Timer1Timer(TObject *Sender)
{
    SYSTEMTIME stPlayTime;
    int iRes = HOEM_Play_GetPlayTime(0,stPlayTime);
    AnsiString strTime;
    if(iRes != PLAY_CHANNEL_ER)
        strTime = FormatDateTime("yymmdd-hh:nn:ss",SystemTimeToDateTime(stPlayTime));
    Label1->Caption = strTime;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button3Click(TObject *Sender)
{
    HFrame *pSysFrame;
    pSysFrame = HOEM_Cam_AskSystemFrame(hCam);
    if(pSysFrame != NULL)
    {
        if(pSysFrame->iDataLen == m_pSystemFrame->iDataLen)
        {
            if(memcmp(pSysFrame->cFrameData, m_pSystemFrame->cFrameData,pSysFrame->iDataLen) == 0)
            {
                ShowMessage("System Frame Test OK");
            }
        }
        HOEM_Cam_DeleteFrame(pSysFrame);
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button4Click(TObject *Sender)
{
    HVideo_Config vConfig;
    bool bRes;
    bRes = HOEM_Cam_GetVideo(hCam, &vConfig);

    int iWidth, iHeight;
    bRes = HOEM_Cam_GetResolutionSet(hCam, vConfig.iResolution, iWidth, iHeight);
    Edit1->Text = iWidth;
    Edit2->Text = iHeight;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button5Click(TObject *Sender)
{
    HVideo_Config hCfg;
    char cBuf[100];
    int iLen = 100;
    bool bRes = HOEM_Cam_Execute_CGI(hCam,"GetMultimedia.cgi",cBuf,iLen);
    HOEM_Cam_PauseReceive(hCam, HIPCam_VIDEO);
    HOEM_Cam_PauseReceive(hCam, HIPCam_AUDIO);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button6Click(TObject *Sender)
{
    HOEM_Cam_ContinueReceive(hCam, HIPCam_VIDEO);
    HOEM_Cam_ContinueReceive(hCam, HIPCam_AUDIO);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button7Click(TObject *Sender)
{                                               
    HOEM_Cam_StartReceive(hCam, HIPCam_VIDEO);
    HOEM_Cam_StartReceive(hCam, HIPCam_AUDIO);
    HOEM_Play_Play(0);
}
//---------------------------------------------------------------------------


void __fastcall TForm1::CheckBox1Click(TObject *Sender)
{
    if(CheckBox1->Checked)
        HOEM_Play_SetPlayAudio(0, true);
    else
        HOEM_Play_SetPlayAudio(0, false);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button8Click(TObject *Sender)
{
    AnsiString sName = "C:\\Test.bmp";

    //Test SnapShotToMemory
    char *cBuf = new char[1280*1024*4+100];
    int iBufSize = 1280*1024*4+100;

    int iRes = HOEM_Play_SnapShotToMemory_BMP(0,cBuf,iBufSize);


    //SaveToFile
    if(iRes > 0)
    {
        HANDLE  hFile;
        LPBYTE  lpbyBmp;
        DWORD   dwBytesWrite, dwTmp;
        SECURITY_ATTRIBUTES sa;

        sa.nLength = sizeof(sa);
        sa.lpSecurityDescriptor = NULL;
        sa.bInheritHandle = TRUE;
        hFile=CreateFile(sName.c_str(), GENERIC_WRITE,
            FILE_SHARE_READ, &sa, CREATE_ALWAYS,FILE_ATTRIBUTE_NORMAL | FILE_FLAG_RANDOM_ACCESS,NULL);

        {	//locks a local memory object and returns a pointer to the first byte of the object's memory block
            if(!WriteFile(hFile, cBuf, iRes, &dwTmp, NULL))
			{
				DWORD dw = GetLastError();
			}
        }
        CloseHandle(hFile);
    }

    delete [] cBuf;    
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button10Click(TObject *Sender)
{
    if(m_pSystemFrame)
    {
        if(HOEM_Play_AVI_Open(Edit3->Text.c_str(),m_pSystemFrame) == PLAY_OPEN_AVI_SUCCESS)
        {
            ShowMessage("Start Save AVI");
            m_bSaveAVI = true;
        }
        else
        {
            ShowMessage("Can not Save AVI");
            m_bSaveAVI = false;
        }
    }
    else
    {
        ShowMessage("No System Frame");
        m_bSaveAVI = false;
    }
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button11Click(TObject *Sender)
{
    m_bSaveAVI = false;
    HOEM_Play_AVI_Close();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button9Click(TObject *Sender)
{
    HOEM_Cam_Set2WayAudio(hCam,true);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button12Click(TObject *Sender)
{
    HOEM_Cam_Set2WayAudio(hCam,false);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button13Click(TObject *Sender)
{
    if(m_bPushDecodeList == false && m_DecodeList.size() > 0)
    {
        //Ch1 Get Decode Frame Use Type RGB32
		unsigned long lWidth, lHeight;
		SYSTEMTIME stTime;

		HFrame **FrameList = new HFrame*[m_DecodeList.size()];
		std::list<HFrame*>::iterator pos = m_DecodeList.begin();
		int i=0;
		for(pos;pos!=m_DecodeList.end();++pos)
		{
			FrameList[i++] = *pos;
		}

		char *pBuf;
        int iRet = 0;
        if(m_vInfo.uVideoType == 4) //MPEG4
		    iRet = HOEM_Play_GetDecodeFrame(HDTYPE_RGB32,0,FrameList,m_DecodeList.size(),&pBuf,lWidth,lHeight,stTime);
        else if(m_vInfo.uVideoType == 5)    //H264
		    iRet = HOEM_Play_GetDecodeFrame_264(HDTYPE_RGB32,0,FrameList,m_DecodeList.size(),&pBuf,lWidth,lHeight,stTime);

        if(iRet > 0)
        {
            //Save to Bitmap
            BITMAPFILEHEADER BitmapFileHead;
            BitmapFileHead.bfType      = 0x4d42;
            BitmapFileHead.bfSize      = lWidth*lHeight*4+sizeof(BITMAPFILEHEADER)+sizeof(BITMAPINFOHEADER);
            BitmapFileHead.bfReserved1 = 0;
            BitmapFileHead.bfReserved2 = 0;
            BitmapFileHead.bfOffBits   = 54;

            BITMAPINFOHEADER BitmapHead;
            BitmapHead.biSize          = sizeof(BITMAPINFOHEADER);
            BitmapHead.biWidth         = lWidth;
            BitmapHead.biHeight        = lHeight;
            BitmapHead.biPlanes        = 1;
            BitmapHead.biBitCount      = 32;
            BitmapHead.biCompression   = BI_RGB;
            BitmapHead.biSizeImage     = 0;
            BitmapHead.biXPelsPerMeter = 1;
            BitmapHead.biYPelsPerMeter = 1;
            BitmapHead.biClrUsed       = 0;
            BitmapHead.biClrImportant  = 0;

            TMemoryStream *pStream = new TMemoryStream;
            pStream->Write((char*)&BitmapFileHead.bfType,2);
            pStream->Write((char*)&BitmapFileHead.bfSize,4);
            pStream->Write((char*)&BitmapFileHead.bfReserved1,2);
            pStream->Write((char*)&BitmapFileHead.bfReserved2,2);
            pStream->Write((char*)&BitmapFileHead.bfOffBits,4);
            pStream->Write((char*)&BitmapHead,sizeof(BITMAPINFOHEADER));
            int iWidthLen = lWidth * 4;
            for(int y=(lHeight-1)*lWidth*4;y>=0;y-=iWidthLen)
                pStream->Write(pBuf+y, iWidthLen);
            pStream->Seek((__int64)0, soBeginning);

            Graphics::TBitmap *pBitmap = new Graphics::TBitmap;
            pBitmap->LoadFromStream(pStream);
            delete pStream;
            SaveDialog1->Filter = "BMP files (*.bmp)";
            SaveDialog1->FileName = "Test.bmp";
            if(SaveDialog1->Execute()==IDOK)
                pBitmap->SaveToFile(SaveDialog1->FileName);

            TJPEGImage* jpeg = new TJPEGImage;
            jpeg->Assign(pBitmap);
            delete pBitmap;
            jpeg->CompressionQuality = 80;                 //]w JPEG Y~
            SaveDialog1->Filter = "JPG files (*.jpg)";
            SaveDialog1->FileName = "Test.jpg";
            if(SaveDialog1->Execute()==IDOK)
                jpeg->SaveToFile(SaveDialog1->FileName);
            delete jpeg;
        }

        if(pBuf)
		    HOEM_Play_DeleteDecodeFrameData(&pBuf);
    }
    else
    {
        ShowMessage("You can't decode frame now.");
    }
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button14Click(TObject *Sender)
{
    bool bBold = (RadioGroup1->ItemIndex == 0)?true:false;
    bool bItalic = (RadioGroup2->ItemIndex == 0)?true:false;
    HOEM_Play_SetOSD(0,Edit8->Text.c_str(),Edit9->Text.ToInt(),Edit10->Text.ToInt(),Edit11->Text.ToInt(),bBold,bItalic,Edit12->Text.ToInt(),Edit13->Text.ToInt(),Edit14->Text.ToInt());
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button15Click(TObject *Sender)
{
    HOEM_Play_CloseOSD(0);
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Button16Click(TObject *Sender)
{
    HOEM_Play_Set_EncryptKey(0,true,Edit15->Text.c_str());    
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Button17Click(TObject *Sender)
{
    HOEM_Play_Set_EncryptKey(0,false);    
}
//---------------------------------------------------------------------------

