<?php
//
// Purpose:
// 
// Pulls images from real-time source or optionally from a optionally saved prior image on disk, saved from that source. Based on age in
// seconds of the disk image or source unavailability. Displays and or optionally saves images to disk with added date time and or text and
// or custom text lines and/or custom logos or images added to the cameras images. Without showing where the actual source of the image came
// from or any information that was required to get the image from that source. Allowing images received in real-time to be resized based on
// a percentage of the original image received. In order to keep the aspect ratio of the original real-time image received. Also a back-end for
// secure automatic real-time image refreshing. Both HTTP and HTTPS access methods are supported to pull images.
//
// If the last image is not being saved to disk and no custom text, no image resizing and no logo is used. Curl is used to get the image
// otherwise php GD methods are used to get the image. php Curl methods are much faster then php GD methods.
//
// Defaults: Date Time on. Text After Date is present. Custom Text on. Save images to disk on. Image on disk must be 0 seconds or older
//           before real-time image is pulled from source. Date and Custom text font sizes are set for 160x120 resolution images.
//           Resize percentage is 100 percent so no resizing is done .50 = fifty percent, .25 = twenty five percent and so on. 
//           Best quality for resizing is on. Date format is North American format. Show Logo is false.
//
// Note: You may need to allow non-standard outbound ports to be opened for this to work. Some Hosting services will do this on
//       request on a port by port basis. If you are not running your own server or your Hosting service refuses to do this.
//       You can change your IP Camera, as an example, to port 80 for testing to get around not being able to open
//       non-standard outbound ports if needed. You will need to change your port forwarding setup to use port 80 as well
//       so that you can use the DDNS or ISP IP Address and port 80 to access your IP Camera using these methods.
//       If your web server is NOT running in your local network you cannot use the local IP Address and port for your camera.
//       You must use a DDNS or ISP IP Address and port for your camera to use this remotely.
//
//       If you intend to use this copy of the Interface to provide the last image stored on disk when the IP Camera is not online or is
//       unavailable. The timeout for waiting for a real-time image request for your IP Camera before then getting the last image from disk
//       when or if that happens. Is based on "default_socket_timeout". Which is located in the php.ini file on the web server. The default
//       time of default_socket_timeout is 60 seconds. If you wish to shorten this timeout value. Many Web Hosting companies set it to 10
//       seconds. Which is a more reasonable timeout value for how long to wait for a connection request to complete, before timing it out.
//
//       For initial testing. You should use this script directly from a browser window as:
//       http://YourDomainName.com/FolderWhereThisScriptIs/SecureImageDisplay.php
//
//       This is because there are some helpful debugging techniques used here for initial setup. That will display error messages
//       if things are not setup correctly. That you could not see if you were to use this script in IMG tags.
//
error_reporting(E_ALL);                // Comment out after debugging. Helps isolate any errors in your error.log for initial setup.
ini_set('display_errors', '1');        // Comment out after debugging. Helps isolate any errors in your error.log for initial setup.
#ini_set("gd.jpeg_ignore_warning", 0); // Uncomment if your IP Camera generates bad .jpg format in your error logs.
//
// You must first edit the files below before uncommenting one of them. You CANNOT uncomment both of them.
// They allow you to restrict access to SecureImageDisplay.php from being accessed from anything else but what they say.
// This allows you to protect SecureImageDisplay.php from being referenced. Unless it's being referenced by one of the below.
#include("RestrictToSecureImageDisplayLogin.php");
#include("RestrictToSecureImageDisplayHtm.php");
//
// $ipcam_url = Must be changed to be the real-time image source leaving '&cnt=".microtime(true);' at end of the line.
// Examples:
//
// MJPEG  = "http://DDNSorISPIPAddress:PortForCamera/snapshot.cgi?user=admin&pwd=YourPassword&cnt=".microtime(true);
// H.264  = "http://DDNSorISPIPAddress:PortForCamera/CGIProxy.fcgi?cmd=snapPicture2&usr=admin&pwd=YourPassword&cnt=".microtime(true);
//
// **** $ipcam_url below. MUST be changed to equal your IP Camera using the above syntax for your IP Camera type ***
$ipcam_url = "http://admin:123456@lan.merx.pl/cgi-bin/net_jpeg.cgi?ch=0&cnt=".microtime(true);
//
// *** Important To Read Carefully ***
#include("CheckForBlockedPorts.php");  // MUST be uncommented ("Remove Leading #") To see if your server allows the cameras port to be opened.
//$no_save_to_disk = true;              // If false then source images received in real-time are also stored on disk.
$no_save_to_disk = false;              // If false then source images received in real-time are also stored on disk.
                                       // If "$no_save_to_disk = true" then if your image source is offline or not available
                                       // then there will be no image to pull from disk when or if that happens. Leaving an empty image.
                                       // Whereas if "$no_save_to_disk = false" when or if your image source is offline or not available
                                       // then the last image stored on disk will be displayed, avoiding displaying an empty image.
                                       //
                                       // Multiple real-time image sources example:
                                       // If you are going to use multiple copies of this for multiple IP Cameras that will be storing
                                       // images on disk. Then you should copy an empty copy of ipcam1.jpg to another .jpg filename and
                                       // change $last_image_name below to point to the correct .jpg file for each IP Camera that will be 
                                       // storing images on disk. Of course you can also access the .jpg file directly as a image source.
                                       // If needed. Once an image from the real-time source like a IP Camera, has been stored there.
                                       //
$last_image_name = "ipcam6.jpg";       // This file MUST be present in this same folder if "$no_save_to_disk = false".
                                       //
$show_logo = true;                    // Must be set to true if logo .png file below is to be merged with cameras image. Otherwise should be false.
//$show_logo = false;                    // Must be set to true if logo .png file below is to be merged with cameras image. Otherwise should be false.
$logo_name = "merx-logo-TV_overlay_2.png";                       // Must be .png file for logo image. If = "" no logo will be merged with the cameras image.
$logox = 10;                            // x position in cameras image for logo.
$logoy = 10;                            // y position in cameras image for logo.
                                       //
$seconds_creation = 0;                 // If images age on disk is less than this value, in seconds. A image on disk will be returned.
                                       // when $no_save_to_disk = false. Until that images age on disk is equal to or older then the
                                       // number of seconds specified for this value.
                                       //
                                       // Note: If you use this copy of the Interface to feed anything that uses this Interface as a
                                       //       back-end for real-time refreshed images. This value must be zero to avoid any race
                                       //       conditions when $no_save_to_disk = false. Otherwise the last image on disk would be
                                       //       fed at a high rate to any front-end making the requests when or if the IP Camera was
                                       //       offline or not available.
                                       //
$resized_percentage = 100;             // Must have a value. If value is > 0 and < .99 percent real-time images will be resized to percent size.
                                       // $resized_width and $resized_height will only be used when $resized_percentage = 0;
$resized_width = 1920;                  // Will always be this width even if or when original image received changes size if $resized_percentage = 0.
$resized_height = 1080;                 // Will always be this height even if or when original image received changes size if $resized_percentage = 0. 
$best_quality = true;                  // There are two methods to do image resize. If true then image will have better quality.
$font_name = "arial.ttf";              // This file MUST be present in this same folder if date or any text is used in the image.
$show_date_time = false;                // If true date will be displayed in image.
//$show_date_time = false;                // If true date will be displayed in image.
$time_offset = -0;                     // Your web server maybe in a different time zone. If so to display your time. +-3600 for each hour difference.
$date_format = "m/d/Y H:i:s";          // Date format can be changed to European format "d/m/Y H:i:s";
$date_font_size = 8;                   // Date Text Font size. Higher number equals larger text.
$text_after_date = " Welcome";         // Text following Date. If "$show_date_time = false" then text will display without Date unless = "";
//$text_after_date = "";         // Text following Date. If "$show_date_time = false" then text will display without Date unless = "";
$date_x = 10;                          // Date text x position on image. Will need to be set based on image size.
$date_y = 14;                          // Date text y position on image. Will need to be set based on image size.
//$show_custom_text = true;              // If "$show_custom_text = true" then $custom_text will be displayed on image. 
$show_custom_text = false;              // If "$show_custom_text = true" then $custom_text will be displayed on image. 
$custom_font_size = 15;                // Custom Text Font size. Higher number equals larger text.
$custom_text = "Hello world! MERX Demo Camera";          // If "$show_custom_text = true" then this text will be displayed on image on custom text line.
$custom_x = 8;                         // Custom x position on image. Will need to be set based on image size.
$custom_y = 116;                       // Custom y position on image. Will need to be set based on image size.
// **************************************
// Please do NOT change anything below  *
// **************************************
if (!$no_save_to_disk) {
    $filename = realpath($last_image_name);
    $time_img = filemtime($filename);
    if ((empty($filename)) || (empty($time_img))) {
         print "jpg image file is missing from disk";
         die();
    }
}
$time_now = time();
if ((($no_save_to_disk) || ($seconds_creation == 0)) || (filesize($filename) <= 0 || ($time_now - $time_img) > $seconds_creation)) {
      if (($no_save_to_disk) && ($resized_percentage == 100) && (!$show_date_time) && (!$show_custom_text) && (empty($text_after_date)) && (!$show_logo)) {
           $curl_handle = curl_init();
           curl_setopt($curl_handle, CURLOPT_BINARYTRANSFER, 1);
           curl_setopt($curl_handle, CURLOPT_RETURNTRANSFER, 1);
           curl_setopt($curl_handle, CURLOPT_SSL_VERIFYHOST, 0);
           curl_setopt($curl_handle, CURLOPT_URL, $ipcam_url);
           $my_image = curl_exec($curl_handle);
           curl_close($curl_handle);
           if (empty($my_image))
               print "";
           else {
               header("Content-Type: image/jpeg");
               print $my_image;
           }
      } else {
          if ($show_logo) {
              $valid_logo_file = realpath($logo_name);
              if (empty($valid_logo_file)) {
                  print "Logo file is not defined or missing from disk";
                  die();
              }
              $image = @imagecreatefromjpeg($ipcam_url);
              if ($image !== FALSE) {
                  $src = @imagecreatefrompng($valid_logo_file);
                  if ($src !== FALSE)
                      imagecopyresampled($image, $src, $logox, $logoy, 0, 0, ImageSX($src), ImageSY($src), ImageSX($src), ImageSY($src));
              }
          }
          if ($resized_percentage !== 100) {
              if (!$show_logo)
                  $image = @imagecreatefromjpeg($ipcam_url);
              if ($image !== FALSE) {
                  if ($resized_percentage !== 0) {
                      $resized_width = ImageSX($image) * $resized_percentage;
                      $resized_height = ImageSY($image) * $resized_percentage;
                  }
                  $my_image = imagecreatetruecolor($resized_width, $resized_height);
                  if ($best_quality)
                      imagecopyresampled($my_image, $image, 0, 0, 0, 0, $resized_width, $resized_height, ImageSX($image), ImageSY($image));
                  else
                      imagecopyresized($my_image, $image, 0, 0, 0, 0, $resized_width, $resized_height, ImageSX($image), ImageSY($image));
              } else {
                  if (!$no_save_to_disk) {
                      header("Content-type: image/jpeg");
                      echo file_get_contents($filename);
                  }
                  else
                      print "";
                  die();
              }
          }
          else if ((!$show_logo) && ($resized_percentage == 100)) $my_image = @imagecreatefromjpeg($ipcam_url);
          else
               $my_image = $image;
          if ($my_image !== FALSE) {
              if (($show_date_time) || ($show_custom_text) || (!empty($text_after_date))) {
                   $font = realpath($font_name);
                   if (empty($font)) {
                       print "Font file is missing from disk";
                       die();
                   }
                   $white = imagecolorallocate($my_image, 255, 255, 255);
                   $grey = imagecolorallocate($my_image, 128, 128, 128);
                   $black = imagecolorallocate($my_image, 0, 0, 0);
                   if (($show_date_time) || (!empty($text_after_date))) {
                        if ($show_date_time)
                            $date_text = date($date_format, ($time_now + $time_offset))." ".$text_after_date;
                        else
                            $date_text = $text_after_date;
                        imagettftext($my_image, $date_font_size, 0, $date_x + 1, $date_y + 1, $grey, $font, $date_text);
                        imagettftext($my_image, $date_font_size, 0, $date_x, $date_y, $white, $font, $date_text);
                   }
                   if ($show_custom_text) {
                       imagettftext($my_image, $custom_font_size, 0, $custom_x + 1, $custom_y + 1, $grey, $font, $custom_text);
                       imagettftext($my_image, $custom_font_size, 0, $custom_x, $custom_y, $white, $font, $custom_text);
                   }
              }
              header("Content-type: image/jpeg");
              print imagejpeg($my_image, NULL, 90);
          } else {
              if (!$no_save_to_disk) {
                  header("Content-type: image/jpeg");
                  echo file_get_contents($filename);
              }
              else
                  print "";
              die();
          }
          if (!$no_save_to_disk)
              imagejpeg($my_image, $filename, 90);
      }
} else {
    if (!$no_save_to_disk) {
        header("Content-type: image/jpeg");
        echo file_get_contents($filename);
    }
    else
        print "";
}
?>